/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt.implclasses;

import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.implclasses.IndexConverter;
import org.eclipse.jubula.rc.common.implclasses.Verifier;
import org.eclipse.jubula.rc.swt.implclasses.AbstractControlImplClass;
import org.eclipse.swt.graphics.Rectangle;

public abstract class AbstractTabFolderImplClass
extends AbstractControlImplClass {
    public void gdSelectTabByIndex(int index) throws StepExecutionException {
        int implIdx = IndexConverter.toImplementationIndex((int)index);
        this.selectTabByImplIndex(implIdx);
    }

    private void selectTabByImplIndex(int index) {
        this.verifyIndexExists(index);
        this.ensureTabIsShowing(index);
        this.getRobot().click((Object)this.getComponent(), (Object)this.getBoundsAt(index), ClickOptions.create().left(), 25, false, 50, false);
    }

    public void gdVerifyTextOfTabByIndex(int index, String text, String operator) throws StepExecutionException {
        final int tabIndex = IndexConverter.toImplementationIndex((int)index);
        String tabTitle = (String)this.getEventThreadQueuer().invokeAndWait("verifyTextOfTabByIndex", new IRunnable(){

            public Object run() throws StepExecutionException {
                return AbstractTabFolderImplClass.this.getTitleOfTab(tabIndex);
            }
        });
        Verifier.match((String)tabTitle, (String)text, (String)operator);
    }

    public void gdVerifyExistenceOfTab(final String tab, final String operator, boolean exists) throws StepExecutionException {
        Boolean tabExists = (Boolean)this.getEventThreadQueuer().invokeAndWait("verifyExistenceOfTab", new IRunnable(){

            public Object run() throws StepExecutionException {
                return new Boolean(AbstractTabFolderImplClass.this.indexOrTitleOfTabExists(tab, operator));
            }
        });
        Verifier.equals((boolean)exists, (boolean)tabExists);
    }

    protected String removeShortcutSign(String tabName) {
        int shortCutIdx = tabName.indexOf("&");
        StringBuffer buf = new StringBuffer(tabName);
        if (shortCutIdx > -1) {
            buf.deleteCharAt(shortCutIdx);
            return buf.toString();
        }
        return tabName;
    }

    protected abstract void verifyIndexExists(int var1);

    protected abstract void ensureTabIsShowing(int var1);

    public void gdSelectTab(String title, String operator) throws StepExecutionException {
        this.selectTabByImplIndex(this.getIndexOfTab(title, operator));
    }

    protected abstract Rectangle getBoundsAt(int var1);

    protected abstract int getIndexOfTab(String var1, String var2);

    protected abstract String getTitleOfTab(int var1);

    protected abstract boolean indexOrTitleOfTabExists(String var1, String var2);
}

