/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt.implclasses;

import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.implclasses.Verifier;
import org.eclipse.jubula.rc.swt.implclasses.AbstractControlImplClass;
import org.eclipse.jubula.rc.swt.utils.SwtUtils;
import org.eclipse.swt.widgets.Button;

public class ButtonHelper {
    private AbstractControlImplClass m_implClass;
    private Button m_button;

    public ButtonHelper(AbstractControlImplClass implClass) {
        this.m_implClass = implClass;
        this.m_button = (Button)implClass.getComponent();
    }

    public void verifySelected(boolean selected) {
        Boolean actual = (Boolean)this.m_implClass.getEventThreadQueuer().invokeAndWait("isSelected", new IRunnable(){

            public Object run() {
                return ButtonHelper.this.m_button.getSelection() ? Boolean.TRUE : Boolean.FALSE;
            }
        });
        Verifier.equals((boolean)selected, (boolean)actual);
    }

    public String getText() {
        String text = (String)this.m_implClass.getEventThreadQueuer().invokeAndWait("getText", new IRunnable(){

            public Object run() throws StepExecutionException {
                return SwtUtils.removeMnemonics(ButtonHelper.this.m_button.getText());
            }
        });
        return text;
    }

    public void verifyText(String text, String operator) {
        String value = this.getText();
        Verifier.match((String)value, (String)text, (String)operator);
    }
}

