/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt.implclasses;

import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.implclasses.MatchUtil;
import org.eclipse.jubula.rc.common.implclasses.Verifier;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.rc.swt.implclasses.AbstractControlImplClass;
import org.eclipse.jubula.rc.swt.interfaces.ITextImplClass;
import org.eclipse.jubula.tools.objects.event.EventFactory;
import org.eclipse.jubula.tools.utils.TimeUtil;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class TextImplClass
extends AbstractControlImplClass
implements ITextImplClass {
    private static AutServerLogger log;
    private Text m_textComponent;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jubula.rc.swt.implclasses.TextImplClass");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = new AutServerLogger((Class)clazz);
    }

    private Text getTextComponent() {
        return (Text)this.getComponent();
    }

    public Control getComponent() {
        return this.m_textComponent;
    }

    public void setComponent(Object graphicsComponent) {
        this.m_textComponent = (Text)graphicsComponent;
    }

    private void setCaretPosition(int index) {
        if (index < 0) {
            throw new StepExecutionException("Invalid position: " + index, EventFactory.createActionError((String)"TestErrorEvent.InputFailed"));
        }
        int index2 = 0;
        String text = this.getText();
        if (text != null) {
            index2 = index > text.length() ? text.length() : index;
        }
        this.setSelection(index2);
    }

    protected String getText() {
        String actual = (String)this.getEventThreadQueuer().invokeAndWait("getText", new IRunnable(){

            public Object run() {
                return TextImplClass.this.getTextComponent().getText();
            }
        });
        return actual;
    }

    protected String getSelectionText() {
        String actual = (String)this.getEventThreadQueuer().invokeAndWait("getText", new IRunnable(){

            public Object run() {
                return TextImplClass.this.getTextComponent().getSelectionText();
            }
        });
        return actual;
    }

    public String gdReadValue(String variable) {
        return this.getText();
    }

    protected void insertText(String text) {
        this.getRobot().scrollToVisible((Object)this.getComponent(), null);
        this.getRobot().type((Object)this.getComponent(), text);
    }

    protected void selectAll() {
        String selectionText;
        String totalText = this.getText();
        try {
            this.getRobot().keyStroke(String.valueOf(this.getRobot().getSystemModifierSpec()) + " A");
        }
        catch (StepExecutionException see) {
            log.warn((Object)see);
        }
        if (!totalText.equals(this.getSelectionText())) {
            this.getEventThreadQueuer().invokeAndWait("text.selectAll", new IRunnable(){

                public Object run() {
                    TextImplClass.this.getTextComponent().selectAll();
                    return null;
                }
            });
        }
        if (!totalText.equals(selectionText = this.getSelectionText())) {
            log.warn((Object)("SelectAll failed!\nTotal text: '" + totalText + "'\n" + "Selected text: '" + selectionText + "'"));
        }
    }

    protected void setSelection(final int start, final int end) {
        this.getEventThreadQueuer().invokeAndWait("setSelection", new IRunnable(){

            public Object run() {
                TextImplClass.this.getTextComponent().setSelection(start, end);
                return null;
            }
        });
    }

    protected void setSelection(final int start) {
        this.getEventThreadQueuer().invokeAndWait("setSelection", new IRunnable(){

            public Object run() {
                TextImplClass.this.getTextComponent().setSelection(start);
                return null;
            }
        });
    }

    protected int getPatternIndex(String pattern) throws StepExecutionException {
        if (pattern == null || pattern.length() == 0) {
            throw new StepExecutionException("Invalid pattern for insertion", EventFactory.createActionError());
        }
        String tcText = this.getText();
        int index = tcText.indexOf(pattern);
        if (index == -1) {
            throw new StepExecutionException("The pattern '" + pattern + "' could not be found", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
        }
        return index;
    }

    public void gdVerifyText(String text, String operator) {
        Verifier.match((String)this.getText(), (String)text, (String)operator);
    }

    public void gdVerifyText(String text) {
        this.gdVerifyText(text, "equals");
    }

    public void gdReplaceText(String text) {
        this.gdSelect();
        if ("".equals(text)) {
            this.getRobot().keyType((Object)this.getComponent(), 127);
        }
        this.insertText(text);
    }

    public void gdInputText(String text) {
        if (!this.hasFocus()) {
            this.gdClick(1);
        }
        this.insertText(text);
    }

    public void gdInsertText(String text, int index) {
        this.gdClick(1);
        this.setCaretPosition(index);
        this.insertText(text);
    }

    public void gdInsertText(String text, String pattern, String operator, boolean after) throws StepExecutionException {
        if (text == null) {
            throw new StepExecutionException("The text to be inserted must not be null", EventFactory.createActionError());
        }
        MatchUtil.FindResult matchedText = MatchUtil.getInstance().find(this.getText(), pattern, operator);
        if (matchedText == null || matchedText.getStr() == null) {
            throw new StepExecutionException("The pattern '" + pattern + "' could not be found", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
        }
        int index = matchedText.getPos();
        int insertPos = after ? index + matchedText.getStr().length() : index;
        this.gdInsertText(text, insertPos);
    }

    public void gdVerifyEditable(boolean editable) {
        Verifier.equals((boolean)editable, (boolean)this.isEditable());
    }

    public void gdSelect() {
        this.gdClick(1);
        TimeUtil.delay((long)100L);
        this.selectAll();
    }

    public void gdSelect(String pattern, String operator) throws StepExecutionException {
        this.gdClick(1);
        MatchUtil.FindResult matchedText = MatchUtil.getInstance().find(this.getText(), pattern, operator);
        if (matchedText == null || matchedText.getStr().length() == 0) {
            throw new StepExecutionException("Invalid pattern for selection", EventFactory.createActionError());
        }
        int index = matchedText.getPos();
        if (operator.startsWith("not")) {
            if (pattern.equals(this.getText())) {
                String msg = "The pattern '" + pattern + "' is equal to current text";
                throw new StepExecutionException(msg, EventFactory.createActionError((String)"TestErrorEvent.ExecutionError", (Object[])new String[]{msg}));
            }
            if (index > 0) {
                this.setSelection(0, index);
            } else {
                this.setSelection(matchedText.getStr().length(), this.getText().length());
            }
        } else {
            this.setSelection(index, index + matchedText.getStr().length());
        }
    }

    protected boolean isEditable() {
        return (Boolean)this.getEventThreadQueuer().invokeAndWait("isEditable", new IRunnable(){

            public Object run() {
                return TextImplClass.this.getTextComponent().getEditable() && TextImplClass.this.getTextComponent().getEnabled() ? Boolean.TRUE : Boolean.FALSE;
            }
        });
    }

    public void gdClick(int count) {
        this.gdClick(count, 1);
    }

    public void gdClick(int count, int button) {
        this.gdClickDirect(count, button, 6, "Pixel", 50, "Percent");
    }

    public String[] getTextArrayFromComponent() {
        return null;
    }
}

