/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.tools.objects;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.eclipse.jubula.tools.i18n.CompSystemI18n;
import org.eclipse.jubula.tools.objects.IComponentIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentIdentifier
implements Serializable,
IComponentIdentifier {
    static final long serialVersionUID = 1031L;
    private static Logger log;
    private String m_supportedClassName = null;
    private List m_neighbours = new ArrayList();
    private String m_componentClassName = null;
    private List m_hierarchyNames = new ArrayList();
    private String m_alternativeDisplayName = null;
    private double m_matchPercentage = -1.0;
    private int m_numberOfOtherMatchingComponents = -1;
    private boolean m_equalOriginalFound = false;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jubula.tools.objects.ComponentIdentifier");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LoggerFactory.getLogger((Class)clazz);
    }

    public String getComponentClassName() {
        return this.m_componentClassName;
    }

    public void setComponentClassName(String componentClassName) {
        this.m_componentClassName = componentClassName;
    }

    public String getComponentName() {
        try {
            if (this.m_hierarchyNames != null && this.m_hierarchyNames.size() > 0) {
                return (String)this.m_hierarchyNames.get(this.m_hierarchyNames.size() - 1);
            }
        }
        catch (ClassCastException cce) {
            log.error("unexpected element type", (Throwable)cce);
        }
        return "";
    }

    public void setHierarchyNames(List hierarchyNames) {
        this.m_hierarchyNames = hierarchyNames == null ? new ArrayList() : hierarchyNames;
    }

    public List getHierarchyNames() {
        return this.m_hierarchyNames;
    }

    public void addHierarchyName(String hierarchyNames) {
        this.m_hierarchyNames.add(hierarchyNames);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("component type", (Object)this.m_componentClassName).append("alternative name", (Object)this.m_alternativeDisplayName).append("hierarchy", (Object)this.m_hierarchyNames).toString();
    }

    public void clearHierarchyNames() {
        this.m_hierarchyNames.clear();
    }

    public IComponentIdentifier makeClone() {
        ComponentIdentifier clone = new ComponentIdentifier();
        clone.setHierarchyNames(new ArrayList(this.m_hierarchyNames));
        clone.setComponentClassName(this.m_componentClassName);
        if (this.m_supportedClassName != null) {
            clone.setSupportedClassName(this.m_supportedClassName);
        }
        if (this.m_neighbours != null) {
            clone.setNeighbours(new ArrayList(this.m_neighbours));
        }
        clone.setAlternativeDisplayName(this.m_alternativeDisplayName);
        return clone;
    }

    public String getSupportedClassName() {
        return this.m_supportedClassName;
    }

    public void setSupportedClassName(String supportedClassName) {
        this.m_supportedClassName = supportedClassName;
    }

    public List getNeighbours() {
        return this.m_neighbours;
    }

    public void setNeighbours(List neighbours) {
        this.m_neighbours = neighbours;
    }

    public void addNeighbour(String neighbours) {
        this.m_neighbours.add(neighbours);
    }

    public String generateLogicalName() {
        String returnVal = null;
        String supportedClassName = this.getSupportedClassName();
        if (supportedClassName.lastIndexOf(".") > -1 && supportedClassName.length() > supportedClassName.lastIndexOf(".") + 1) {
            returnVal = this.checkDefaultMapping(supportedClassName);
            if (returnVal != null) {
                return returnVal;
            }
            returnVal = String.valueOf(supportedClassName.substring(supportedClassName.lastIndexOf(".") + 1)) + "(";
        } else {
            returnVal = String.valueOf(supportedClassName) + "(";
        }
        StringBuffer hash = new StringBuffer();
        Iterator iter = this.getHierarchyNames().iterator();
        while (iter.hasNext()) {
            hash.append((String)iter.next());
        }
        returnVal = String.valueOf(returnVal) + hash.toString().hashCode();
        returnVal = String.valueOf(returnVal) + ")";
        return returnVal;
    }

    private String checkDefaultMapping(String supportedClassName) {
        if ("com.bredexsw.guidancer.autserver.swing.implclasses.GraphicApplication".equals(supportedClassName) || "com.bredexsw.guidancer.autswtserver.implclasses.GraphicApplication".equals(supportedClassName)) {
            return CompSystemI18n.getString("CompSystem.LogicalApplicationName");
        }
        if ("org.eclipse.swt.widgets.Menu".equals(supportedClassName) || "javax.swing.JMenuBar".equals(supportedClassName)) {
            return CompSystemI18n.getString("CompSystem.LogicalMenuName");
        }
        return null;
    }

    public String getAlternativeDisplayName() {
        return this.m_alternativeDisplayName;
    }

    public void setAlternativeDisplayName(String alternativeDisplayName) {
        this.m_alternativeDisplayName = alternativeDisplayName;
    }

    public String getComponentNameToDisplay() {
        String componentNameToDisplay = this.m_alternativeDisplayName == null ? this.getComponentName() : this.m_alternativeDisplayName;
        return componentNameToDisplay;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IComponentIdentifier) {
            IComponentIdentifier compId = (IComponentIdentifier)obj;
            return new EqualsBuilder().append((Object)this.getHierarchyNames(), (Object)compId.getHierarchyNames()).append((Object)this.getNeighbours(), (Object)compId.getNeighbours()).isEquals();
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getHierarchyNames()).append((Object)this.getNeighbours()).toHashCode();
    }

    public void setMatchPercentage(double matchPercentage) {
        this.m_matchPercentage = matchPercentage;
    }

    public double getMatchPercentage() {
        return this.m_matchPercentage;
    }

    public void setNumberOfOtherMatchingComponents(int numberOfOtherMatchingComponents) {
        this.m_numberOfOtherMatchingComponents = numberOfOtherMatchingComponents;
    }

    public int getNumberOfOtherMatchingComponents() {
        return this.m_numberOfOtherMatchingComponents;
    }

    public void setEqualOriginalFound(boolean equalOriginalFound) {
        this.m_equalOriginalFound = equalOriginalFound;
    }

    public boolean isEqualOriginalFound() {
        return this.m_equalOriginalFound;
    }
}

