/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.util.LittleEndian;

public final class TabIdRecord
extends Record {
    public static final short sid = 317;
    public short[] field_1_tabids;

    public TabIdRecord() {
    }

    public TabIdRecord(RecordInputStream in) {
        this.field_1_tabids = new short[in.remaining() / 2];
        int k = 0;
        while (k < this.field_1_tabids.length) {
            this.field_1_tabids[k] = in.readShort();
            ++k;
        }
    }

    public void setTabIdArray(short[] array) {
        this.field_1_tabids = array;
    }

    public short[] getTabIdArray() {
        return this.field_1_tabids;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[TABID]\n");
        buffer.append("    .elements        = ").append(this.field_1_tabids.length).append("\n");
        int k = 0;
        while (k < this.field_1_tabids.length) {
            buffer.append("    .element_" + k + "       = ").append(this.field_1_tabids[k]).append("\n");
            ++k;
        }
        buffer.append("[/TABID]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        short[] tabids = this.getTabIdArray();
        int length = tabids.length * 2;
        int byteoffset = 4;
        LittleEndian.putUShort(data, 0 + offset, 317);
        LittleEndian.putUShort(data, 2 + offset, length);
        int k = 0;
        while (k < length / 2) {
            LittleEndian.putShort(data, byteoffset + offset, tabids[k]);
            byteoffset += 2;
            ++k;
        }
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 4 + this.getTabIdArray().length * 2;
    }

    public short getSid() {
        return 317;
    }
}

