/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers;

import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jubula.client.core.businessprocess.RunningAutBP;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.PoMaker;
import org.eclipse.jubula.client.core.persistence.EditSupport;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.IncompatibleTypeException;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.ui.handlers.AbstractSelectionBasedHandler;
import org.eclipse.jubula.client.ui.rcp.dialogs.AUTPropertiesDialog;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.tools.exception.JBException;
import org.eclipse.jubula.tools.exception.ProjectDeletedException;
import org.eclipse.jubula.tools.registration.AutIdentifier;
import org.eclipse.ui.handlers.HandlerUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateAutDefinitionHandler
extends AbstractSelectionBasedHandler {
    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object executeImpl(ExecutionEvent event) {
        Object selectedObject = this.getSelection().getFirstElement();
        if (!(selectedObject instanceof AutIdentifier)) return null;
        AutIdentifier autId = (AutIdentifier)selectedObject;
        IProjectPO currentProject = GeneralStorage.getInstance().getProject();
        if (currentProject == null || RunningAutBP.isAutDefined((AutIdentifier)autId)) return null;
        HashSet<String> existingNames = new HashSet<String>();
        for (IAUTMainPO aut : currentProject.getAutMainList()) {
            existingNames.add(aut.getName());
        }
        String autName = this.generateUniqueName(autId.getExecutableName(), existingNames);
        EditSupport es = null;
        try {
            try {
                es = new EditSupport((IPersistentObject)currentProject.getProjectProperties(), null);
                es.lockWorkVersion();
                IAUTMainPO newAut = PoMaker.createAUTMainPO((String)autName);
                newAut.getAutIds().add(autId.getExecutableName());
                for (Locale locale : es.getWorkProject().getLangHelper().getLanguageList()) {
                    newAut.getLangHelper().addLanguageToList(locale);
                }
                AUTPropertiesDialog newAutDialog = new AUTPropertiesDialog(HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getShell(), true, newAut, es.getWorkProject());
                newAutDialog.create();
                DialogUtils.setWidgetNameForModalDialog((Dialog)newAutDialog);
                newAutDialog.getShell().setText(Messages.AUTPropertyPageAUTConfig);
                if (newAutDialog.open() != 0) return null;
                es.getWorkProject().addAUTMain(newAut);
                es.saveWorkVersion();
                GeneralStorage.getInstance().getMasterSession().refresh((Object)GeneralStorage.getInstance().getProject().getAutCont());
                DataEventDispatcher.getInstance().fireProjectPropertiesModified();
                return null;
            }
            catch (PMException e) {
                ErrorHandlingUtil.createMessageDialog((JBException)((Object)e), null, null);
                if (es == null) return null;
                es.close();
                return null;
            }
            catch (ProjectDeletedException e) {
                ErrorHandlingUtil.createMessageDialog((JBException)((Object)e), null, null);
                if (es == null) return null;
                es.close();
                return null;
            }
            catch (IncompatibleTypeException e) {
                ErrorHandlingUtil.createMessageDialog((JBException)((Object)e), null, null);
                if (es == null) return null;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                es.close();
                return null;
            }
        }
        finally {
            if (es != null) {
                es.close();
            }
        }
    }

    private String generateUniqueName(String baseName, Set<String> existingNames) {
        String generatedName = baseName;
        int count = 1;
        while (existingNames.contains(generatedName)) {
            generatedName = String.valueOf(baseName) + count;
            ++count;
        }
        return generatedName;
    }
}

