/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.search.query;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.ICategoryPO;
import org.eclipse.jubula.client.core.model.IEventExecTestCasePO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITestDataCubePO;
import org.eclipse.jubula.client.core.model.ITestJobPO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.persistence.Persistor;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.rcp.search.data.AbstractSearchData;
import org.eclipse.jubula.client.ui.rcp.search.result.BasicSearchResult;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSearchQuery
implements ISearchQuery {
    private static PatternCompiler patternCompiler = new Perl5Compiler();
    private static PatternMatcher patternMatcher = new Perl5Matcher();
    private AbstractSearchData m_searchData;
    private BasicSearchResult m_searchResult;
    private Date m_timestamp = new Date();

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public String getTimestamp() {
        return DateFormat.getInstance().format(this.m_timestamp);
    }

    protected void setSearchData(AbstractSearchData searchData) {
        this.m_searchData = searchData;
    }

    protected AbstractSearchData getSearchData() {
        return this.m_searchData;
    }

    protected void setSearchResult(BasicSearchResult searchResult) {
        this.m_searchResult = searchResult;
    }

    public ISearchResult getSearchResult() {
        return this.m_searchResult;
    }

    protected List<BasicSearchResult.SearchResultElement> getSearchResultList(Set<INodePO> reuse, String viewId) {
        ArrayList<BasicSearchResult.SearchResultElement> searchResult = new ArrayList<BasicSearchResult.SearchResultElement>(reuse.size());
        for (INodePO node : reuse) {
            INodePO parent = node.getParentNode();
            String resultName = this.validParent(parent) ? String.valueOf(parent.getName()) + " / " + node.getName() : node.getName();
            searchResult.add(new BasicSearchResult.SearchResultElement<Long>(resultName, node.getId(), this.getImageForNode((IPersistentObject)node), new BasicSearchResult.NodeSearchResultElementAction(), node.getComment(), viewId));
        }
        return searchResult;
    }

    protected void setSearchResult(List<BasicSearchResult.SearchResultElement> reuseLoc) {
        BasicSearchResult sr = new BasicSearchResult(this);
        sr.setResultList(reuseLoc);
        this.setSearchResult(sr);
    }

    public Image getImageForNode(IPersistentObject po) {
        if (Persistor.isPoSubclass((IPersistentObject)po, IEventExecTestCasePO.class)) {
            return IconConstants.EH_IMAGE;
        }
        if (Persistor.isPoSubclass((IPersistentObject)po, ICapPO.class)) {
            return IconConstants.CAP_IMAGE;
        }
        if (Persistor.isPoSubclass((IPersistentObject)po, ISpecTestCasePO.class)) {
            return IconConstants.TC_IMAGE;
        }
        if (Persistor.isPoSubclass((IPersistentObject)po, ICategoryPO.class)) {
            return IconConstants.CATEGORY_IMAGE;
        }
        if (Persistor.isPoSubclass((IPersistentObject)po, ITestSuitePO.class)) {
            return IconConstants.TS_IMAGE;
        }
        if (Persistor.isPoSubclass((IPersistentObject)po, IExecTestCasePO.class)) {
            return IconConstants.TC_REF_IMAGE;
        }
        if (Persistor.isPoSubclass((IPersistentObject)po, ITestJobPO.class)) {
            return IconConstants.TJ_IMAGE;
        }
        if (Persistor.isPoSubclass((IPersistentObject)po, ITestDataCubePO.class)) {
            return IconConstants.TDC_IMAGE;
        }
        return null;
    }

    private boolean validParent(INodePO parent) {
        return parent != null && !(parent instanceof IProjectPO);
    }

    public String getLabel() {
        return String.valueOf(this.getTimestamp()) + ": " + this.getSearchData().getSearchName();
    }

    public static boolean compare(String string, String pattern, int operation) {
        switch (operation) {
            case 1: {
                return string.toLowerCase().indexOf(pattern.toLowerCase()) != -1;
            }
            case 2: {
                return string.indexOf(pattern) != -1;
            }
            case 3: {
                try {
                    Pattern p = patternCompiler.compile(pattern);
                    return patternMatcher.matches(string, p);
                }
                catch (MalformedPatternException malformedPatternException) {
                    return false;
                }
            }
        }
        return string.toLowerCase().indexOf(pattern.toLowerCase()) != -1;
    }
}

