/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.views;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jubula.client.core.businessprocess.db.NodeBP;
import org.eclipse.jubula.client.core.events.DataChangedEvent;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.ICategoryPO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.IReusedProjectPO;
import org.eclipse.jubula.client.core.model.ISpecObjContPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.actions.CutTreeItemActionTCBrowser;
import org.eclipse.jubula.client.ui.rcp.actions.MoveTestCaseAction;
import org.eclipse.jubula.client.ui.rcp.actions.PasteTreeItemActionTCBrowser;
import org.eclipse.jubula.client.ui.rcp.constants.RCPCommandIDs;
import org.eclipse.jubula.client.ui.rcp.controllers.dnd.LocalSelectionClipboardTransfer;
import org.eclipse.jubula.client.ui.rcp.controllers.dnd.LocalSelectionTransfer;
import org.eclipse.jubula.client.ui.rcp.controllers.dnd.TCBrowserDndSupport;
import org.eclipse.jubula.client.ui.rcp.controllers.dnd.TestSpecDropTargetListener;
import org.eclipse.jubula.client.ui.rcp.controllers.dnd.TreeViewerContainerDragSourceListener;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.provider.DecoratingCellLabelProvider;
import org.eclipse.jubula.client.ui.rcp.provider.contentprovider.TestCaseBrowserContentProvider;
import org.eclipse.jubula.client.ui.rcp.provider.labelprovider.TestCaseBrowserLabelProvider;
import org.eclipse.jubula.client.ui.rcp.utils.SelectionChecker;
import org.eclipse.jubula.client.ui.rcp.views.AbstractJBTreeView;
import org.eclipse.jubula.client.ui.utils.CommandHelper;
import org.eclipse.jubula.client.ui.views.IJBPart;
import org.eclipse.jubula.client.ui.views.ITreeViewerContainer;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.actions.ActionFactory;

public class TestCaseBrowser
extends AbstractJBTreeView
implements ITreeViewerContainer,
IJBPart {
    public static final String NEW_ID = "org.eclipse.ui.NewSubMenu";
    public static final String OPEN_WITH_ID = "org.eclipse.ui.OpenWithSubMenu";
    public static final String ADD_ID = "org.eclipse.ui.AddSubMenu";
    private CutTreeItemActionTCBrowser m_cutTreeItemAction;
    private PasteTreeItemActionTCBrowser m_pasteTreeItemAction;
    private MoveTestCaseAction m_moveTestCaseAction;
    private ActionListener m_actionListener;
    private final DoubleClickListener m_doubleClickListener = new DoubleClickListener();

    public void createPartControl(Composite parent) {
        this.m_cutTreeItemAction = new CutTreeItemActionTCBrowser();
        this.m_pasteTreeItemAction = new PasteTreeItemActionTCBrowser();
        this.m_moveTestCaseAction = new MoveTestCaseAction();
        super.createPartControl(parent);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.getTreeViewer());
        this.getTreeViewer().setContentProvider((IContentProvider)new TestCaseBrowserContentProvider());
        DecoratingCellLabelProvider lp = new DecoratingCellLabelProvider(new TestCaseBrowserLabelProvider(), Plugin.getDefault().getWorkbench().getDecoratorManager().getLabelDecorator());
        this.getTreeViewer().setLabelProvider((IBaseLabelProvider)lp);
        int ops = 2;
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getInstance()};
        this.getTreeViewer().addDragSupport(ops, transfers, (DragSourceListener)new TreeViewerContainerDragSourceListener(this.getTreeViewer()));
        this.getTreeViewer().addDropSupport(ops, transfers, (DropTargetListener)new TestSpecDropTargetListener(this));
        this.registerContextMenu();
        Plugin.getHelpSystem().setHelp(this.getTreeViewer().getControl(), "org.eclipse.jubula.client.ua.help.testSpecificationViewContextId");
        this.configureActionBars();
        if (GeneralStorage.getInstance().getProject() != null) {
            this.handleProjectLoaded();
        }
    }

    private void configureActionBars() {
        this.getTreeFilterText().addFocusListener(new FocusListener(){
            private IAction m_defaultCutAction;
            private IAction m_defaultPasteAction;
            {
                this.m_defaultCutAction = TestCaseBrowser.this.getViewSite().getActionBars().getGlobalActionHandler(ActionFactory.CUT.getId());
                this.m_defaultPasteAction = TestCaseBrowser.this.getViewSite().getActionBars().getGlobalActionHandler(ActionFactory.PASTE.getId());
            }

            public void focusGained(FocusEvent e) {
                TestCaseBrowser.this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.CUT.getId(), this.m_defaultCutAction);
                TestCaseBrowser.this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.PASTE.getId(), this.m_defaultPasteAction);
                TestCaseBrowser.this.getViewSite().getActionBars().updateActionBars();
            }

            public void focusLost(FocusEvent e) {
                TestCaseBrowser.this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)TestCaseBrowser.this.m_cutTreeItemAction);
                TestCaseBrowser.this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)TestCaseBrowser.this.m_pasteTreeItemAction);
                TestCaseBrowser.this.getViewSite().getActionBars().updateActionBars();
            }
        });
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)this.m_cutTreeItemAction);
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.m_pasteTreeItemAction);
        this.getViewSite().getActionBars().setGlobalActionHandler("org.eclipse.jubula.client.ui.rcp.actions.MoveTestCaseAction", (IAction)this.m_moveTestCaseAction);
        this.getViewSite().getWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this.m_actionListener);
        this.getViewSite().getActionBars().updateActionBars();
    }

    protected void createContextMenu(IMenuManager mgr) {
        MenuManager submenuNew = new MenuManager(Messages.TestSuiteBrowserNew, NEW_ID);
        MenuManager submenuAdd = new MenuManager(Messages.TestSuiteBrowserAdd, ADD_ID);
        MenuManager submenuOpenWith = new MenuManager(Messages.TestSuiteBrowserOpenWith, OPEN_WITH_ID);
        mgr.add((IContributionItem)submenuNew);
        mgr.add((IContributionItem)submenuAdd);
        CommandHelper.createContributionPushItem((IMenuManager)submenuNew, (String)"org.eclipse.jubula.client.ui.rcp.commands.NewTestCaseCommand");
        CommandHelper.createContributionPushItem((IMenuManager)submenuNew, (String)"org.eclipse.jubula.client.ui.rcp.commands.CreateNewCategoryCommand");
        mgr.add((IContributionItem)new Separator());
        CommandHelper.createContributionPushItem((IMenuManager)mgr, (String)"org.eclipse.ui.edit.rename");
        mgr.add((IAction)this.m_moveTestCaseAction);
        mgr.add(CommandHelper.createContributionItem((String)RCPCommandIDs.FIND_COMMAND_ID, null, (String)Messages.FindContextMenu, (int)8));
        mgr.add((IAction)this.m_cutTreeItemAction);
        mgr.add((IAction)this.m_pasteTreeItemAction);
        CommandHelper.createContributionPushItem((IMenuManager)mgr, (String)"org.eclipse.ui.edit.delete");
        CommandHelper.createContributionPushItem((IMenuManager)mgr, (String)"org.eclipse.jubula.client.ui.commands.OpenSpecification");
        CommandHelper.createContributionPushItem((IMenuManager)mgr, (String)"org.eclipse.jubula.client.ui.commands.ShowSpecification");
        CommandHelper.createContributionPushItem((IMenuManager)mgr, (String)"org.eclipse.jubula.client.ui.rcp.commands.ShowWhereUsed");
        CommandHelper.createContributionPushItem((IMenuManager)mgr, (String)"org.eclipse.jubula.client.ui.commands.ExpandTreeItem");
        mgr.add((IContributionItem)new Separator());
        CommandHelper.createContributionPushItem((IMenuManager)mgr, (String)"org.eclipse.jubula.client.ui.rcp.commands.CopyID");
        mgr.add((IContributionItem)new Separator());
        CommandHelper.createContributionPushItem((IMenuManager)submenuOpenWith, (String)"org.eclipse.jubula.client.ui.rcp.commands.OpenTestcaseEditor");
        mgr.add((IContributionItem)new Separator());
        mgr.add((IContributionItem)submenuOpenWith);
        mgr.add((IContributionItem)new GroupMarker("additions"));
    }

    protected void addTreeListener() {
        this.getTreeViewer().addDoubleClickListener((IDoubleClickListener)this.m_doubleClickListener);
        this.m_actionListener = new ActionListener();
    }

    public void setFocus() {
        this.getTreeViewer().getControl().setFocus();
        Plugin.showStatusLine((IWorkbenchPart)this);
    }

    IStructuredSelection getActualSelection() {
        ISelection selection = this.getViewSite().getSelectionProvider().getSelection();
        return selection instanceof IStructuredSelection ? (IStructuredSelection)selection : StructuredSelection.EMPTY;
    }

    public void dispose() {
        try {
            DataEventDispatcher ded = DataEventDispatcher.getInstance();
            ded.removeDataChangedListener((DataEventDispatcher.IDataChangedListener)this);
            this.getViewSite().getWorkbenchWindow().getSelectionService().removeSelectionListener((ISelectionListener)this.m_actionListener);
            this.getTreeViewer().removeDoubleClickListener((IDoubleClickListener)this.m_doubleClickListener);
        }
        finally {
            super.dispose();
        }
    }

    protected void rebuildTree() {
        IProjectPO activeProject = GeneralStorage.getInstance().getProject();
        if (activeProject != null) {
            this.getTreeViewer().setInput((Object)new ISpecObjContPO[]{activeProject.getSpecObjCont()});
            this.getTreeViewer().expandToLevel(2);
        } else {
            this.getTreeViewer().setInput(null);
        }
    }

    public void handleDataChanged(DataChangedEvent ... events) {
        DataChangedEvent[] dataChangedEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            DataChangedEvent e = dataChangedEventArray[n2];
            this.handleDataChanged(e.getPo(), e.getDataState(), e.getUpdateState());
            ++n2;
        }
    }

    public void handleDataChanged(final IPersistentObject po, final DataEventDispatcher.DataState dataState, final DataEventDispatcher.UpdateState updateState) {
        Plugin.getDisplay().syncExec(new Runnable(){

            public void run() {
                if (po instanceof IAUTMainPO || po instanceof ITestSuitePO) {
                    return;
                }
                if (updateState == DataEventDispatcher.UpdateState.onlyInEditor) {
                    return;
                }
                if (po instanceof IReusedProjectPO) {
                    TestCaseBrowser.this.handleProjectLoaded();
                    return;
                }
                switch (dataState) {
                    case Added: {
                        TestCaseBrowser.this.handleDataAdded(po, (IProgressMonitor)new NullProgressMonitor());
                        break;
                    }
                    case Deleted: {
                        TestCaseBrowser.this.handleDataDeleted(po);
                        break;
                    }
                    case Renamed: {
                        TestCaseBrowser.this.handleDataRenamed(po);
                        break;
                    }
                    case StructureModified: {
                        TestCaseBrowser.this.handleDataStructureModified(po);
                        break;
                    }
                }
            }
        });
    }

    private void handleDataStructureModified(IPersistentObject po) {
        if (po instanceof INodePO) {
            this.getTreeViewer().getTree().getParent().setRedraw(false);
            Object[] expandedElements = this.getTreeViewer().getExpandedElements();
            ISelection selection = this.getTreeViewer().getSelection();
            if (po instanceof IProjectPO) {
                this.rebuildTree();
            }
            this.getTreeViewer().refresh();
            this.getTreeViewer().setExpandedElements(expandedElements);
            this.getTreeViewer().setSelection(selection);
            this.getTreeViewer().getTree().getParent().setRedraw(true);
        }
    }

    private void handleDataRenamed(IPersistentObject po) {
        if (po instanceof ISpecTestCasePO || po instanceof ICategoryPO || po instanceof IExecTestCasePO) {
            this.getTreeViewer().refresh(true);
        }
    }

    private void handleDataDeleted(IPersistentObject po) {
        if (po instanceof ISpecTestCasePO || po instanceof ICategoryPO) {
            if (this.getTreeViewer() != null) {
                Plugin.getDisplay().syncExec(new Runnable(){

                    public void run() {
                        TestCaseBrowser.this.getTreeViewer().refresh();
                    }
                });
            }
        } else if (po instanceof IProjectPO) {
            Plugin.getDisplay().syncExec(new Runnable(){

                public void run() {
                    TestCaseBrowser.this.getTreeViewer().setInput(null);
                    TestCaseBrowser.this.getTreeViewer().refresh();
                }
            });
        }
    }

    private void handleDataAdded(IPersistentObject po, IProgressMonitor monitor) {
        if (po instanceof ISpecTestCasePO || po instanceof ICategoryPO) {
            this.getTreeViewer().refresh();
            this.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)po), true);
        } else if (po instanceof IProjectPO) {
            this.handleProjectLoaded();
        }
    }

    private final class ActionListener
    implements ISelectionListener {
        private ActionListener() {
        }

        private void enableCutAction(INodePO[] selList) {
            TestCaseBrowser.this.m_cutTreeItemAction.setEnabled(false);
            INodePO[] iNodePOArray = selList;
            int n = selList.length;
            int n2 = 0;
            while (n2 < n) {
                INodePO guiNode = iNodePOArray[n2];
                if (!(guiNode instanceof ICategoryPO) && !(guiNode instanceof ISpecTestCasePO) || !NodeBP.isEditable((IPersistentObject)guiNode)) {
                    TestCaseBrowser.this.m_cutTreeItemAction.setEnabled(false);
                    return;
                }
                ++n2;
            }
            TestCaseBrowser.this.m_cutTreeItemAction.setEnabled(true);
        }

        private void enablePasteAction(INodePO[] selList) {
            TestCaseBrowser.this.m_pasteTreeItemAction.setEnabled(false);
            Object cbContents = TestCaseBrowser.this.getClipboard().getContents((Transfer)LocalSelectionClipboardTransfer.getInstance());
            INodePO[] iNodePOArray = selList;
            int n = selList.length;
            int n2 = 0;
            while (n2 < n) {
                INodePO guiNode = iNodePOArray[n2];
                if (!((guiNode instanceof ICategoryPO || guiNode instanceof ISpecTestCasePO || guiNode instanceof IProjectPO) && NodeBP.isEditable((IPersistentObject)guiNode) && cbContents instanceof IStructuredSelection && TCBrowserDndSupport.canMove((IStructuredSelection)cbContents, guiNode))) {
                    TestCaseBrowser.this.m_pasteTreeItemAction.setEnabled(false);
                    return;
                }
                ++n2;
            }
            TestCaseBrowser.this.m_pasteTreeItemAction.setEnabled(true);
        }

        private void enableMoveAction(INodePO[] selList) {
            TestCaseBrowser.this.m_moveTestCaseAction.setEnabled(false);
            INodePO[] iNodePOArray = selList;
            int n = selList.length;
            int n2 = 0;
            while (n2 < n) {
                INodePO guiNode = iNodePOArray[n2];
                if (!(guiNode instanceof ICategoryPO) && !(guiNode instanceof ISpecTestCasePO) || !NodeBP.isEditable((IPersistentObject)guiNode)) {
                    TestCaseBrowser.this.m_moveTestCaseAction.setEnabled(false);
                    return;
                }
                ++n2;
            }
            TestCaseBrowser.this.m_moveTestCaseAction.setEnabled(true);
        }

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            boolean isNullProject;
            if (!(selection instanceof IStructuredSelection)) {
                return;
            }
            boolean isThisPart = part == TestCaseBrowser.this;
            boolean bl = isNullProject = GeneralStorage.getInstance().getProject() == null;
            if (isNullProject || selection == null || selection.isEmpty()) {
                TestCaseBrowser.this.m_cutTreeItemAction.setEnabled(false);
                TestCaseBrowser.this.m_pasteTreeItemAction.setEnabled(false);
                TestCaseBrowser.this.m_moveTestCaseAction.setEnabled(false);
                return;
            }
            if (!isThisPart) {
                TestCaseBrowser.this.m_moveTestCaseAction.setEnabled(false);
            } else {
                IStructuredSelection sel = (IStructuredSelection)selection;
                Object[] selectedElements = sel.toArray();
                INodePO[] selectedNodes = new INodePO[selectedElements.length];
                int i = 0;
                while (i < selectedElements.length) {
                    if (!(selectedElements[i] instanceof INodePO)) {
                        TestCaseBrowser.this.m_cutTreeItemAction.setEnabled(false);
                        TestCaseBrowser.this.m_pasteTreeItemAction.setEnabled(false);
                        TestCaseBrowser.this.m_moveTestCaseAction.setEnabled(false);
                        return;
                    }
                    selectedNodes[i] = (INodePO)selectedElements[i];
                    ++i;
                }
                this.enableCutAction(selectedNodes);
                this.enablePasteAction(selectedNodes);
                this.enableMoveAction(selectedNodes);
            }
        }
    }

    private final class DoubleClickListener
    implements IDoubleClickListener {
        private DoubleClickListener() {
        }

        public void doubleClick(DoubleClickEvent event) {
            IStructuredSelection selection = TestCaseBrowser.this.getActualSelection();
            int[] counter = SelectionChecker.selectionCounter(selection);
            if (counter[8] == selection.size() || counter[7] == selection.size()) {
                CommandHelper.executeCommand((String)"org.eclipse.jubula.client.ui.rcp.commands.NewTestCaseCommand", (IWorkbenchPartSite)TestCaseBrowser.this.getSite());
            } else {
                CommandHelper.executeCommand((String)"org.eclipse.jubula.client.ui.rcp.commands.OpenTestcaseEditor", (IWorkbenchPartSite)TestCaseBrowser.this.getSite());
            }
        }
    }
}

