/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.wizards.refactor.pages;

import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.widgets.TestCaseTreeComposite;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public class ChooseTestCasePage
extends WizardPage {
    private INodePO m_parentTestCase;
    private ISpecTestCasePO m_choosenTestCase = null;

    public ChooseTestCasePage(INodePO parentTestCase, String pageId) {
        super(pageId, Messages.ReplaceTCRWizard_choosePage_title, null);
        this.m_parentTestCase = parentTestCase;
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        final TestCaseTreeComposite tctc = new TestCaseTreeComposite(parent, 4, this.m_parentTestCase);
        tctc.getTreeViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                boolean pageComplete = false;
                ISpecTestCasePO specTC = null;
                if (tctc.hasValidSelection()) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    pageComplete = true;
                    specTC = (ISpecTestCasePO)selection.getFirstElement();
                }
                ChooseTestCasePage.this.setChoosenTestCase(specTC);
                ChooseTestCasePage.this.setPageComplete(pageComplete);
            }
        });
        this.setControl((Control)tctc);
    }

    public void performHelp() {
        PlatformUI.getWorkbench().getHelpSystem().displayHelp("org.eclipse.jubula.client.ua.help.refactorReplaceChooseTestCaseWizardPagePageContextId");
    }

    private void setChoosenTestCase(ISpecTestCasePO choosenTestCase) {
        this.m_choosenTestCase = choosenTestCase;
    }

    public ISpecTestCasePO getChoosenTestCase() {
        return this.m_choosenTestCase;
    }
}

