/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.jmx;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.jmx.JMXConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.status.StatusUtil;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class MBeanUtil {
    static final String DOMAIN = "ch.qos.logback.classic";

    public static String getObjectNameFor(String contextName, Class type) {
        String objectNameAsStr = "ch.qos.logback.classic:Name=" + contextName + ",Type=" + type.getName();
        return objectNameAsStr;
    }

    public static ObjectName string2ObjectName(Context context, Object caller, String objectNameAsStr) {
        String msg = "Failed to convert [" + objectNameAsStr + "] to ObjectName";
        try {
            return new ObjectName(objectNameAsStr);
        }
        catch (MalformedObjectNameException e) {
            StatusUtil.addError((Context)context, (Object)caller, (String)msg, (Throwable)e);
            return null;
        }
        catch (NullPointerException e) {
            StatusUtil.addError((Context)context, (Object)caller, (String)msg, (Throwable)e);
            return null;
        }
    }

    public static boolean isRegistered(MBeanServer mbs, ObjectName objectName) {
        return mbs.isRegistered(objectName);
    }

    public static void createAndRegisterJMXConfigurator(MBeanServer mbs, LoggerContext loggerContext, JMXConfigurator jmxConfigurator, ObjectName objectName, Object caller) {
        try {
            mbs.registerMBean(jmxConfigurator, objectName);
        }
        catch (Exception e) {
            StatusUtil.addError((Context)loggerContext, (Object)caller, (String)"Failed to create mbean", (Throwable)e);
        }
    }

    public static void unregister(LoggerContext loggerContext, MBeanServer mbs, ObjectName objectName, Object caller) {
        if (mbs.isRegistered(objectName)) {
            try {
                StatusUtil.addInfo((Context)loggerContext, (Object)caller, (String)("Unregistering mbean [" + objectName + "]"));
                mbs.unregisterMBean(objectName);
            }
            catch (InstanceNotFoundException e) {
                StatusUtil.addError((Context)loggerContext, (Object)caller, (String)("Failed to unregister mbean" + objectName), (Throwable)e);
            }
            catch (MBeanRegistrationException e) {
                StatusUtil.addError((Context)loggerContext, (Object)caller, (String)("Failed to unregister mbean" + objectName), (Throwable)e);
            }
        } else {
            StatusUtil.addInfo((Context)loggerContext, (Object)caller, (String)("mbean [" + objectName + "] does not seem to be registered"));
        }
    }
}

