/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.autagent.monitoring;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jubula.autagent.monitoring.IMonitoring;

public class MonitoringDataStore {
    private static MonitoringDataStore instance;
    private Map<String, Map<String, String>> m_dataStoreMap = new HashMap<String, Map<String, String>>();
    private Map<String, IMonitoring> m_monitoringAgentMap = new HashMap<String, IMonitoring>();

    private MonitoringDataStore() {
    }

    public static synchronized MonitoringDataStore getInstance() {
        if (instance == null) {
            instance = new MonitoringDataStore();
        }
        return instance;
    }

    public synchronized void putConfigMap(String autId, Map<String, String> map) {
        this.m_dataStoreMap.put(autId, map);
    }

    public Map<String, String> getConfigMap(String autId) {
        return this.m_dataStoreMap.get(autId);
    }

    public synchronized void putMonitoringAgent(String autId, IMonitoring monitoringInstance) {
        this.m_monitoringAgentMap.put(autId, monitoringInstance);
    }

    public synchronized IMonitoring getMonitoringAgent(String autId) {
        if (this.m_monitoringAgentMap.containsKey(autId)) {
            return this.m_monitoringAgentMap.get(autId);
        }
        return null;
    }

    public synchronized void removeConfigMap(String autId) {
        if (this.m_dataStoreMap.containsKey(autId)) {
            this.m_dataStoreMap.remove(autId);
        }
    }

    public void removeAgent(String autId) {
        this.m_monitoringAgentMap.remove(autId);
    }

    public void removeAllAgents() {
        this.m_monitoringAgentMap.clear();
    }

    public void removeAllConfigMaps() {
        this.m_dataStoreMap.clear();
    }

    public synchronized void putConfigValue(String autId, String key, String value) {
        this.m_dataStoreMap.get(autId).put(key, value);
    }

    public synchronized String getConfigValue(String autID, String key) {
        if (this.m_dataStoreMap.containsKey(autID)) {
            return this.m_dataStoreMap.get(autID).get(key);
        }
        return null;
    }
}

