/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.persistence.PersistenceException;
import org.apache.commons.lang.Validate;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jubula.client.core.businessprocess.ExternalTestDataBP;
import org.eclipse.jubula.client.core.businessprocess.IComponentNameMapper;
import org.eclipse.jubula.client.core.businessprocess.MasterSessionComponentNameMapper;
import org.eclipse.jubula.client.core.businessprocess.compcheck.ProblemPropagator;
import org.eclipse.jubula.client.core.businessprocess.progress.OperationCanceledUtil;
import org.eclipse.jubula.client.core.errorhandling.ErrorMessagePresenter;
import org.eclipse.jubula.client.core.errorhandling.IErrorMessagePresenter;
import org.eclipse.jubula.client.core.progress.IProgressConsole;
import org.eclipse.jubula.client.core.utils.Languages;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.editors.TestResultViewer;
import org.eclipse.jubula.client.ui.rcp.businessprocess.CompletenessBP;
import org.eclipse.jubula.client.ui.rcp.businessprocess.ComponentNameReuseBP;
import org.eclipse.jubula.client.ui.rcp.businessprocess.ImportFileBP;
import org.eclipse.jubula.client.ui.rcp.businessprocess.ProblemsBP;
import org.eclipse.jubula.client.ui.rcp.businessprocess.ToolkitBP;
import org.eclipse.jubula.client.ui.rcp.businessprocess.WorkingLanguageBP;
import org.eclipse.jubula.client.ui.rcp.constants.RcpIconConstants;
import org.eclipse.jubula.client.ui.rcp.controllers.TestExecutionContributor;
import org.eclipse.jubula.client.ui.rcp.editors.AbstractJBEditor;
import org.eclipse.jubula.client.ui.rcp.editors.AbstractTestCaseEditor;
import org.eclipse.jubula.client.ui.rcp.editors.IJBEditor;
import org.eclipse.jubula.client.ui.rcp.editors.TestJobEditor;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.provider.contentprovider.DirtyStarListContentProvider;
import org.eclipse.jubula.client.ui.rcp.provider.labelprovider.DirtyStarListLabelProvider;
import org.eclipse.jubula.client.ui.rcp.search.query.AbstractSearchQuery;
import org.eclipse.jubula.client.ui.rcp.widgets.StatusLineContributionItem;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.client.ui.utils.ImageUtils;
import org.eclipse.jubula.client.ui.views.IJBPart;
import org.eclipse.jubula.tools.exception.JBException;
import org.eclipse.jubula.tools.exception.JBFatalException;
import org.eclipse.jubula.tools.exception.JBRuntimeException;
import org.eclipse.jubula.tools.i18n.CompSystemI18n;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.osgi.util.NLS;
import org.eclipse.search.ui.IQueryListener;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search2.internal.ui.SearchView;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.IContributedContentsView;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Plugin
extends AbstractUIPlugin
implements IProgressConsole {
    public static final String PLUGIN_ID = "org.eclipse.jubula.client.ui.rcp";
    private static final String JB_CONSOLE_NAME = "Console";
    private static Logger log = LoggerFactory.getLogger(Plugin.class);
    private static Plugin plugin;
    private static String statusLineText;
    private static int connectionStatusIcon;
    private static IWorkbenchWindow workbenchWindow;
    private static Map<ImageDescriptor, Image> imageCache;
    private static final String CONNECTION_INFO_STATUSLINE_ITEM = "connectionInfo";
    private static final String AUT_TOOLKIT_STATUSLINE_ITEM = "autToolKitInfo";
    private static final String LANG_STATUSLINE_ITEM = "lang";
    private ClientStatus m_status = ClientStatus.STARTING;
    private List<String> m_dirtyEditors;
    private ScopedPreferenceStore m_preferenceStore = null;
    private MessageConsole m_console;
    private MessageConsoleStream m_standardMessageStream;
    private MessageConsoleStream m_errorMessageStream;
    private String m_runningApplicationTitle = null;

    static {
        statusLineText = Messages.StatusLine_NotConnected;
        connectionStatusIcon = 0;
        imageCache = new HashMap<ImageDescriptor, Image>();
    }

    public void setClientStatus(ClientStatus statust) {
        this.m_status = statust;
    }

    public ClientStatus getClientStatus() {
        return this.m_status;
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
    }

    public IPreferenceStore getPreferenceStore() {
        if (this.m_preferenceStore == null) {
            this.m_preferenceStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.jubula.client.ui");
        }
        return this.m_preferenceStore;
    }

    public static Display getDisplay() {
        return PlatformUI.getWorkbench().getDisplay();
    }

    private static void setStatusLineText(String text) {
        statusLineText = text;
        Plugin.showStatusLine(null);
    }

    public static String getStatusLineText() {
        return statusLineText;
    }

    public static void showStatusLine(final int ampel, final String text) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                Plugin.setConnectionStatusIcon(ampel);
                Plugin.setStatusLineText(text);
            }
        });
    }

    public static void showStatusLine(IWorkbenchPart partFocused) {
        IWorkbench workbench = Plugin.getDefault().getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (Plugin.getActivePage() == null && partFocused == null) {
            return;
        }
        IWorkbenchPart part = partFocused != null ? partFocused : Plugin.getActivePart();
        StatusLineManager manager = ((WorkbenchWindow)window).getStatusLineManager();
        if (part instanceof ViewPart) {
            manager = ((ViewPart)part).getViewSite().getActionBars().getStatusLineManager();
        } else if (part instanceof EditorPart) {
            manager = ((EditorPart)part).getEditorSite().getActionBars().getStatusLineManager();
        }
        if (window instanceof WorkbenchWindow) {
            StatusLineContributionItem item = (StatusLineContributionItem)manager.find(CONNECTION_INFO_STATUSLINE_ITEM);
            if (item == null) {
                if (Plugin.getDefault().getWorkbench().getActiveWorkbenchWindow() != null) {
                    Plugin.createStatusLineItems();
                    item = (StatusLineContributionItem)manager.find(CONNECTION_INFO_STATUSLINE_ITEM);
                }
                if (item == null) {
                    return;
                }
            }
            switch (Plugin.isConnectionStatusIcon()) {
                case 0: {
                    item.setMessage(RcpIconConstants.NO_SERVER_IMAGE, Plugin.getStatusLineText());
                    break;
                }
                case 1: 
                case 2: {
                    item.setMessage(RcpIconConstants.NO_CONNECTION_IMAGE, Plugin.getStatusLineText());
                    break;
                }
                case 3: {
                    item.setMessage(IconConstants.AUT_RUNNING_IMAGE, Plugin.getStatusLineText());
                    break;
                }
                case 4: {
                    item.setMessage(RcpIconConstants.CAM_IMAGE, Plugin.getStatusLineText());
                    break;
                }
                case 7: {
                    item.setMessage(RcpIconConstants.CHECK_CAM_IMAGE, Plugin.getStatusLineText());
                    break;
                }
                case 5: {
                    item.setMessage(RcpIconConstants.MAP_IMAGE, Plugin.getStatusLineText());
                    break;
                }
                case 6: {
                    item.setMessage(RcpIconConstants.PAUSE_IMAGE, Plugin.getStatusLineText());
                    break;
                }
                default: {
                    item.setMessage(RcpIconConstants.NO_AUT_IMAGE, Plugin.getStatusLineText());
                }
            }
            manager.update(true);
        }
    }

    public static Image getImage(String fileName) {
        ImageDescriptor descriptor = null;
        descriptor = Plugin.getImageDescriptor(fileName);
        Image image = imageCache.get(descriptor);
        if (image == null) {
            image = descriptor.createImage();
            imageCache.put(descriptor, image);
        }
        return image;
    }

    public static ImageDescriptor getImageDescriptor(String name) {
        return ImageUtils.getImageDescriptor((Bundle)Plugin.getDefault().getBundle(), (String)name);
    }

    public static ViewPart getActiveView() {
        IWorkbenchPart view = Plugin.getActivePart();
        if (view instanceof ViewPart) {
            return (ViewPart)view;
        }
        return null;
    }

    public static IEditorPart getActiveEditor() {
        IEditorReference[] editorReferences;
        IWorkbenchPage activePage = Plugin.getActivePage();
        if (activePage == null) {
            return null;
        }
        IEditorPart editor = activePage.getActiveEditor();
        if (editor != null) {
            return editor;
        }
        IEditorReference[] iEditorReferenceArray = editorReferences = activePage.getEditorReferences();
        int n = editorReferences.length;
        int n2 = 0;
        while (n2 < n) {
            IJBEditor gdEd;
            IEditorReference edRef = iEditorReferenceArray[n2];
            IEditorPart editorPart = edRef.getEditor(false);
            if (editorPart instanceof IJBEditor && (gdEd = (IJBEditor)editorPart).getEditorHelper().isActive()) {
                return gdEd;
            }
            ++n2;
        }
        return null;
    }

    public static List<IEditorReference> getAllEditors() {
        if (Plugin.getActivePage() == null) {
            return new ArrayList<IEditorReference>();
        }
        IEditorReference[] editors = Plugin.getActivePage().getEditorReferences();
        ArrayList<IEditorReference> editorList = new ArrayList<IEditorReference>();
        IEditorReference[] iEditorReferenceArray = editors;
        int n = editors.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference editor = iEditorReferenceArray[n2];
            if (editor.getId().equals("org.eclipse.jubula.client.ui.rcp.editors.TestCaseEditor") || editor.getId().equals("org.eclipse.jubula.client.ui.rcp.editors.ObjectMappingEditor") || editor.getId().equals("org.eclipse.jubula.client.ui.rcp.editors.TestSuiteEditor")) {
                editorList.add(editor);
            }
            ++n2;
        }
        return editorList;
    }

    public static IWorkbenchPart getActivePart() {
        if (Plugin.getActivePage() != null) {
            return Plugin.getActivePage().getActivePart();
        }
        return null;
    }

    public static IPerspectiveDescriptor getActivePerspective() {
        if (Plugin.getActivePage() != null) {
            return Plugin.getActivePage().getPerspective();
        }
        return null;
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow ww = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (ww == null) {
            return null;
        }
        return ww.getActivePage();
    }

    public static IViewPart getView(String id) {
        Validate.notEmpty((String)id, (String)Messages.Missing_ID);
        if (Plugin.getActivePage() != null) {
            IViewPart vp = Plugin.getActivePage().findView(id);
            return vp;
        }
        return null;
    }

    public void writeLineToConsole(String msg, boolean forceActivate) {
        if (PlatformUI.isWorkbenchRunning()) {
            MessageConsoleStream stream = this.getStandardConsoleStream();
            if (forceActivate) {
                stream.getConsole().activate();
            }
            stream.println(msg);
        }
    }

    public void writeErrorLineToConsole(String msg, boolean forceActivate) {
        if (PlatformUI.isWorkbenchRunning()) {
            MessageConsoleStream stream = this.getErrorConsoleStream();
            if (forceActivate) {
                stream.getConsole().activate();
            }
            stream.println(msg);
        }
    }

    private synchronized MessageConsoleStream getStandardConsoleStream() {
        if (this.m_standardMessageStream == null) {
            this.m_standardMessageStream = this.getConsole().newMessageStream();
        }
        return this.m_standardMessageStream;
    }

    private synchronized MessageConsoleStream getErrorConsoleStream() {
        if (this.m_errorMessageStream == null) {
            this.m_errorMessageStream = this.getConsole().newMessageStream();
            final Display d = Plugin.getDisplay();
            final MessageConsoleStream stream = this.m_errorMessageStream;
            d.syncExec(new Runnable(){

                public void run() {
                    stream.setColor(d.getSystemColor(3));
                }
            });
        }
        return this.m_errorMessageStream;
    }

    private synchronized MessageConsole getConsole() {
        if (this.m_console == null) {
            this.m_console = new MessageConsole(JB_CONSOLE_NAME, null);
            this.m_console.activate();
            ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{this.m_console});
        }
        return this.m_console;
    }

    public static IViewPart showView(String id) {
        return Plugin.showView(id, null, 1);
    }

    public static IViewPart showView(String viewID, String secondaryViewID, int mode) {
        Validate.notEmpty((String)viewID, (String)Messages.Missing_ID);
        if (Plugin.getActivePage() != null) {
            IViewPart vp = null;
            try {
                vp = Plugin.getActivePage().showView(viewID, secondaryViewID, mode);
            }
            catch (PartInitException partInitException) {
                ErrorHandlingUtil.createMessageDialog((JBException)new JBException(NLS.bind((String)(String.valueOf(Messages.PluginCantOpenView) + viewID), (Object)MessageIDs.E_CLASS_NOT_FOUND), null, null));
            }
            return vp;
        }
        return null;
    }

    public static int isConnectionStatusIcon() {
        return connectionStatusIcon;
    }

    private static void setConnectionStatusIcon(int aS) {
        connectionStatusIcon = aS;
        Plugin.showStatusLine(null);
    }

    public static IEditorPart getEditorByTitle(String title) {
        IEditorReference[] editors = Plugin.getActivePage().getEditorReferences();
        int i = 0;
        while (i < editors.length) {
            String edTitle = editors[i].getTitle();
            if (title.equals(edTitle)) {
                return (IEditorPart)editors[i].getPart(false);
            }
            ++i;
        }
        return null;
    }

    public static boolean isViewOpen(String id) {
        return Plugin.getView(id) != null;
    }

    public List<String> getDirtyEditorNames() {
        return this.m_dirtyEditors;
    }

    public IEditorPart[] getDirtyEditors() {
        if (Plugin.getActivePage() != null) {
            return Plugin.getActivePage().getDirtyEditors();
        }
        return new IEditorPart[0];
    }

    public void setDirtyEditorNames(List<String> dirtyEditors) {
        this.m_dirtyEditors = dirtyEditors;
    }

    public AbstractJBEditor getActiveGDEditor() {
        IWorkbenchPage activePage = Plugin.getActivePage();
        if (activePage == null) {
            return null;
        }
        IEditorPart iEditorPart = Plugin.getActiveEditor();
        if (iEditorPart != null && iEditorPart instanceof AbstractJBEditor) {
            return (AbstractJBEditor)iEditorPart;
        }
        return null;
    }

    public AbstractTestCaseEditor getActiveTCEditor() {
        if (this.getActiveGDEditor() instanceof AbstractTestCaseEditor) {
            return (AbstractTestCaseEditor)this.getActiveGDEditor();
        }
        return null;
    }

    public TestJobEditor getActiveTJEditor() {
        IWorkbenchPage activePage = Plugin.getActivePage();
        if (activePage == null) {
            return null;
        }
        IEditorPart iEditorPart = Plugin.getActiveEditor();
        if (iEditorPart != null && iEditorPart instanceof TestJobEditor) {
            return (TestJobEditor)iEditorPart;
        }
        return null;
    }

    public static void closeAllOpenedJubulaEditors(boolean alsoProjectIndependent) {
        IWorkbenchPage activePage = Plugin.getActivePage();
        if (activePage != null) {
            HashSet<IEditorReference> editorRefSet = new HashSet<IEditorReference>();
            IEditorReference[] iEditorReferenceArray = activePage.getEditorReferences();
            int n = iEditorReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference editorRef = iEditorReferenceArray[n2];
                IEditorPart editor = editorRef.getEditor(true);
                if (editor instanceof IJBPart) {
                    if (alsoProjectIndependent) {
                        editorRefSet.add(editorRef);
                    } else if (!(editor instanceof TestResultViewer)) {
                        editorRefSet.add(editorRef);
                    }
                }
                ++n2;
            }
            activePage.closeEditors(editorRefSet.toArray(new IEditorReference[editorRefSet.size()]), false);
        }
    }

    public static Shell getActiveWorkbenchWindowShell() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    public static Shell getShell() {
        return PlatformUI.getWorkbench().getDisplay().getShells()[0];
    }

    public boolean anyDirtyStar() {
        boolean isDirtyStar = false;
        IEditorPart[] editors = Plugin.getActivePage().getDirtyEditors();
        this.setDirtyEditorNames(new ArrayList<String>());
        int t = 0;
        while (t < editors.length) {
            if (editors[t].isDirty()) {
                isDirtyStar = true;
                this.m_dirtyEditors.add(editors[t].getTitle());
            }
            ++t;
        }
        return isDirtyStar;
    }

    public boolean showSaveEditorDialog() {
        ListSelectionDialog dialog = new ListSelectionDialog(Plugin.getShell(), this.m_dirtyEditors, (IStructuredContentProvider)new DirtyStarListContentProvider(), (ILabelProvider)new DirtyStarListLabelProvider(), Messages.StartSuiteActionMessage);
        dialog.setTitle(Messages.StartSuiteActionTitle);
        dialog.setInitialSelections(this.m_dirtyEditors.toArray());
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            int t = 0;
            while (t < dialog.getResult().length) {
                Plugin.getEditorByTitle(dialog.getResult()[t].toString()).doSave((IProgressMonitor)new NullProgressMonitor());
                ++t;
            }
            Plugin.setNormalCursor();
            return true;
        }
        Plugin.setNormalCursor();
        return false;
    }

    private static void setWaitCursor() {
        Plugin.getDisplay().syncExec(new Runnable(){

            public void run() {
                Plugin.getActiveWorkbenchWindowShell().setCursor(Plugin.getDisplay().getSystemCursor(1));
            }
        });
    }

    private static void setNormalCursor() {
        Plugin.getDisplay().syncExec(new Runnable(){

            public void run() {
                Plugin.getActiveWorkbenchWindowShell().setCursor(Plugin.getDisplay().getSystemCursor(0));
            }
        });
    }

    public static IWorkbenchHelpSystem getHelpSystem() {
        return PlatformUI.getWorkbench().getHelpSystem();
    }

    public Object handleError(final Throwable e) {
        Plugin.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (e instanceof RuntimeException && OperationCanceledUtil.isOperationCanceled((RuntimeException)((RuntimeException)e))) {
                    return;
                }
                log.error(String.valueOf(Messages.UnhandledThrowable) + " " + ":" + " ", e);
                if (e instanceof JBRuntimeException) {
                    JBRuntimeException gdEx = (JBRuntimeException)e;
                    ErrorHandlingUtil.createMessageDialog((JBRuntimeException)gdEx);
                } else if (e instanceof JBException) {
                    JBException gdEx = (JBException)e;
                    ErrorHandlingUtil.createMessageDialog((JBException)gdEx, null, null);
                } else if (Plugin.isRCPException(e)) {
                    log.error(Messages.InternalRcpError, e);
                } else if (Plugin.isGEFException(e)) {
                    log.error(Messages.InternalGefError, e);
                } else if (e instanceof PersistenceException) {
                    ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.E_DATABASE_GENERAL, null, (String[])new String[]{e.getLocalizedMessage()});
                } else {
                    ErrorHandlingUtil.createMessageDialog((JBRuntimeException)new JBFatalException(e, MessageIDs.E_UNEXPECTED_EXCEPTION));
                }
            }
        });
        return null;
    }

    public static boolean isRCPException(Throwable t) {
        Throwable work = t;
        do {
            StackTraceElement[] stack;
            StackTraceElement[] stackTraceElementArray = stack = work.getStackTrace();
            int n = stack.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement el = stackTraceElementArray[n2];
                if (el.getClassName().indexOf("MarkerAdapter") != -1) {
                    return true;
                }
                if (el.getClassName().indexOf("EngineResultSection") != -1) {
                    return true;
                }
                if (el.getClassName().indexOf("ContextHelpPart") != -1) {
                    return true;
                }
                if (el.getClassName().indexOf("CompositeImageDescriptor") != -1) {
                    return true;
                }
                ++n2;
            }
            String detailMessage = work.getMessage();
            if (detailMessage == null || detailMessage.indexOf("WARNING: Prevented recursive attempt to activate part") == -1) continue;
            return true;
        } while ((work = work.getCause()) != null);
        return false;
    }

    public static boolean isContentAssistException(Throwable t) {
        Throwable work = t;
        do {
            StackTraceElement[] stack;
            if (!(work instanceof NullPointerException)) continue;
            StackTraceElement[] stackTraceElementArray = stack = work.getStackTrace();
            int n = stack.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement el = stackTraceElementArray[n2];
                if (Messages.RecomputeProposals.equals(el.getMethodName())) {
                    return true;
                }
                ++n2;
            }
        } while ((work = work.getCause()) != null);
        return false;
    }

    public static boolean isGEFException(Throwable t) {
        Throwable work = t;
        do {
            StackTraceElement[] stack;
            StackTraceElement[] stackTraceElementArray = stack = work.getStackTrace();
            int n = stack.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement el = stackTraceElementArray[n2];
                if (el.getClassName().indexOf("DragEditPartsTrackerEx") != -1) {
                    return true;
                }
                ++n2;
            }
        } while ((work = work.getCause()) != null);
        return false;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        ErrorMessagePresenter.setPresenter((IErrorMessagePresenter)new IErrorMessagePresenter(){

            public void showErrorMessage(JBException ex, Object[] params, String[] details) {
                ErrorHandlingUtil.createMessageDialog((JBException)ex, (Object[])params, (String[])details);
            }

            public void showErrorMessage(Integer messageID, Object[] params, String[] details) {
                ErrorHandlingUtil.createMessageDialog((Integer)messageID, (Object[])params, (String[])details);
            }
        });
        new Thread(new Runnable(){

            public void run() {
                Languages.getInstance();
            }
        }).start();
        this.registerPermanentServices();
    }

    private void registerPermanentServices() {
        ProblemsBP.getInstance();
        TestExecutionContributor.getInstance();
        this.propagateDataDir();
        Plugin.getDefault().getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                Plugin.this.propagateDataDir();
            }
        });
        this.registerSearchResultListener();
        ImportFileBP.getInstance();
        CompletenessBP.getInstance();
        ProblemPropagator.getInstance();
        ComponentNameReuseBP.getInstance();
        ToolkitBP.getInstance();
    }

    public static void showLangInfo() {
        Plugin.getDisplay().syncExec(new Runnable(){

            public void run() {
                IStatusLineManager manager = Plugin.getStatusLineManager();
                StatusLineContributionItem item = (StatusLineContributionItem)manager.find(Plugin.LANG_STATUSLINE_ITEM);
                if (item == null) {
                    return;
                }
                if (WorkingLanguageBP.getInstance().getWorkingLanguage() != null) {
                    item.setText(WorkingLanguageBP.getInstance().getWorkingLanguage().getDisplayName());
                } else {
                    item.setText("");
                }
                manager.update(true);
            }
        });
    }

    public static void showAutToolKitInfo(String toolkit) {
        IStatusLineManager manager = Plugin.getStatusLineManager();
        StatusLineContributionItem item = (StatusLineContributionItem)manager.find(AUT_TOOLKIT_STATUSLINE_ITEM);
        if (item == null) {
            return;
        }
        item.setText(CompSystemI18n.getString((String)toolkit));
        manager.update(true);
    }

    public static void createStatusLineItems() {
        IStatusLineManager manager = Plugin.getStatusLineManager();
        StatusLineContributionItem connectionItem = new StatusLineContributionItem(CONNECTION_INFO_STATUSLINE_ITEM);
        manager.insertBefore("END_GROUP", (IContributionItem)connectionItem);
        StatusLineContributionItem langItem = new StatusLineContributionItem(LANG_STATUSLINE_ITEM);
        manager.insertBefore(CONNECTION_INFO_STATUSLINE_ITEM, (IContributionItem)langItem);
        StatusLineContributionItem autToolKitItem = new StatusLineContributionItem(AUT_TOOLKIT_STATUSLINE_ITEM);
        autToolKitItem.setText("");
        manager.insertBefore(LANG_STATUSLINE_ITEM, (IContributionItem)autToolKitItem);
        manager.update(true);
    }

    public static IStatusLineManager getStatusLineManager() {
        IWorkbench workbench = Plugin.getDefault().getWorkbench();
        workbenchWindow = workbench.getActiveWorkbenchWindow();
        if (workbenchWindow == null) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    Shell shell = Plugin.getShell();
                    while (shell != null) {
                        Object data = shell.getData();
                        if (data instanceof IWorkbenchWindow) {
                            workbenchWindow = (IWorkbenchWindow)data;
                            break;
                        }
                        shell = (Shell)shell.getParent();
                    }
                }
            });
        }
        StatusLineManager manager = ((WorkbenchWindow)workbenchWindow).getStatusLineManager();
        return manager;
    }

    public static void stopLongRunning() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                Plugin.getStatusLineManager().setErrorMessage(null);
                Plugin.setNormalCursor();
            }
        });
    }

    public static void startLongRunning(final String message) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                Plugin.getStatusLineManager().setErrorMessage(Plugin.getImage("longRunning.gif"), message);
                Plugin.startLongRunning();
            }
        });
    }

    public static void startLongRunning() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                Plugin.setWaitCursor();
            }
        });
    }

    public static IComponentNameMapper getActiveCompMapper() {
        IWorkbenchPart activePart = Plugin.getActivePart();
        if (activePart instanceof IContributedContentsView) {
            activePart = ((IContributedContentsView)activePart).getContributingPart();
        }
        IComponentNameMapper mapper = null;
        if (activePart != null) {
            mapper = (IComponentNameMapper)activePart.getAdapter(IComponentNameMapper.class);
        }
        if (mapper != null) {
            return mapper;
        }
        return MasterSessionComponentNameMapper.getInstance();
    }

    public void writeErrorLine(String line) {
        this.writeErrorLineToConsole(line, true);
    }

    public void writeLine(String line) {
        this.writeLineToConsole(line, true);
    }

    public String getRunningApplicationTitle() {
        if (this.m_runningApplicationTitle == null) {
            this.m_runningApplicationTitle = Plugin.getActiveWorkbenchWindowShell().getText();
        }
        return this.m_runningApplicationTitle;
    }

    private void registerSearchResultListener() {
        NewSearchUI.addQueryListener((IQueryListener)new IQueryListener(){

            public void queryAdded(ISearchQuery query) {
            }

            public void queryFinished(final ISearchQuery query) {
                if (query instanceof AbstractSearchQuery) {
                    PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                        public void run() {
                            SearchView sv = (SearchView)Plugin.getView("org.eclipse.search.ui.views.SearchView");
                            if (sv != null) {
                                sv.showSearchResult(query.getSearchResult());
                            }
                        }
                    });
                }
            }

            public void queryRemoved(ISearchQuery query) {
            }

            public void queryStarting(ISearchQuery query) {
            }
        });
    }

    private void propagateDataDir() {
        IPreferenceStore preferenceStore = Plugin.getDefault().getPreferenceStore();
        if (!preferenceStore.getBoolean("DATADIR_WS_KEY")) {
            ExternalTestDataBP.setDataDir((File)new File(preferenceStore.getString("DATADIR_PATH_KEY")));
        } else {
            ExternalTestDataBP.setDataDir((File)Platform.getLocation().toFile());
        }
    }

    public static Plugin getDefault() {
        return plugin;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ClientStatus {
        RUNNING,
        STARTING,
        STOPPING;

    }
}

