/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.properties;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jubula.client.core.businessprocess.db.TimestampBP;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.IReusedProjectPO;
import org.eclipse.jubula.client.core.model.ITimestampPO;
import org.eclipse.jubula.client.core.model.PoMaker;
import org.eclipse.jubula.client.core.persistence.EditSupport;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.NodePM;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.Persistor;
import org.eclipse.jubula.client.core.persistence.ProjectPM;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.properties.AbstractProjectPropertyPage;
import org.eclipse.jubula.client.ui.rcp.properties.ProjectGeneralPropertyPage;
import org.eclipse.jubula.client.ui.rcp.widgets.TreeElementChooserComposite;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.client.ui.utils.LayoutUtil;
import org.eclipse.jubula.toolkit.common.businessprocess.ToolkitSupportBP;
import org.eclipse.jubula.toolkit.common.exception.ToolkitPluginException;
import org.eclipse.jubula.tools.exception.JBException;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.persistence.jpa.JpaEntityManager;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;

public class ProjectUsedPropertyPage
extends AbstractProjectPropertyPage
implements ProjectGeneralPropertyPage.IOkListener {
    private Tree m_availableProjectsList;
    private org.eclipse.swt.widgets.List m_usedProjectsList;
    private Map<String, IReusedProjectPO> m_projectMap = new HashMap<String, IReusedProjectPO>();
    private UsedProjectsChooserComposite m_chooseLists = null;
    private String[] m_listEntries;

    public ProjectUsedPropertyPage(EditSupport es) {
        super(es);
    }

    protected Control createContents(Composite parent) {
        Composite composite = this.createComposite(parent, 4, false);
        this.noDefaultAndApplyButton();
        this.createLabel(composite, Messages.ProjectPropertyPageSelectReusedProjects);
        Composite innerComposite = new Composite(composite, 0);
        GridLayout compositeLayout = new GridLayout();
        compositeLayout.marginHeight = 0;
        compositeLayout.marginWidth = 0;
        innerComposite.setLayout((Layout)compositeLayout);
        GridData compositeData = new GridData();
        compositeData.horizontalAlignment = 4;
        compositeData.grabExcessHorizontalSpace = true;
        innerComposite.setLayoutData((Object)compositeData);
        try {
            this.createProjectLists(innerComposite);
            this.getObjects();
            this.resizeLists();
        }
        catch (ToolkitPluginException tpe) {
            composite.dispose();
            composite = this.createComposite(parent, 4, false);
            new Label(composite, 0).setText(String.valueOf(Messages.CouldNotLoadReusableProjects) + ":" + "\n" + "\t" + tpe.getLocalizedMessage());
        }
        Plugin.getHelpSystem().setHelp((Control)parent, "org.eclipse.jubula.client.ua.help.projectUsedPropertyPageContextId");
        return composite;
    }

    private void createProjectLists(Composite innerComposite) throws ToolkitPluginException {
        Set usedProjects = this.getProject().getUsedProjects();
        HashSet<ReusedProjectGuiObject> availableGuiObjects = new HashSet<ReusedProjectGuiObject>();
        HashSet<ReusedProjectGuiObject> usedGuiObjects = new HashSet<ReusedProjectGuiObject>();
        try {
            String projectToolkit = this.getProject().getToolkit();
            List reusableProjects = ProjectPM.findReusableProjects((String)this.getProject().getGuid(), (int)this.getProject().getMajorProjectVersion(), (int)this.getProject().getMinorProjectVersion(), (String)projectToolkit, (String)ToolkitSupportBP.getToolkitLevel((String)projectToolkit));
            for (IProjectPO proj : reusableProjects) {
                IReusedProjectPO reused = PoMaker.createReusedProjectPO((IProjectPO)proj);
                ReusedProjectGuiObject reusedGui = new ReusedProjectGuiObject(reused);
                availableGuiObjects.add(reusedGui);
                this.m_projectMap.put(reusedGui.getDisplayString(), reused);
            }
            for (IReusedProjectPO reused : usedProjects) {
                ReusedProjectGuiObject guiObj = new ReusedProjectGuiObject(reused);
                usedGuiObjects.add(guiObj);
                this.m_projectMap.put(guiObj.getDisplayString(), reused);
            }
            this.m_chooseLists = new UsedProjectsChooserComposite(innerComposite, availableGuiObjects, usedGuiObjects);
        }
        catch (JBException gde) {
            ErrorHandlingUtil.createMessageDialog((JBException)gde, null, null);
        }
        catch (ToolkitPluginException tpe) {
            ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.E_READ_PROJECT, null, (String[])new String[]{Messages.CannotFindReusableProjects});
            throw tpe;
        }
    }

    private void resizeLists() {
        ((GridData)this.m_usedProjectsList.getLayoutData()).widthHint = Dialog.convertHeightInCharsToPixels((FontMetrics)LayoutUtil.getFontMetrics((Control)this.m_usedProjectsList), (int)15);
        ((GridData)this.m_availableProjectsList.getLayoutData()).widthHint = Dialog.convertHeightInCharsToPixels((FontMetrics)LayoutUtil.getFontMetrics((Control)this.m_usedProjectsList), (int)15);
    }

    private Composite createComposite(Composite parent, int alignment, boolean horizontalSpace) {
        Composite composite = new Composite(parent, 0);
        GridLayout compositeLayout = new GridLayout();
        compositeLayout.marginHeight = 0;
        compositeLayout.marginWidth = 0;
        composite.setLayout((Layout)compositeLayout);
        GridData compositeData = new GridData();
        compositeData.horizontalAlignment = alignment;
        compositeData.grabExcessHorizontalSpace = horizontalSpace;
        composite.setLayoutData((Object)compositeData);
        return composite;
    }

    private void getObjects() {
        this.m_availableProjectsList = this.m_chooseLists.getAvailableTree();
        this.m_usedProjectsList = this.m_chooseLists.getUsedList();
    }

    private Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
        GridData labelGrid = new GridData(1, 2, false, false, 1, 1);
        label.setLayoutData((Object)labelGrid);
        return label;
    }

    void updateProjects(String[] usedProjects) throws PMException {
        HashSet<IReusedProjectPO> toAdd = new HashSet<IReusedProjectPO>();
        HashSet toRemove = new HashSet();
        String[] stringArray = usedProjects;
        int n = usedProjects.length;
        int n2 = 0;
        while (n2 < n) {
            String displayableProjectId = stringArray[n2];
            toAdd.add(this.m_projectMap.get(displayableProjectId));
            ++n2;
        }
        toRemove.addAll(this.getEditSupport().getWorkProject().getUsedProjects());
        toRemove.removeAll(toAdd);
        toAdd.removeAll(this.getEditSupport().getWorkProject().getUsedProjects());
        for (IReusedProjectPO remove : toRemove) {
            this.getEditSupport().getWorkProject().removeUsedProject(remove);
        }
        boolean isDirty = ((JpaEntityManager)this.getEditSupport().getSession().unwrap(JpaEntityManager.class)).getUnitOfWork().hasChanges();
        Persistor.instance().flushSession(this.getEditSupport().getSession());
        if (isDirty) {
            TimestampBP.refreshTimestamp((ITimestampPO)this.getEditSupport().getWorkProject());
        }
        for (IReusedProjectPO reuse : toAdd) {
            this.getEditSupport().getWorkProject().addUsedProject(reuse);
            reuse.setParentProjectId(this.getProject().getId());
        }
    }

    public void okPressed() throws PMException {
        if (this.m_listEntries != null) {
            this.updateProjects(this.m_listEntries);
        }
    }

    private class ReusedProjectGuiObject
    implements TreeElementChooserComposite.IChooserCompositeGuiObject {
        private static final String VER_SEP = ".";
        private static final String BEGIN_VER = " [";
        private static final String END_VER = "]";
        private IReusedProjectPO m_modelObject;

        public ReusedProjectGuiObject(IReusedProjectPO modelObject) {
            this.m_modelObject = modelObject;
        }

        public String getDisplayString() {
            String projectName = this.m_modelObject.getProjectName();
            if (projectName == null) {
                projectName = this.m_modelObject.getProjectGuid();
            }
            StringBuffer sb = new StringBuffer(projectName);
            sb.append(BEGIN_VER);
            sb.append(this.m_modelObject.getMajorNumber());
            sb.append(VER_SEP);
            sb.append(this.m_modelObject.getMinorNumber());
            sb.append(END_VER);
            return sb.toString();
        }

        public Object getModelObject() {
            return this.m_modelObject;
        }

        public String getParent() {
            return this.m_modelObject.getProjectName();
        }

        public String getTitle() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.m_modelObject.getMajorNumber());
            sb.append(VER_SEP);
            sb.append(this.m_modelObject.getMinorNumber());
            return sb.toString();
        }

        public String toString() {
            return this.getDisplayString();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ReusedProjectGuiObject)) {
                return false;
            }
            ReusedProjectGuiObject otherGui = (ReusedProjectGuiObject)obj;
            return this.getDisplayString().equals(otherGui.getDisplayString());
        }

        public int hashCode() {
            return this.getDisplayString().hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class UsedProjectsChooserComposite
    extends TreeElementChooserComposite
    implements TreeElementChooserComposite.IUsedListModifiedListener {
        private UsedProjectsChooserComposite(Composite innerComposite, Set<TreeElementChooserComposite.IChooserCompositeGuiObject> availableGuiObjects, Set<TreeElementChooserComposite.IChooserCompositeGuiObject> usedGuiObjects) {
            super(innerComposite, Messages.ProjectPropertyPageReusableProjectsUpperLabel, availableGuiObjects, Messages.ProjectPropertyPageReusableProjectsBottomLabel, usedGuiObjects, 15, new Image[]{IconConstants.RIGHT_ARROW_IMAGE, IconConstants.DOUBLE_RIGHT_ARROW_IMAGE, IconConstants.LEFT_ARROW_IMAGE, IconConstants.DOUBLE_LEFT_ARROW_IMAGE, IconConstants.SWAP_ARROW_IMAGE}, new Image[]{IconConstants.RIGHT_ARROW_DIS_IMAGE, IconConstants.DOUBLE_RIGHT_ARROW_DIS_IMAGE, IconConstants.LEFT_ARROW_DIS_IMAGE, IconConstants.DOUBLE_LEFT_ARROW_DIS_IMAGE, IconConstants.SWAP_ARROW_DIS_IMAGE}, new String[]{Messages.ProjectPropertyPageReusableProjectsDownToolTip, Messages.ProjectPropertyPageReusableProjectsAllDownToolTip, Messages.ProjectPropertyPageReusableProjectsUpToolTip, Messages.ProjectPropertyPageReusableProjectsAllUpToolTip, Messages.ProjectPropertyPageReusableProjectsSwapToolTip}, 1);
            this.addListModifiedListener(this);
        }

        @Override
        protected String checkSelectionUsedToAvailable(String[] selection) {
            String[] stringArray = selection;
            int n = selection.length;
            int n2 = 0;
            while (n2 < n) {
                List execTcNames;
                String reusedName = stringArray[n2];
                IReusedProjectPO reused = (IReusedProjectPO)ProjectUsedPropertyPage.this.m_projectMap.get(reusedName);
                if (reused != null && (execTcNames = NodePM.getUsedTestCaseNames((IProjectPO)GeneralStorage.getInstance().getProject(), (IReusedProjectPO)reused)) != null && !execTcNames.isEmpty()) {
                    return ((IExecTestCasePO)execTcNames.get(0)).getName();
                }
                ++n2;
            }
            return null;
        }

        @Override
        public void usedListModified(String[] newListEntries) {
            ProjectUsedPropertyPage.this.m_listEntries = newListEntries;
        }
    }
}

