/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.sourceprovider;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jubula.client.core.events.DataChangedEvent;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.ui.rcp.businessprocess.StartAutBP;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.sourceprovider.AbstractJBSourceProvider;
import org.eclipse.jubula.client.ui.utils.JobUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AvailableAutSourceProvider
extends AbstractJBSourceProvider
implements DataEventDispatcher.ILanguageChangedListener,
DataEventDispatcher.IServerConnectionListener,
DataEventDispatcher.IProjectPropertiesModifyListener,
DataEventDispatcher.IProjectLoadedListener,
DataEventDispatcher.IDataChangedListener {
    public static final String IS_AUT_AVAILABLE = "org.eclipse.jubula.client.ui.rcp.variable.isAutAvailable";

    public AvailableAutSourceProvider() {
        DataEventDispatcher dispatcher = DataEventDispatcher.getInstance();
        dispatcher.addLanguageChangedListener((DataEventDispatcher.ILanguageChangedListener)this, true);
        dispatcher.addAutAgentConnectionListener((DataEventDispatcher.IServerConnectionListener)this, true);
        dispatcher.addProjectPropertiesModifyListener((DataEventDispatcher.IProjectPropertiesModifyListener)this, true);
        dispatcher.addProjectLoadedListener((DataEventDispatcher.IProjectLoadedListener)this, true);
        dispatcher.addDataChangedListener((DataEventDispatcher.IDataChangedListener)this, true);
    }

    public void dispose() {
        DataEventDispatcher dispatcher = DataEventDispatcher.getInstance();
        dispatcher.removeLanguageChangedListener((DataEventDispatcher.ILanguageChangedListener)this);
        dispatcher.removeAutAgentConnectionListener((DataEventDispatcher.IServerConnectionListener)this);
        dispatcher.removeProjectPropertiesModifyListener((DataEventDispatcher.IProjectPropertiesModifyListener)this);
        dispatcher.removeProjectLoadedListener((DataEventDispatcher.IProjectLoadedListener)this);
        dispatcher.removeDataChangedListener((DataEventDispatcher.IDataChangedListener)this);
    }

    public Map<String, Object> getCurrentState() {
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put(IS_AUT_AVAILABLE, this.isAutAvailable());
        return values;
    }

    public String[] getProvidedSourceNames() {
        return new String[]{IS_AUT_AVAILABLE};
    }

    public void handleLanguageChanged(Locale locale) {
        this.fireSourceChanged();
    }

    public void handleServerConnStateChanged(DataEventDispatcher.ServerState state) {
        this.fireSourceChanged();
    }

    private void fireSourceChanged() {
        final String jobName = Messages.UIJobResolvingStartableAuts;
        Job resolveStartableAUTs = new Job(jobName){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(jobName, -1);
                AvailableAutSourceProvider.this.gdFireSourceChanged(0, AvailableAutSourceProvider.IS_AUT_AVAILABLE, AvailableAutSourceProvider.this.isAutAvailable());
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        JobUtils.executeJob((Job)resolveStartableAUTs, null);
    }

    private boolean isAutAvailable() {
        return !StartAutBP.getInstance().getAllAUTs().isEmpty();
    }

    public void handleProjectPropsChanged() {
        this.fireSourceChanged();
    }

    public void handleProjectLoaded() {
        this.fireSourceChanged();
    }

    public void handleDataChanged(DataChangedEvent ... events) {
        DataChangedEvent[] dataChangedEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            DataChangedEvent e = dataChangedEventArray[n2];
            this.handleDataChanged(e.getPo(), e.getDataState());
            ++n2;
        }
    }

    public void handleDataChanged(IPersistentObject po, DataEventDispatcher.DataState dataState) {
        if (po instanceof IProjectPO && dataState == DataEventDispatcher.DataState.Deleted) {
            this.fireSourceChanged();
        }
    }
}

