/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.analyze.ui.renderer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jubula.client.analyze.internal.AnalyzeResult;
import org.eclipse.jubula.client.analyze.internal.helper.PortableNodeInformationHelper;
import org.eclipse.jubula.client.analyze.ui.i18n.Messages;
import org.eclipse.jubula.client.analyze.ui.internal.definition.IResultRendererUI;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.NodePM;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ChainRenderer
implements IResultRendererUI {
    private AnalyzeResult m_analyzeResult;
    private Control m_topControl;

    public AnalyzeResult getAnalyzeResult() {
        return this.m_analyzeResult;
    }

    public void setAnalyzeResult(AnalyzeResult result) {
        this.m_analyzeResult = result;
    }

    public Control getTopControl() {
        return this.m_topControl;
    }

    public void setTopControl(Control control) {
        this.m_topControl = control;
    }

    public void renderResult(AnalyzeResult result, Composite cmp) {
        this.setAnalyzeResult(result);
        this.createViewer(cmp);
    }

    private void createViewer(Composite cmp) {
        Chainmodel cm = new Chainmodel(this.getAnalyzeResult().getResult());
        TreeViewer viewer = new TreeViewer(cmp);
        viewer.setContentProvider((IContentProvider)new ChainContentProvider(cm));
        viewer.setLabelProvider((IBaseLabelProvider)new ChainLabelProvider());
        viewer.setInput((Object)cm);
        this.setTopControl(viewer.getControl());
    }

    class ChainContentProvider
    implements ITreeContentProvider {
        private Chainmodel m_chains;

        public ChainContentProvider(Chainmodel model) {
            this.setChainmodel(model);
        }

        public void setChainmodel(Chainmodel model) {
            this.m_chains = model;
        }

        public Chainmodel getChainModel() {
            return this.m_chains;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Chainmodel) {
                Chainmodel cm = (Chainmodel)inputElement;
                return cm.getChainlength();
            }
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof String) {
                String parent = (String)parentElement;
                String length = parent.replace(Messages.Chainlength, "");
                Object[] res = new ISpecTestCasePO[this.getChainModel().getParents(Integer.parseInt(length)).length];
                int i = 0;
                while (i < this.getChainModel().getParents(Integer.parseInt(length)).length) {
                    String guid = this.getChainModel().getParents(Integer.parseInt(length))[i];
                    ISpecTestCasePO node = NodePM.getSpecTestCase((Long)GeneralStorage.getInstance().getProject().getId(), (String)guid);
                    res[i] = node;
                    ++i;
                }
                return res;
            }
            if (parentElement instanceof ISpecTestCasePO) {
                String parentGUID = ((ISpecTestCasePO)parentElement).getGuid();
                int i = 0;
                while (i < this.getChainModel().getResult().size()) {
                    List<String> list = this.getChainModel().getResult().get(i);
                    int j = 0;
                    while (j < list.size()) {
                        if (list.get(j).equals(parentGUID)) {
                            Object[] arr = new ISpecTestCasePO[1];
                            ISpecTestCasePO child = NodePM.getSpecTestCase((Long)((Long)PortableNodeInformationHelper.getNodeInformation().get(list.get(j + 1))), (String)list.get(j + 1));
                            PortableNodeInformationHelper.getNodeInformation();
                            arr[0] = child;
                            return arr;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            return null;
        }

        public Object getParent(Object element) {
            for (List<String> list : this.getChainModel().getResult()) {
                String prev = "";
                Iterator<String> it = list.iterator();
                while (it.hasNext()) {
                    String guid = it.next();
                    if (prev.equals(guid)) {
                        ISpecTestCasePO node = NodePM.getSpecTestCase((Long)GeneralStorage.getInstance().getProject().getId(), (String)it.next());
                        String[] res = new String[]{node.getName()};
                        return res;
                    }
                    if (prev.equals("")) {
                        String[] res = new String[]{String.valueOf(Messages.Chainlength) + Integer.toString(list.size())};
                        return res;
                    }
                    prev = guid;
                }
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            block5: {
                block4: {
                    if (!(element instanceof String)) break block4;
                    for (List<String> list : this.getChainModel().getResult()) {
                        Iterator<String> it = list.iterator();
                        if (!it.hasNext()) continue;
                        return it.hasNext();
                    }
                    break block5;
                }
                if (!(element instanceof ISpecTestCasePO)) break block5;
                String parentGUID = ((ISpecTestCasePO)element).getGuid();
                int i = 0;
                while (i < this.getChainModel().getResult().size()) {
                    List<String> list = this.getChainModel().getResult().get(i);
                    int j = 0;
                    while (j < list.size()) {
                        if (list.get(j).equals(parentGUID) && j + 1 < list.size()) {
                            return true;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            return false;
        }
    }

    class ChainLabelProvider
    extends LabelProvider {
        ChainLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof String) {
                return (String)element;
            }
            if (element instanceof ISpecTestCasePO) {
                ISpecTestCasePO spec = (ISpecTestCasePO)element;
                return spec.getName();
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Chainmodel {
        private List<List<String>> m_result;

        public Chainmodel(Object result) {
            this.setResult(null);
            this.setResult(result);
        }

        public void setResult(Object result) {
            if (result == null) {
                this.m_result = new ArrayList<List<String>>();
            } else if (result instanceof List) {
                this.m_result = (List)result;
            }
        }

        public List<List<String>> getResult() {
            return this.m_result;
        }

        public String[] getParents(Integer length) {
            ArrayList<String> parents = new ArrayList<String>();
            int i = 0;
            while (i < this.getResult().size()) {
                if (this.getResult().get(i).size() == length.intValue()) {
                    parents.add(this.getResult().get(i).get(0));
                }
                ++i;
            }
            return parents.toArray(new String[0]);
        }

        public String[] getChainlength() {
            HashSet<String> chainl = new HashSet<String>();
            if (this.getResult().size() == 0) {
                String[] result = new String[]{Messages.NoChainFound};
                return result;
            }
            int i = 0;
            while (i < this.getResult().size()) {
                chainl.add(String.valueOf(Messages.Chainlength) + Integer.toString(this.getResult().get(i).size()));
                ++i;
            }
            ArrayList list = new ArrayList(chainl);
            Collections.sort(list);
            String[] chainlength = list.toArray(new String[0]);
            return chainlength;
        }
    }
}

