/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.persistence.EntityManager;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jubula.client.core.businessprocess.IParamNameMapper;
import org.eclipse.jubula.client.core.businessprocess.ParamNameBP;
import org.eclipse.jubula.client.core.businessprocess.ParamNameBPDecorator;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.ICategoryPO;
import org.eclipse.jubula.client.core.model.ICompNamesPairPO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.IParamNodePO;
import org.eclipse.jubula.client.core.model.IParameterInterfacePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ISpecObjContPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.NodeMaker;
import org.eclipse.jubula.client.core.model.PoMaker;
import org.eclipse.jubula.client.core.model.TDCell;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.NodePM;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.TransactionSupport;
import org.eclipse.jubula.client.core.utils.ModelParamValueConverter;
import org.eclipse.jubula.client.core.utils.RefToken;
import org.eclipse.jubula.client.ui.rcp.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.rcp.handlers.AbstractRefactorHandler;
import org.eclipse.jubula.tools.exception.ProjectDeletedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaveAsNewTestCaseHandler
extends AbstractRefactorHandler {
    public Object executeImpl(ExecutionEvent event) {
        String newTestCaseName = this.getNewTestCaseName(event);
        if (newTestCaseName != null) {
            ISpecTestCasePO newSpecTC = null;
            IStructuredSelection ss = this.getSelection();
            ArrayList<IParamNodePO> nodesToClone = new ArrayList<IParamNodePO>(ss.size());
            Iterator it = ss.iterator();
            while (it.hasNext()) {
                nodesToClone.add((IParamNodePO)it.next());
            }
            newSpecTC = this.createAndPerformNodeDuplication(newTestCaseName, nodesToClone);
            DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)newSpecTC, DataEventDispatcher.DataState.Added, DataEventDispatcher.UpdateState.all);
        }
        return null;
    }

    private ISpecTestCasePO createAndPerformNodeDuplication(String newTestCaseName, List<IParamNodePO> nodesToClone) {
        CloneTransaction op = new CloneTransaction(newTestCaseName, nodesToClone);
        try {
            new TransactionSupport().transact((TransactionSupport.ITransactAction)op);
        }
        catch (PMException e) {
            PMExceptionHandler.handlePMExceptionForMasterSession(e);
        }
        catch (ProjectDeletedException projectDeletedException) {
            PMExceptionHandler.handleGDProjectDeletedException();
        }
        return op.getNewSpecTC();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CloneTransaction
    implements TransactionSupport.ITransactAction {
        private final String m_newTestCaseName;
        private final List<IParamNodePO> m_nodesToClone;
        private ISpecTestCasePO m_newSpecTC = null;

        public CloneTransaction(String newTestCaseName, List<IParamNodePO> nodesToClone) {
            this.m_newTestCaseName = newTestCaseName;
            this.m_nodesToClone = nodesToClone;
        }

        public void run(EntityManager s) throws PMException {
            ISpecTestCasePO newTc = NodeMaker.createSpecTestCasePO((String)this.m_newTestCaseName);
            ParamNameBPDecorator pMapper = new ParamNameBPDecorator((IParamNameMapper)ParamNameBP.getInstance());
            s.persist((Object)newTc);
            ICategoryPO parent = ISpecObjContPO.TCB_ROOT_NODE;
            NodePM.AbstractCmdHandleChild handler = NodePM.getCmdHandleChild((INodePO)parent, (INodePO)newTc);
            handler.add((INodePO)parent, (INodePO)newTc, null);
            HashMap<String, String> oldToNewGuids = new HashMap<String, String>();
            for (IParamNodePO node : this.m_nodesToClone) {
                this.addCloneToNewSpecTc(newTc, node, s, pMapper, oldToNewGuids);
            }
            SaveAsNewTestCaseHandler.registerParamNamesToSave(newTc, pMapper);
            s.merge((Object)newTc);
            pMapper.persist(s, GeneralStorage.getInstance().getProject().getId());
            this.setNewSpecTC(newTc);
        }

        private void addCloneToNewSpecTc(ISpecTestCasePO newSpecTC, IParamNodePO nodeToCopy, EntityManager session, ParamNameBPDecorator pMapper, Map<String, String> oldToNewGuids) throws PMException {
            IExecTestCasePO newParamNode = null;
            if (nodeToCopy instanceof IExecTestCasePO) {
                IExecTestCasePO origExec = (IExecTestCasePO)nodeToCopy;
                IExecTestCasePO newExec = NodeMaker.createExecTestCasePO((ISpecTestCasePO)origExec.getSpecTestCase());
                this.fillExec(origExec, newExec);
                newParamNode = newExec;
            } else if (nodeToCopy instanceof ICapPO) {
                ICapPO origCap = (ICapPO)nodeToCopy;
                ICapPO newCap = NodeMaker.createCapPO((String)origCap.getName(), (String)origCap.getComponentName(), (String)origCap.getComponentType(), (String)origCap.getActionName());
                this.fillCap(origCap, newCap);
                newParamNode = newCap;
            }
            if (newParamNode != null) {
                this.addParamsToNewParent(newSpecTC, (IParamNodePO)newParamNode, pMapper, oldToNewGuids);
                newSpecTC.addNode((INodePO)newParamNode);
            }
        }

        private void addParamsToNewParent(ISpecTestCasePO newSpecTC, IParamNodePO newParamChildNode, ParamNameBPDecorator pMapper, Map<String, String> oldToNewGuids) {
            IProjectPO proj = GeneralStorage.getInstance().getProject();
            TDCell cell = null;
            List langs = proj.getLangHelper().getLanguageList();
            for (Locale lang : langs) {
                Iterator it = newParamChildNode.getParamReferencesIterator(lang);
                while (it.hasNext()) {
                    cell = (TDCell)it.next();
                    String guid = (String)newParamChildNode.getDataManager().getUniqueIds().get(cell.getCol());
                    IParamDescriptionPO childDesc = newParamChildNode.getParameterForUniqueId(guid);
                    if (childDesc == null) continue;
                    ModelParamValueConverter conv = new ModelParamValueConverter(cell.getTestData(), (IParameterInterfacePO)newParamChildNode, lang, childDesc);
                    List refTokens = conv.getRefTokens();
                    for (RefToken refToken : refTokens) {
                        String oldGUID = RefToken.extractCore((String)refToken.getModelString());
                        String paramName = ParamNameBP.getInstance().getName(oldGUID, childDesc.getParentProjectId());
                        IParamDescriptionPO parentParamDescr = newSpecTC.addParameter(childDesc.getType(), paramName, false, (IParamNameMapper)pMapper);
                        if (parentParamDescr != null) {
                            String newGuid = parentParamDescr.getUniqueId();
                            oldToNewGuids.put(oldGUID, newGuid);
                        }
                        conv.replaceGuidsInReferences(oldToNewGuids);
                        cell.getTestData().setValue(lang, conv.getModelString(), proj);
                    }
                }
            }
        }

        private void fillCap(ICapPO origCap, ICapPO newCap) {
            newCap.setActive(origCap.isActive());
            newCap.setComment(origCap.getComment());
            newCap.setGenerated(origCap.isGenerated());
            newCap.setToolkitLevel(origCap.getToolkitLevel());
            origCap.getDataManager().deepCopy(newCap.getDataManager());
        }

        private void fillExec(IExecTestCasePO origExec, IExecTestCasePO newExec) {
            newExec.setActive(origExec.isActive());
            newExec.setComment(origExec.getComment());
            newExec.setDataFile(origExec.getDataFile());
            newExec.setGenerated(origExec.isGenerated());
            ISpecTestCasePO origSpecTC = origExec.getSpecTestCase();
            if (!origExec.getName().equals(origSpecTC.getName())) {
                newExec.setName(origExec.getName());
            }
            newExec.setToolkitLevel(origExec.getToolkitLevel());
            if (!origExec.getDataManager().equals(origSpecTC.getDataManager())) {
                newExec.setHasReferencedTD(false);
                origExec.getDataManager().deepCopy(newExec.getDataManager());
            } else {
                newExec.setHasReferencedTD(true);
            }
            newExec.setReferencedDataCube(origExec.getReferencedDataCube());
            for (ICompNamesPairPO origPair : origExec.getCompNamesPairs()) {
                ICompNamesPairPO newPair = PoMaker.createCompNamesPairPO((String)origPair.getFirstName(), (String)origPair.getSecondName(), (String)origPair.getType());
                newPair.setPropagated(origPair.isPropagated());
                newExec.addCompNamesPair(newPair);
            }
        }

        public ISpecTestCasePO getNewSpecTC() {
            return this.m_newSpecTC;
        }

        public void setNewSpecTC(ISpecTestCasePO newSpecTC) {
            this.m_newSpecTC = newSpecTC;
        }
    }
}

