/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.views;

import java.util.Locale;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jubula.client.core.businessprocess.db.TestSuiteBP;
import org.eclipse.jubula.client.core.events.DataChangedEvent;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.ICategoryPO;
import org.eclipse.jubula.client.core.model.IExecObjContPO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IObjectMappingPO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.IRefTestSuitePO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITestCasePO;
import org.eclipse.jubula.client.core.model.ITestJobPO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.persistence.EditSupport;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.PMAlreadyLockedException;
import org.eclipse.jubula.client.core.persistence.PMDirtyVersionException;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.PMReadException;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.controllers.dnd.LocalSelectionTransfer;
import org.eclipse.jubula.client.ui.rcp.controllers.dnd.TestExecDropTargetListener;
import org.eclipse.jubula.client.ui.rcp.controllers.dnd.TreeViewerContainerDragSourceListener;
import org.eclipse.jubula.client.ui.rcp.editors.TestJobEditor;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.provider.DecoratingCellLabelProvider;
import org.eclipse.jubula.client.ui.rcp.provider.contentprovider.TestSuiteBrowserContentProvider;
import org.eclipse.jubula.client.ui.rcp.provider.labelprovider.TooltipLabelProvider;
import org.eclipse.jubula.client.ui.rcp.views.AbstractJBTreeView;
import org.eclipse.jubula.client.ui.utils.CommandHelper;
import org.eclipse.jubula.client.ui.views.IJBPart;
import org.eclipse.jubula.client.ui.views.ITreeViewerContainer;
import org.eclipse.jubula.tools.exception.JBFatalException;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IDecoratorManager;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSuiteBrowser
extends AbstractJBTreeView
implements ITreeViewerContainer,
IJBPart,
DataEventDispatcher.ILanguageChangedListener,
DataEventDispatcher.IProblemPropagationListener {
    public static final String NEW_ID = "org.eclipse.ui.NewSubMenu";
    public static final String ADD_ID = "org.eclipse.ui.AddSubMenu";
    static final Logger LOG = LoggerFactory.getLogger(TestSuiteBrowser.class);

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.getTreeViewer());
        this.getTreeViewer().setContentProvider((IContentProvider)new TestSuiteBrowserContentProvider());
        DecoratingCellLabelProvider lp = new DecoratingCellLabelProvider(new TooltipLabelProvider(), Plugin.getDefault().getWorkbench().getDecoratorManager().getLabelDecorator());
        this.getTreeViewer().setLabelProvider((IBaseLabelProvider)lp);
        this.getTreeViewer().setAutoExpandLevel(2);
        this.setViewerInput();
        Plugin.getHelpSystem().setHelp(this.getTreeViewer().getControl(), "org.eclipse.jubula.client.ua.help.testExecViewContextId");
        int ops = 2;
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getInstance()};
        this.getTreeViewer().addDragSupport(ops, transfers, (DragSourceListener)new TreeViewerContainerDragSourceListener(this.getTreeViewer()));
        this.getTreeViewer().addDropSupport(ops, transfers, (DropTargetListener)new TestExecDropTargetListener(this));
        DataEventDispatcher ded = DataEventDispatcher.getInstance();
        ded.addLanguageChangedListener((DataEventDispatcher.ILanguageChangedListener)this, true);
        ded.addProblemPropagationListener((DataEventDispatcher.IProblemPropagationListener)this);
        if (GeneralStorage.getInstance().getProject() != null) {
            this.handleProjectLoaded();
        }
    }

    protected void addTreeListener() {
        this.getTreeViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = TestSuiteBrowser.this.getSuiteTreeSelection();
                Object firstElement = selection.getFirstElement();
                if (firstElement instanceof ITestSuitePO) {
                    this.runCommand("org.eclipse.jubula.client.ui.rcp.commands.OpenTestsuiteEditor");
                } else if (firstElement instanceof ITestJobPO) {
                    this.runCommand("org.eclipse.jubula.client.ui.rcp.commands.OpenTestJobEditor");
                } else if (firstElement instanceof IExecObjContPO) {
                    this.runCommand("org.eclipse.jubula.client.ui.rcp.commands.NewTestSuiteCommand");
                } else if (firstElement instanceof ICategoryPO) {
                    this.runCommand("org.eclipse.jubula.client.ui.rcp.commands.NewTestSuiteCommand");
                }
            }

            private void runCommand(String commandID) {
                CommandHelper.executeCommand((String)commandID, (IWorkbenchPartSite)TestSuiteBrowser.this.getSite());
            }
        });
    }

    protected void createContextMenu(IMenuManager mgr) {
        mgr.add((IContributionItem)new GroupMarker("defaultTestSuiteBrowserMarker"));
    }

    public IStructuredSelection getSuiteTreeSelection() {
        return this.getTreeViewer().getSelection() instanceof IStructuredSelection ? (IStructuredSelection)this.getTreeViewer().getSelection() : StructuredSelection.EMPTY;
    }

    public void setFocus() {
        this.getTreeViewer().getControl().setFocus();
        Plugin.showStatusLine((IWorkbenchPart)this);
    }

    public void dispose() {
        DataEventDispatcher ded = DataEventDispatcher.getInstance();
        ded.removeDataChangedListener((DataEventDispatcher.IDataChangedListener)this);
        ded.removeLanguageChangedListener((DataEventDispatcher.ILanguageChangedListener)this);
        ded.removeProblemPropagationListener((DataEventDispatcher.IProblemPropagationListener)this);
        super.dispose();
    }

    protected void rebuildTree() {
        this.setViewerInput();
    }

    public void handleDataChanged(DataChangedEvent ... events) {
        DataChangedEvent[] dataChangedEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            DataChangedEvent e = dataChangedEventArray[n2];
            this.handleDataChanged(e.getPo(), e.getDataState(), e.getUpdateState());
            ++n2;
        }
    }

    public void handleDataChanged(final IPersistentObject po, final DataEventDispatcher.DataState dataState, final DataEventDispatcher.UpdateState updateState) {
        Plugin.getDisplay().syncExec(new Runnable(){

            public void run() {
                TestSuiteBrowser.this.handleDataChangedImpl(po, dataState, updateState);
            }
        });
    }

    private void handleDataChangedImpl(IPersistentObject po, DataEventDispatcher.DataState dataState, DataEventDispatcher.UpdateState updateState) {
        if (po instanceof IAUTMainPO) {
            this.getTreeViewer().refresh();
            return;
        }
        if (updateState == DataEventDispatcher.UpdateState.onlyInEditor) {
            return;
        }
        switch (dataState) {
            case Added: {
                this.handleDataAdded(po);
                break;
            }
            case Deleted: {
                this.handleDataDeleted(po);
                break;
            }
            case Renamed: {
                if (!(po instanceof IProjectPO) && !(po instanceof ITestSuitePO) && !(po instanceof ITestJobPO) && !(po instanceof ITestCasePO) && !(po instanceof ICategoryPO)) break;
                this.getTreeViewer().refresh();
                break;
            }
            case StructureModified: {
                if (po instanceof IProjectPO) {
                    this.handleProjectLoaded();
                }
                if (po instanceof ISpecTestCasePO || po instanceof ITestSuitePO || po instanceof ITestJobPO) {
                    Object[] expandedElements = this.getTreeViewer().getExpandedElements();
                    ISelection selection = this.getTreeViewer().getSelection();
                    this.getTreeViewer().refresh();
                    this.getTreeViewer().setExpandedElements(expandedElements);
                    this.getTreeViewer().setSelection(selection);
                }
                if (!(po instanceof IObjectMappingPO)) break;
                this.getTreeViewer().refresh();
                break;
            }
        }
    }

    private void handleDataDeleted(final IPersistentObject po) {
        Plugin.getDisplay().syncExec(new Runnable(){

            public void run() {
                if (po instanceof ITestSuitePO || po instanceof ITestJobPO || po instanceof ICategoryPO) {
                    TestSuiteBrowser.this.getTreeViewer().refresh();
                } else if (po instanceof IProjectPO) {
                    TestSuiteBrowser.this.setViewerInput();
                    TestSuiteBrowser.this.getTreeViewer().refresh();
                }
            }
        });
    }

    private void handleDataAdded(IPersistentObject po) {
        if (po instanceof ISpecTestCasePO) {
            return;
        }
        this.getTreeViewer().refresh();
        this.getTreeViewer().expandToLevel(this.getTreeViewer().getAutoExpandLevel());
        this.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)po), true);
    }

    public void handleLanguageChanged(Locale locale) {
        this.getTreeViewer().refresh();
    }

    public INodePO addReferencedTestSuite(ITestSuitePO ts, INodePO tj, int position) throws PMReadException, PMAlreadyLockedException, PMDirtyVersionException, PMException {
        INodePO exTcGUI = null;
        ITestSuitePO workTs = null;
        workTs = this.createWorkVersionofTs(ts);
        if (workTs != null) {
            IRefTestSuitePO refTs = TestSuiteBP.addReferencedTestSuite((EditSupport)this.getEditSupport(), (INodePO)tj, (ITestSuitePO)workTs, (Integer)position);
            DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)refTs, DataEventDispatcher.DataState.Added, DataEventDispatcher.UpdateState.onlyInEditor);
        }
        return exTcGUI;
    }

    private EditSupport getEditSupport() {
        TestJobEditor edit = this.getTJEditor();
        EditSupport editSupport = edit.getEditorHelper().getEditSupport();
        return editSupport;
    }

    private TestJobEditor getTJEditor() {
        TestJobEditor edit = Plugin.getDefault().getActiveTJEditor();
        if (edit == null) {
            String msg = Messages.NoActiveTCEditorPleaseFixTheMethod;
            LOG.error(msg);
            throw new JBFatalException(msg, MessageIDs.E_NO_OPENED_EDITOR);
        }
        return edit;
    }

    private ITestSuitePO createWorkVersionofTs(ITestSuitePO origTs) throws PMReadException, PMAlreadyLockedException, PMDirtyVersionException, PMException {
        ITestSuitePO workTs = null;
        EditSupport editSupport = this.getEditSupport();
        workTs = (ITestSuitePO)editSupport.createWorkVersion((IPersistentObject)origTs);
        return workTs;
    }

    private void setViewerInput() {
        IProjectPO activeProject = GeneralStorage.getInstance().getProject();
        if (activeProject != null) {
            this.getTreeViewer().setInput((Object)new IExecObjContPO[]{activeProject.getExecObjCont()});
        } else {
            this.getTreeViewer().setInput(null);
        }
    }

    public void problemPropagationFinished() {
        this.getTreeViewer().getTree().getDisplay().syncExec(new Runnable(){

            public void run() {
                TestSuiteBrowser.this.getTreeViewer().refresh();
                IDecoratorManager dm = Plugin.getDefault().getWorkbench().getDecoratorManager();
                dm.update("org.eclipse.jubula.client.ui.rcp.decorators.completenessCheckDecorator");
            }
        });
    }
}

