/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.editors;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Stack;
import javax.persistence.EntityManager;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DecorationContext;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDecorationContext;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IParameterDetailsPO;
import org.eclipse.jubula.client.core.model.ITestResultPO;
import org.eclipse.jubula.client.core.model.ITestResultSummaryPO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.model.NodeMaker;
import org.eclipse.jubula.client.core.model.PoMaker;
import org.eclipse.jubula.client.core.model.TestResultNode;
import org.eclipse.jubula.client.core.model.TestResultParameter;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.NodePM;
import org.eclipse.jubula.client.core.persistence.TestResultPM;
import org.eclipse.jubula.client.ui.editors.TestResultEditorInput;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.jubula.client.ui.provider.contentprovider.TestResultTreeViewContentProvider;
import org.eclipse.jubula.client.ui.provider.labelprovider.TestResultTreeViewLabelProvider;
import org.eclipse.jubula.client.ui.utils.CommandHelper;
import org.eclipse.jubula.client.ui.views.IJBPart;
import org.eclipse.jubula.client.ui.views.ITreeViewerContainer;
import org.eclipse.jubula.client.ui.views.NonSortedPropertySheetPage;
import org.eclipse.jubula.tools.i18n.I18n;
import org.eclipse.jubula.tools.objects.event.TestErrorEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestResultViewer
extends EditorPart
implements ISelectionProvider,
ITreeViewerContainer,
IAdaptable,
IJBPart {
    public static final String EDITOR_ID = "org.eclipse.jubula.client.ui.editors.TestResultViewer";
    public static final String DECORATION_CONTEXT_SUITE_END_TIME_ID = "org.eclipse.jubula.client.ui.editors.TestResultViewer.testSuiteEndTime";
    private static final Logger LOG = LoggerFactory.getLogger(TestResultViewer.class);
    private TreeViewer m_viewer;

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public Object getAdapter(Class key) {
        if (key.equals(IPropertySheetPage.class)) {
            return new NonSortedPropertySheetPage();
        }
        return super.getAdapter(key);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof TestResultEditorInput)) {
            throw new PartInitException(Messages.EditorInitCreateError);
        }
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.setPartName(input.getName());
    }

    private TestResultNode generateTestResult(Long summaryId, Long parentProjectId) throws InterruptedException {
        IProgressService progressService = (IProgressService)this.getSite().getService(IProgressService.class);
        GenerateTestResultTreeOperation operation = new GenerateTestResultTreeOperation(summaryId, parentProjectId);
        try {
            progressService.busyCursorWhile((IRunnableWithProgress)operation);
        }
        catch (InvocationTargetException e) {
            LOG.error(String.valueOf(Messages.ErrorFetchingTestResultInformation) + ".", (Throwable)e);
        }
        catch (OperationCanceledException operationCanceledException) {
            throw new InterruptedException();
        }
        return operation.getRootNode();
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        TestResultEditorInput editorInput = (TestResultEditorInput)this.getEditorInput();
        this.m_viewer = new TreeViewer(parent);
        this.m_viewer.setContentProvider((IContentProvider)new TestResultTreeViewContentProvider());
        DecoratingLabelProvider labelProvider = new DecoratingLabelProvider((ILabelProvider)new TestResultTreeViewLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator());
        IDecorationContext decorationContext = labelProvider.getDecorationContext();
        if (decorationContext instanceof DecorationContext) {
            ((DecorationContext)decorationContext).putProperty(DECORATION_CONTEXT_SUITE_END_TIME_ID, (Object)editorInput.getTestSuiteEndTime());
        }
        this.m_viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.getSite().setSelectionProvider((ISelectionProvider)this.m_viewer);
        this.createContextMenu(this.m_viewer);
        this.m_viewer.setAutoExpandLevel(2);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.m_viewer.getControl(), "org.eclipse.jubula.client.ua.help.testResultViewContextId");
        try {
            this.m_viewer.setInput((Object)new TestResultNode[]{this.generateTestResult(editorInput.getTestResultSummaryId(), editorInput.getParentProjectId())});
        }
        catch (InterruptedException interruptedException) {
            this.m_viewer.getControl().dispose();
            this.m_viewer = null;
            new Label(parent, 0).setText(Messages.EditorsOpenEditorOperationCanceled);
        }
    }

    private void createContextMenu(TreeViewer viewer) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                TestResultViewer.this.fillContextMenu(mgr);
            }
        });
        Control viewerControl = viewer.getControl();
        Menu menu = menuMgr.createContextMenu(viewerControl);
        viewerControl.setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.getTreeViewer());
    }

    private void fillContextMenu(IMenuManager mgr) {
        CommandHelper.createContributionPushItem(mgr, "org.eclipse.jubula.client.ui.commands.ExpandTreeItem");
        mgr.add((IContributionItem)new GroupMarker("additions"));
    }

    public void setFocus() {
        if (this.m_viewer != null && !this.m_viewer.getControl().isDisposed()) {
            this.m_viewer.getControl().setFocus();
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.m_viewer.addSelectionChangedListener(listener);
    }

    public ISelection getSelection() {
        return this.m_viewer.getSelection();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.m_viewer.removeSelectionChangedListener(listener);
    }

    public void setSelection(ISelection selection) {
        this.m_viewer.setSelection(selection);
    }

    public TreeViewer getTreeViewer() {
        return this.m_viewer;
    }

    public static final class GenerateTestResultTreeOperation
    implements IRunnableWithProgress {
        private static Map<String, String> eventIdReverseLookup = new HashMap<String, String>();
        private Long m_summaryId;
        private Long m_parentProjectId;
        private TestResultNode m_rootNode;

        static {
            eventIdReverseLookup.put(I18n.getString((String)"TestErrorEvent.CompNotFound"), "TestErrorEvent.CompNotFound");
            eventIdReverseLookup.put(I18n.getString((String)"TestErrorEvent.Config"), "TestErrorEvent.Config");
            eventIdReverseLookup.put(I18n.getString((String)"TestErrorEvent.Action"), "TestErrorEvent.Action");
            eventIdReverseLookup.put(I18n.getString((String)"TestErrorEvent.VerifyFailed"), "TestErrorEvent.VerifyFailed");
        }

        public GenerateTestResultTreeOperation(Long summaryId, Long parentProjectId) {
            this.m_summaryId = summaryId;
            this.m_parentProjectId = parentProjectId;
        }

        /*
         * Unable to fully structure code
         */
        public void run(IProgressMonitor monitor) {
            monitor.beginTask("Fetching Test Result data...", -1);
            try {
                testResultList = TestResultPM.computeTestResultListForSummary((EntityManager)GeneralStorage.getInstance().getMasterSession(), (Long)this.m_summaryId);
                createdNode = null;
                parentNodeStack = new Stack<TestResultNode>();
                allGuids = new HashSet<String>();
                for (ITestResultPO result : testResultList) {
                    allGuids.add(result.getInternalKeywordGuid());
                }
                guidToNodeMap = NodePM.getNodes((Long)this.m_parentProjectId, allGuids, (EntityManager)GeneralStorage.getInstance().getMasterSession());
                for (ITestResultPO result : testResultList) {
                    block10: {
                        if (monitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        keywordLevel = result.getKeywordLevel();
                        if (keywordLevel <= parentNodeStack.size()) ** GOTO lbl22
                        parentNodeStack.push(createdNode);
                        break block10;
lbl-1000:
                        // 1 sources

                        {
                            parentNodeStack.pop();
lbl22:
                            // 2 sources

                            ** while (keywordLevel < parentNodeStack.size())
                        }
                    }
                    backingNode = (INodePO)guidToNodeMap.get(result.getInternalKeywordGuid());
                    v0 = backingNodeExists = backingNode != null;
                    if (!backingNodeExists) {
                        backingNode = this.generateBackingNode(result);
                    }
                    createdNode = new TestResultNode(backingNodeExists, backingNode, parentNodeStack.isEmpty() != false ? null : (TestResultNode)parentNodeStack.peek());
                    createdNode.setComponentName(result.getComponentName());
                    createdNode.setComponentType(result.getComponentType());
                    for (IParameterDetailsPO param : result.getUnmodifiableParameterList()) {
                        createdNode.addParameter(new TestResultParameter(param));
                    }
                    createdNode.setResult(result.getInternalKeywordStatus(), this.generateTestErrorEvent(result));
                    createdNode.setScreenshot(result.getImage());
                    createdNode.setTimestamp(result.getTimestamp());
                    if (this.m_rootNode != null) continue;
                    this.m_rootNode = createdNode;
                }
            }
            finally {
                monitor.done();
            }
        }

        public TestResultNode getRootNode() {
            return this.m_rootNode;
        }

        private INodePO generateBackingNode(ITestResultPO result) {
            switch (result.getInternalKeywordType()) {
                case 3: {
                    String componentName = !StringUtils.isEmpty((String)result.getComponentName()) ? result.getComponentName() : " ";
                    return NodeMaker.createCapPO((String)result.getKeywordName(), (String)componentName, (String)(result.getInternalComponentType() != null ? result.getInternalComponentType() : " "), (String)(result.getInternalActionName() != null ? result.getInternalActionName() : " "));
                }
                case 2: {
                    return NodeMaker.createSpecTestCasePO((String)result.getKeywordName(), (String)result.getInternalKeywordGuid());
                }
                case 1: {
                    ITestSuitePO backingTestSuite = NodeMaker.createTestSuitePO((String)result.getKeywordName(), (String)result.getInternalKeywordGuid());
                    ITestResultSummaryPO summary = (ITestResultSummaryPO)GeneralStorage.getInstance().getMasterSession().find(PoMaker.getTestResultSummaryClass(), (Object)this.m_summaryId);
                    backingTestSuite.setAut(PoMaker.createAUTMainPO((String)summary.getAutName()));
                    return backingTestSuite;
                }
            }
            return null;
        }

        private TestErrorEvent generateTestErrorEvent(ITestResultPO result) {
            TestErrorEvent errorEvent = null;
            if (result.getInternalKeywordStatus() == 2) {
                errorEvent = new TestErrorEvent(eventIdReverseLookup.get(result.getStatusType()));
                if (result.getStatusDescription() != null) {
                    errorEvent.addProp("guidancerErrorDescription", (Object)result.getStatusDescription());
                }
                if (result.getActualValue() != null) {
                    errorEvent.addProp("guidancerActualValue", (Object)result.getActualValue());
                }
                if (result.getStatusOperator() != null) {
                    errorEvent.addProp("guidancerOperator", (Object)result.getStatusOperator());
                }
                if (result.getExpectedValue() != null) {
                    errorEvent.addProp("guidancerPattern", (Object)result.getExpectedValue());
                }
                return errorEvent;
            }
            return null;
        }
    }
}

