/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.common.implclasses;

import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.tools.objects.event.EventFactory;

public class Comparer {
    private static final String LESS = "less than";
    private static final String LESS_OR_EQUAL = "less or equal than";
    private static final String EQUAL = "equal to";
    private static final String GREATER_OR_EQUAL = "greater or equal than";
    private static final String GREATER = "greater than";

    private Comparer() {
    }

    public static void compare(String value1, String value2, String comparisonMethod) throws StepExecutionException {
        try {
            Double val1 = new Double(value1);
            Double val2 = new Double(value2);
            int comparisonResult = val1.compareTo(val2);
            boolean expectedComparison = false;
            if (comparisonMethod.equals(LESS)) {
                expectedComparison = comparisonResult < 0;
            } else if (comparisonMethod.equals(LESS_OR_EQUAL)) {
                expectedComparison = comparisonResult <= 0;
            } else if (comparisonMethod.equals(EQUAL)) {
                expectedComparison = comparisonResult == 0;
            } else if (comparisonMethod.equals(GREATER_OR_EQUAL)) {
                expectedComparison = comparisonResult >= 0;
            } else if (comparisonMethod.equals(GREATER)) {
                boolean bl = expectedComparison = comparisonResult > 0;
            }
            if (!expectedComparison) {
                throw new StepExecutionException("Comparison failed", EventFactory.createVerifyFailed((String)"", (String)("\"" + value1 + "\" has been expected to be " + comparisonMethod + " \"" + value2 + "\".")));
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new StepExecutionException("No valid Input Data", EventFactory.createActionError((String)"TestErrorEvent.InvalidParameterValue"));
        }
    }
}

