/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swing.swing.implclasses;

import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.apache.commons.lang.ObjectUtils;
import org.eclipse.jubula.rc.swing.swing.implclasses.AbstractSwingImplClass;

public class JTableHeaderImplClass
extends AbstractSwingImplClass {
    private JTableHeader m_tableHeader;

    public void setComponent(Object graphicsComponent) {
        this.m_tableHeader = (JTableHeader)graphicsComponent;
    }

    public String[] getTextArrayFromComponent() {
        String[] componentTextArray;
        TableColumnModel columnModel = this.m_tableHeader.getColumnModel();
        if (columnModel == null) {
            componentTextArray = null;
        } else {
            componentTextArray = new String[columnModel.getColumnCount()];
            int i = 0;
            while (i < componentTextArray.length) {
                componentTextArray[i] = JTableHeaderImplClass.getRenderedHeaderText(this.m_tableHeader, i);
                ++i;
            }
        }
        return componentTextArray;
    }

    public JComponent getComponent() {
        return this.m_tableHeader;
    }

    protected String getText() {
        Point headerLocation = this.m_tableHeader.getLocationOnScreen();
        Point currentMousePosition = this.getRobot().getCurrentMousePosition();
        TableColumnModel columnModel = this.m_tableHeader.getColumnModel();
        int i = 0;
        while (i < columnModel.getColumnCount()) {
            Rectangle headerCellBounds = this.m_tableHeader.getHeaderRect(i);
            headerCellBounds.setLocation(headerLocation);
            headerCellBounds.grow(1, 1);
            if (headerCellBounds.contains(currentMousePosition)) {
                return JTableHeaderImplClass.getRenderedHeaderText(this.m_tableHeader, i);
            }
            ++i;
        }
        return null;
    }

    private static String getRenderedHeaderText(JTableHeader header, int columnIndex) {
        Object headerValue;
        TableColumn column = header.getColumnModel().getColumn(columnIndex);
        if (column != null && (headerValue = column.getHeaderValue()) != null) {
            TableCellRenderer renderer = column.getHeaderRenderer();
            if (renderer == null) {
                renderer = header.getDefaultRenderer();
            }
            if (renderer != null) {
                return JTableHeaderImplClass.getRenderedText(renderer.getTableCellRendererComponent(header.getTable(), headerValue, false, false, -1, columnIndex));
            }
            return ObjectUtils.toString((Object)headerValue);
        }
        return null;
    }
}

