/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swing.swing.implclasses;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.apache.commons.lang.Validate;
import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.driver.DragAndDropHelper;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.exception.StepVerifyFailedException;
import org.eclipse.jubula.rc.common.implclasses.IndexConverter;
import org.eclipse.jubula.rc.common.implclasses.Verifier;
import org.eclipse.jubula.rc.common.implclasses.tree.AbstractTreeOperationContext;
import org.eclipse.jubula.rc.common.implclasses.tree.BoundsTreeNodeOperation;
import org.eclipse.jubula.rc.common.implclasses.tree.ChildTraverser;
import org.eclipse.jubula.rc.common.implclasses.tree.ExpandCollapseTreeNodeOperation;
import org.eclipse.jubula.rc.common.implclasses.tree.INodePath;
import org.eclipse.jubula.rc.common.implclasses.tree.IndexNodePath;
import org.eclipse.jubula.rc.common.implclasses.tree.ParentTraverser;
import org.eclipse.jubula.rc.common.implclasses.tree.PathBasedTraverser;
import org.eclipse.jubula.rc.common.implclasses.tree.SelectTreeNodeOperation;
import org.eclipse.jubula.rc.common.implclasses.tree.SiblingTraverser;
import org.eclipse.jubula.rc.common.implclasses.tree.StringNodePath;
import org.eclipse.jubula.rc.common.implclasses.tree.TreeNodeOperation;
import org.eclipse.jubula.rc.common.implclasses.tree.TreeNodeOperationConstraint;
import org.eclipse.jubula.rc.swing.swing.implclasses.AbstractSwingImplClass;
import org.eclipse.jubula.rc.swing.swing.implclasses.TreeOperationContext;
import org.eclipse.jubula.rc.swing.swing.interfaces.IJTreeImplClass;
import org.eclipse.jubula.tools.objects.event.EventFactory;
import org.eclipse.jubula.tools.objects.event.TestErrorEvent;
import org.eclipse.jubula.tools.utils.StringParsing;

public class JTreeImplClass
extends AbstractSwingImplClass
implements IJTreeImplClass {
    public static final int NO_PRE_ASCEND = 0;
    private JTree m_tree;

    public void setComponent(Object graphicsComponent) {
        this.m_tree = (JTree)graphicsComponent;
    }

    public JComponent getComponent() {
        return this.m_tree;
    }

    private String[] splitTextTreePath(String treePath) {
        return StringParsing.splitToArray((String)treePath, (char)'/', (char)'\\', (boolean)true);
    }

    private INodePath createStringNodePath(String[] treePath, String operator) {
        return new StringNodePath(treePath, operator);
    }

    private Integer[] splitIndexTreePath(String treePath) throws StepExecutionException {
        Integer[] indexPath = null;
        String[] path = this.splitTextTreePath(treePath);
        if (path != null) {
            indexPath = new Integer[path.length];
            int i = 0;
            while (i < path.length) {
                indexPath[i] = new Integer(IndexConverter.intValue((String)path[i]));
                ++i;
            }
        }
        return IndexConverter.toImplementationIndices(indexPath);
    }

    private INodePath createIndexNodePath(Integer[] treePath) {
        return new IndexNodePath(treePath);
    }

    private void traverseTreeByPath(INodePath treePath, String pathType, int preAscend, TreeNodeOperation operation) throws StepExecutionException {
        Validate.notNull((Object)treePath);
        Validate.notNull((Object)operation);
        TreeOperationContext context = new TreeOperationContext(this.getEventThreadQueuer(), this.getRobot(), this.m_tree);
        PathBasedTraverser traverser = new PathBasedTraverser((AbstractTreeOperationContext)context, treePath);
        traverser.traversePath(operation, this.getStartNode(pathType, preAscend, context));
    }

    private Object getStartNode(String pathType, int preAscend, TreeOperationContext context) {
        Object startNode;
        if (pathType.equals("relative")) {
            Object child = startNode = this.getSelectedNode(context);
            int i = 0;
            while (i < preAscend) {
                if (startNode == null || !this.m_tree.isRootVisible() && this.m_tree.getModel().getRoot() == startNode) {
                    TestErrorEvent event = EventFactory.createActionError((String)"TestErrorEvent.TreeNodeNotFound");
                    throw new StepExecutionException("Tree node not found: Parent of " + child.toString(), event);
                }
                child = startNode;
                startNode = context.getParent(startNode);
                ++i;
            }
            if (!this.m_tree.isRootVisible() && this.m_tree.getModel().getRoot() == startNode) {
                startNode = null;
            }
        } else if (pathType.equals("absolute")) {
            startNode = null;
        } else {
            throw new StepExecutionException(String.valueOf(pathType) + " is not a valid Path Type", EventFactory.createActionError((String)"TestErrorEvent.InvalidParameterValue"));
        }
        return startNode;
    }

    private void traverseLastElementByPath(INodePath treePath, String pathType, int preAscend, TreeNodeOperation operation) throws StepExecutionException {
        Validate.notNull((Object)treePath);
        Validate.notNull((Object)operation);
        TreeOperationContext context = new TreeOperationContext(this.getEventThreadQueuer(), this.getRobot(), this.m_tree);
        PathBasedTraverser traverser = new PathBasedTraverser((AbstractTreeOperationContext)context, treePath, new TreeNodeOperationConstraint());
        traverser.traversePath(operation, this.getStartNode(pathType, preAscend, context));
    }

    public void gdExpand(String pathType, int preAscend, String treePath, String operator) throws StepExecutionException {
        this.traverseTreeByPath(this.createStringNodePath(this.splitTextTreePath(treePath), operator), pathType, preAscend, (TreeNodeOperation)new ExpandCollapseTreeNodeOperation(false));
    }

    public void gdExpandByIndices(String pathType, int preAscend, String indexPath) throws StepExecutionException {
        try {
            this.traverseTreeByPath(this.createIndexNodePath(this.splitIndexTreePath(indexPath)), pathType, preAscend, (TreeNodeOperation)new ExpandCollapseTreeNodeOperation(false));
        }
        catch (NumberFormatException e) {
            throw new StepExecutionException(e.getMessage(), EventFactory.createActionError((String)"TestErrorEvent.InvalidIndex"));
        }
    }

    public void gdCollapse(String pathType, int preAscend, String treePath, String operator) throws StepExecutionException {
        this.traverseLastElementByPath(this.createStringNodePath(this.splitTextTreePath(treePath), operator), pathType, preAscend, (TreeNodeOperation)new ExpandCollapseTreeNodeOperation(true));
    }

    public void gdCollapseByIndices(String pathType, int preAscend, String indexPath) throws StepExecutionException {
        try {
            this.traverseLastElementByPath(this.createIndexNodePath(this.splitIndexTreePath(indexPath)), pathType, preAscend, (TreeNodeOperation)new ExpandCollapseTreeNodeOperation(true));
        }
        catch (NumberFormatException e) {
            throw new StepExecutionException(e.getMessage(), EventFactory.createActionError((String)"TestErrorEvent.InvalidIndex"));
        }
    }

    public void gdMove(String direction, int distance, int clickCount) throws StepExecutionException {
        TreeOperationContext context = new TreeOperationContext(this.getEventThreadQueuer(), this.getRobot(), this.m_tree);
        Object selectedNode = this.getSelectedNode(context);
        SelectTreeNodeOperation selectOp = new SelectTreeNodeOperation(ClickOptions.create().setClickCount(clickCount));
        TreeNodeOperationConstraint constraint = new TreeNodeOperationConstraint();
        if ("up".equalsIgnoreCase(direction)) {
            ParentTraverser traverser = new ParentTraverser((AbstractTreeOperationContext)context, distance, constraint);
            traverser.traversePath((TreeNodeOperation)selectOp, selectedNode);
        } else if ("down".equalsIgnoreCase(direction)) {
            ExpandCollapseTreeNodeOperation expandOp = new ExpandCollapseTreeNodeOperation(false);
            ChildTraverser expandTraverser = new ChildTraverser((AbstractTreeOperationContext)context, distance - 1);
            expandTraverser.traversePath((TreeNodeOperation)expandOp, selectedNode);
            ChildTraverser selectTraverser = new ChildTraverser((AbstractTreeOperationContext)context, distance, constraint);
            selectTraverser.traversePath((TreeNodeOperation)selectOp, selectedNode);
        } else if ("next".equalsIgnoreCase(direction)) {
            SiblingTraverser traverser = new SiblingTraverser((AbstractTreeOperationContext)context, distance, true, constraint);
            traverser.traversePath((TreeNodeOperation)selectOp, selectedNode);
        } else if ("previous".equalsIgnoreCase(direction)) {
            SiblingTraverser traverser = new SiblingTraverser((AbstractTreeOperationContext)context, distance, false, constraint);
            traverser.traversePath((TreeNodeOperation)selectOp, selectedNode);
        }
    }

    public void gdSelect(String pathType, int preAscend, String treePath, String operator, int clickCount, int button, String extendSelection) throws StepExecutionException {
        this.selectByPath(pathType, preAscend, this.createStringNodePath(this.splitTextTreePath(treePath), operator), ClickOptions.create().setClickCount(clickCount).setMouseButton(button).setClickModifier(this.getClickModifier(extendSelection)));
    }

    public void gdSelectByIndices(String pathType, int preAscend, String indexPath, int clickCount, int button, String extendSelection) throws StepExecutionException {
        this.selectByPath(pathType, preAscend, this.createIndexNodePath(this.splitIndexTreePath(indexPath)), ClickOptions.create().setClickCount(clickCount).setMouseButton(button).setClickModifier(this.getClickModifier(extendSelection)));
    }

    private void selectByPath(String pathType, int preAscend, INodePath objectPath, ClickOptions co) {
        ExpandCollapseTreeNodeOperation expOp = new ExpandCollapseTreeNodeOperation(false);
        SelectTreeNodeOperation selectOp = new SelectTreeNodeOperation(co);
        INodePath subPath = objectPath.subPath(0, objectPath.getLength() - 1);
        this.traverseTreeByPath(subPath, pathType, preAscend, (TreeNodeOperation)expOp);
        this.traverseLastElementByPath(objectPath, pathType, preAscend, (TreeNodeOperation)selectOp);
    }

    public void gdVerifySelectedValue(String selection) throws StepExecutionException {
        this.gdVerifySelectedValue(selection, "equals");
    }

    public void gdVerifySelectedValue(String pattern, String operator) throws StepExecutionException {
        TreeOperationContext context = new TreeOperationContext(this.getEventThreadQueuer(), this.getRobot(), this.m_tree);
        this.checkNodeText(this.getSelectedNode(context), pattern, operator);
    }

    private void checkNodeText(Object node, String pattern, String operator) throws StepVerifyFailedException {
        TreeOperationContext context = new TreeOperationContext(this.getEventThreadQueuer(), this.getRobot(), this.m_tree);
        Collection nodeTextList = context.getNodeTextList(node);
        Iterator it = nodeTextList.iterator();
        boolean isMatched = false;
        while (it.hasNext() && !isMatched) {
            try {
                Verifier.match((String)((String)it.next()), (String)pattern, (String)operator);
                isMatched = true;
            }
            catch (StepVerifyFailedException svfe) {
                if (it.hasNext()) continue;
                throw svfe;
            }
        }
    }

    private Object getNodeAtMousePosition() throws StepExecutionException {
        return this.getEventThreadQueuer().invokeAndWait("getNodeAtMousePosition", new IRunnable(){

            public Object run() throws StepExecutionException {
                TreePath treePath;
                Point mousePosition = JTreeImplClass.this.getRobot().getCurrentMousePosition();
                Point treeLocation = JTreeImplClass.this.m_tree.getLocationOnScreen();
                Point relativePos = new Point(mousePosition.x - treeLocation.x, mousePosition.y - treeLocation.y);
                int rowAtMousePosition = JTreeImplClass.this.m_tree.getRowForLocation(relativePos.x, relativePos.y);
                if (rowAtMousePosition != -1 && (treePath = JTreeImplClass.this.m_tree.getPathForLocation(relativePos.x, relativePos.y)) != null && treePath.getLastPathComponent() != null) {
                    return treePath.getLastPathComponent();
                }
                throw new StepExecutionException("No tree node found at mouse position.", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
            }
        });
    }

    private Object getSelectedNode(TreeOperationContext context) {
        return context.getSelectedNode();
    }

    public void gdVerifyPath(String pathType, int preAscend, String treePath, String operator, boolean exists) {
        try {
            this.gdExpand(pathType, preAscend, treePath, operator);
        }
        catch (StepExecutionException stepExecutionException) {
            if (exists) {
                throw new StepVerifyFailedException("Verify failed on tree-path: " + treePath, EventFactory.createVerifyFailed((String)treePath, (String)""));
            }
            return;
        }
        if (!exists) {
            throw new StepVerifyFailedException("Verify failed on tree-path: ", EventFactory.createVerifyFailed((String)"", (String)treePath));
        }
    }

    public void gdVerifyPathByIndices(String pathType, int preAscend, String treePath, boolean exists) {
        try {
            this.gdExpandByIndices(pathType, preAscend, treePath);
        }
        catch (StepExecutionException stepExecutionException) {
            if (exists) {
                throw new StepVerifyFailedException("Verify failed on tree-path: " + treePath, EventFactory.createVerifyFailed((String)treePath, (String)""));
            }
            return;
        }
        if (!exists) {
            throw new StepVerifyFailedException("Verify failed on tree-path: ", EventFactory.createVerifyFailed((String)"", (String)treePath));
        }
    }

    public void gdClick(int count, int button) {
        if (this.getRobot().isMouseInComponent((Object)this.m_tree)) {
            this.getRobot().clickAtCurrentPosition((Object)this.m_tree, count, button);
        } else {
            this.getRobot().click((Object)this.m_tree, null, ClickOptions.create().setClickCount(count).setMouseButton(button));
        }
    }

    public void gdPopupByIndexPathAtSelectedNode(String indexPath) {
        Rectangle rect = this.getSelectedNodeBounds();
        this.gdPopupSelectByIndexPath((int)rect.getCenterX(), (int)rect.getCenterY(), "Pixel", indexPath);
    }

    public void gdPopupByTextPathAtSelectedNode(String textPath) {
        Rectangle rect = this.getSelectedNodeBounds();
        this.gdPopupSelectByIndexPath((int)rect.getCenterX(), (int)rect.getCenterY(), "Pixel", textPath);
    }

    private Rectangle getSelectedNodeBounds() {
        TreeOperationContext context = new TreeOperationContext(this.getEventThreadQueuer(), this.getRobot(), this.m_tree);
        return context.getNodeBounds(this.getSelectedNode(context));
    }

    private Rectangle getBounds(INodePath path) {
        return this.getBounds(path, "absolute", 0);
    }

    private Rectangle getBounds(INodePath path, String pathType, int preAscend) {
        BoundsTreeNodeOperation op = new BoundsTreeNodeOperation();
        this.traverseLastElementByPath(path, pathType, preAscend, (TreeNodeOperation)op);
        if (op.getBounds() == null) {
            throw new StepExecutionException("node not found", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
        }
        return op.getBounds();
    }

    public void gdPopupByIndexPathAtIndexNode(String treeIndexPath, String popupIndexPath) {
        Rectangle bounds = this.getBounds(this.createIndexNodePath(this.splitIndexTreePath(treeIndexPath)));
        this.gdPopupSelectByIndexPath((int)bounds.getCenterX(), (int)bounds.getCenterY(), "Pixel", popupIndexPath);
    }

    public void gdPopupByTextPathAtIndexNode(String treeIndexPath, String popupTextPath) {
        Rectangle bounds = this.getBounds(this.createIndexNodePath(this.splitIndexTreePath(treeIndexPath)));
        this.gdPopupSelectByTextPath((int)bounds.getCenterX(), (int)bounds.getCenterY(), "Pixel", popupTextPath, "equals");
    }

    public void gdPopupByIndexPathAtTextNode(String treeTextPath, String operator, String popupIndexPath) {
        Rectangle bounds = this.getBounds(this.createStringNodePath(this.splitTextTreePath(treeTextPath), operator));
        this.gdPopupSelectByIndexPath((int)bounds.getCenterX(), (int)bounds.getCenterY(), "Pixel", popupIndexPath);
    }

    public void gdPopupByTextPathAtTextNode(String treeTextPath, String operator, String popupIndexPath) {
        Rectangle bounds = this.getBounds(this.createStringNodePath(this.splitTextTreePath(treeTextPath), operator));
        this.gdPopupSelectByTextPath((int)bounds.getCenterX(), (int)bounds.getCenterY(), "Pixel", popupIndexPath, "equals");
    }

    public void gdDragByTextPath(int mouseButton, String modifier, String pathType, int preAscend, String treePath, String operator) {
        DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
        dndHelper.setModifier(modifier);
        dndHelper.setMouseButton(mouseButton);
        this.gdSelect(pathType, preAscend, treePath, operator, 0, 1, "no");
        this.pressOrReleaseModifiers(modifier, true);
        this.getRobot().mousePress(null, null, mouseButton);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void gdDropByTextPath(String pathType, int preAscend, String treePath, String operator, int delayBeforeDrop) {
        try {
            this.gdSelect(pathType, preAscend, treePath, operator, 0, 1, "no");
            JTreeImplClass.waitBeforeDrop(delayBeforeDrop);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
            this.getRobot().mouseRelease(null, null, dndHelper.getMouseButton());
            this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
        this.getRobot().mouseRelease(null, null, dndHelper.getMouseButton());
        this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
    }

    public void gdDragByIndexPath(int mouseButton, String modifier, String pathType, int preAscend, String indexPath) {
        DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
        dndHelper.setModifier(modifier);
        dndHelper.setMouseButton(mouseButton);
        this.gdSelectByIndices(pathType, preAscend, indexPath, 0, 1, "no");
        this.pressOrReleaseModifiers(modifier, true);
        this.getRobot().mousePress(null, null, mouseButton);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void gdDropByIndexPath(String pathType, int preAscend, String indexPath, int delayBeforeDrop) {
        try {
            this.gdSelectByIndices(pathType, preAscend, indexPath, 0, 1, "no");
            JTreeImplClass.waitBeforeDrop(delayBeforeDrop);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
            this.getRobot().mouseRelease(null, null, dndHelper.getMouseButton());
            this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
        this.getRobot().mouseRelease(null, null, dndHelper.getMouseButton());
        this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
    }

    public String[] getTextArrayFromComponent() {
        return null;
    }

    protected String getText() {
        return null;
    }

    public void gdVerifyTextAtMousePosition(String pattern, String operator) {
        this.checkNodeText(this.getNodeAtMousePosition(), pattern, operator);
    }

    public String gdStoreSelectedNodeValue(String variable) {
        TreeOperationContext context = new TreeOperationContext(this.getEventThreadQueuer(), this.getRobot(), this.m_tree);
        Object selectedNode = this.getSelectedNode(context);
        if (selectedNode == null) {
            throw new StepExecutionException("No tree item selected", EventFactory.createActionError((String)"TestErrorEvent.NoSelection"));
        }
        return context.getRenderedText(selectedNode);
    }

    public String gdStoreValueAtMousePosition(String variable) {
        TreeOperationContext context = new TreeOperationContext(this.getEventThreadQueuer(), this.getRobot(), this.m_tree);
        return context.getRenderedText(this.getNodeAtMousePosition());
    }
}

