/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swing.swing.implclasses;

import java.util.ArrayList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.driver.IRobot;
import org.eclipse.jubula.rc.common.driver.RobotTiming;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.implclasses.MatchUtil;
import org.eclipse.jubula.rc.common.implclasses.MenuUtilBase;
import org.eclipse.jubula.tools.objects.event.EventFactory;

public abstract class MenuUtil
extends MenuUtilBase {
    private MenuUtil() {
    }

    public static JMenu findMenu(JMenuBar mb, String name, String operator) {
        MenuElement[] subElements = mb.getSubElements();
        int j = 0;
        while (j < subElements.length) {
            JMenu menu;
            if (subElements[j] instanceof JMenu && (menu = (JMenu)subElements[j]).isShowing() && MatchUtil.getInstance().match(menu.getText(), name, operator)) {
                return menu;
            }
            ++j;
        }
        return null;
    }

    public static JMenu findMenu(JMenuBar mb, int idx) {
        ArrayList<JMenu> visibleSubMenus = new ArrayList<JMenu>();
        MenuElement[] subElements = mb.getSubElements();
        int i = 0;
        while (i < subElements.length) {
            JMenu menu;
            if (subElements[i] instanceof JMenu && (menu = (JMenu)subElements[i]) != null && menu.isShowing()) {
                visibleSubMenus.add(menu);
            }
            ++i;
        }
        if (idx >= visibleSubMenus.size() || idx < 0) {
            return null;
        }
        return (JMenu)visibleSubMenus.get(idx);
    }

    private static JMenuItem findMenuItem(MenuElement menu, String name, String operator) {
        MenuElement[] elems = menu.getSubElements();
        int i = 0;
        while (i < elems.length) {
            if (elems[i] instanceof JMenuItem) {
                JMenuItem item = (JMenuItem)elems[i];
                if (MatchUtil.getInstance().match(item.getText(), name, operator)) {
                    return item;
                }
            }
            ++i;
        }
        return null;
    }

    private static JMenuItem findMenuItem(JMenu mn, String name, String operator) {
        int j = 0;
        while (j < mn.getItemCount()) {
            JMenuItem itn = mn.getItem(j);
            if (itn != null && itn.isShowing() && MatchUtil.getInstance().match(itn.getText(), name, operator)) {
                return itn;
            }
            ++j;
        }
        return null;
    }

    public static int[] splitIndexPath(String path) {
        return MenuUtilBase.splitIndexPath((String)path);
    }

    public static String[] splitPath(String path) {
        return MenuUtilBase.splitPath((String)path);
    }

    private static JMenuItem findMenuItem(JMenu menu, int idx) {
        ArrayList<JMenuItem> items = new ArrayList<JMenuItem>();
        int i = 0;
        while (i < menu.getItemCount()) {
            JMenuItem it = menu.getItem(i);
            if (it != null && it.isShowing()) {
                items.add(it);
            }
            ++i;
        }
        if (idx >= items.size()) {
            return null;
        }
        return (JMenuItem)items.get(idx);
    }

    public static JMenuItem findMenuItem(MenuElement menu, int idx) {
        MenuElement[] elems = menu.getSubElements();
        ArrayList<MenuElement> items = new ArrayList<MenuElement>();
        int i = 0;
        while (i < elems.length) {
            if (elems[i] instanceof JMenuItem && ((JMenuItem)elems[i]).isShowing()) {
                items.add(elems[i]);
            }
            ++i;
        }
        if (idx >= items.size()) {
            throw new StepExecutionException("no such element: " + idx, EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
        }
        return (JMenuItem)items.get(idx);
    }

    public static void closeMenu(IRobot robot, JMenuBar menuBar, int item) {
        JMenu menu;
        if (menuBar.getSelectionModel().getSelectedIndex() == item && (menu = MenuUtil.findMenu(menuBar, item)) != null) {
            MenuUtil.clickMenuItem(robot, menu);
        }
    }

    public static void closeMenu(IRobot robot, JMenuBar menuBar, String item) {
        JMenu menu;
        int index = MenuUtil.getItemNumber(menuBar, item);
        if (menuBar.getSelectionModel().getSelectedIndex() == index && (menu = MenuUtil.findMenu(menuBar, index)) != null) {
            MenuUtil.clickMenuItem(robot, menu);
        }
    }

    public static void closePopupMenu(IRobot robot, JPopupMenu popup) {
        robot.keyType((Object)popup, 27);
    }

    private static int getItemNumber(JMenuBar menuBar, String item) {
        MenuElement[] subElements = menuBar.getSubElements();
        int invisibleElementCount = 0;
        int i = 0;
        while (i < subElements.length) {
            if (subElements[i] instanceof JMenu) {
                JMenu menu = (JMenu)subElements[i];
                if (!menu.isShowing()) {
                    ++invisibleElementCount;
                } else if (menu.getText().equals(item)) {
                    return i - invisibleElementCount;
                }
            }
            ++i;
        }
        return -1;
    }

    public static JMenuItem navigateToMenuItem(IRobot robot, JMenuBar menuBar, String[] path, String operator) {
        if (path.length < 1) {
            throw new StepExecutionException("invalid path", EventFactory.createActionError((String)"TestErrorEvent.InvalidParameterValue"));
        }
        JMenu menu = MenuUtil.findMenu(menuBar, path[0], operator);
        if (menu == null) {
            return null;
        }
        return MenuUtil.navigateToMenuItem(robot, menu, path, operator, 1);
    }

    public static JMenuItem navigateToMenuItem(IRobot robot, JMenuBar menuBar, int[] path) {
        if (path.length < 1) {
            throw new StepExecutionException("invalid path", EventFactory.createActionError((String)"TestErrorEvent.InvalidParameterValue"));
        }
        JMenu menu = MenuUtil.findMenu(menuBar, path[0]);
        return MenuUtil.navigateToMenuItem(robot, menu, path, 1);
    }

    public static JMenuItem navigateToMenuItem(IRobot robot, JPopupMenu popup, String[] path, String operator) {
        if (path.length < 1) {
            throw new StepExecutionException("invalid path", EventFactory.createActionError((String)"TestErrorEvent.InvalidParameterValue"));
        }
        JMenuItem item = MenuUtil.findMenuItem(popup, path[0], operator);
        return MenuUtil.navigateToMenuItem(robot, item, path, operator, 1);
    }

    public static JMenuItem navigateToMenuItem(IRobot robot, JPopupMenu popup, int[] path) {
        if (path.length < 1) {
            throw new StepExecutionException("invalid path", EventFactory.createActionError((String)"TestErrorEvent.InvalidParameterValue"));
        }
        JMenuItem item = MenuUtil.findMenuItem(popup, path[0]);
        return MenuUtil.navigateToMenuItem(robot, item, path, 1);
    }

    private static JMenuItem navigateToMenuItem(IRobot robot, JMenuItem item, String[] path, String operator, int idx) {
        if (path.length == idx) {
            return item;
        }
        if (!(item instanceof JMenu)) {
            throw new StepExecutionException("unexpected item found", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
        }
        MenuUtil.clickMenuItem(robot, item);
        RobotTiming.sleepPostShowSubMenuItem();
        JMenuItem next = MenuUtil.findMenuItem((JMenu)item, path[idx], operator);
        return MenuUtil.navigateToMenuItem(robot, next, path, operator, idx + 1);
    }

    private static JMenuItem navigateToMenuItem(IRobot robot, JMenuItem item, int[] path, int idx) {
        if (path.length == idx) {
            return item;
        }
        if (!(item instanceof JMenu)) {
            throw new StepExecutionException("unexpected item found", EventFactory.createActionError());
        }
        MenuUtil.clickMenuItem(robot, item);
        RobotTiming.sleepPostShowSubMenuItem();
        JMenuItem next = MenuUtil.findMenuItem((JMenu)item, path[idx]);
        return MenuUtil.navigateToMenuItem(robot, next, path, idx + 1);
    }

    public static void clickMenuItem(IRobot robot, JMenuItem item) {
        if (!item.isEnabled()) {
            throw new StepExecutionException("menu item not enabled", EventFactory.createActionError((String)"TestErrorEvent.MenuItemNotEnabled"));
        }
        robot.click((Object)item, null, ClickOptions.create().setClickType(ClickOptions.ClickType.RELEASED));
    }
}

