/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.business.api.editor;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.factory.SessionFactory;
import org.eclipse.sirius.ui.business.api.session.IEditingSession;
import org.eclipse.sirius.ui.business.api.session.SessionUIManager;

public class SpecificSessionManager {
    private Session session;

    public void closeSession() {
        IEditingSession uiSession = SessionUIManager.INSTANCE.getUISession(this.session);
        if (uiSession != null) {
            uiSession.close();
        }
        this.session.close((IProgressMonitor)new NullProgressMonitor());
        this.session = null;
    }

    public Session getSession() {
        return this.session;
    }

    public void createSession(IPath semanticModelPath, String analysisFilenameURI) throws IOException {
        Session createdSession;
        try {
            createdSession = SessionFactory.INSTANCE.createSession(URI.createURI((String)analysisFilenameURI), (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreException) {
            return;
        }
        URI semanticResourceURI = URI.createURI((String)semanticModelPath.toPortableString(), (boolean)true);
        createdSession.addSemanticResource(semanticResourceURI, (IProgressMonitor)new NullProgressMonitor());
        if (createdSession != null) {
            IEditingSession uiSession = SessionUIManager.INSTANCE.getOrCreateUISession(createdSession);
            uiSession.open();
        }
    }
}

