/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.business.internal.dialect.editor;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.sirius.business.internal.session.danalysis.DanglingRefRemovalTrigger;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.sirius.viewpoint.ViewpointPackage;

public class DialectEditorCloserFilter
extends NotificationFilter.Custom {
    private DRepresentation dRepresentation;

    public DialectEditorCloserFilter(DRepresentation dRepresentation) {
        this.dRepresentation = dRepresentation;
    }

    public boolean matches(Notification notification) {
        return this.isTargetUnset(notification) || this.isRepresentationDeletion(notification) || this.isTargetDetachment(notification);
    }

    private boolean isTargetUnset(Notification notification) {
        boolean remove;
        boolean bl = remove = notification.getEventType() == 4 || notification.getEventType() == 2;
        return remove && notification.getNotifier() == this.dRepresentation && notification.getFeature() == ViewpointPackage.Literals.DSEMANTIC_DECORATOR__TARGET;
    }

    private boolean isRepresentationDeletion(Notification notification) {
        int eventType;
        boolean representationDeleted = false;
        if (notification.getFeature() == ViewpointPackage.Literals.DVIEW__OWNED_REPRESENTATIONS && ((eventType = notification.getEventType()) == 4 || eventType == 2 || eventType == 6)) {
            representationDeleted = this.isInOldValue(notification, this.dRepresentation) && !(this.dRepresentation.eContainer() instanceof DView);
        }
        return representationDeleted;
    }

    private boolean isInOldValue(Notification notification, Object obj) {
        if (notification.getOldValue() instanceof Collection) {
            return ((Collection)notification.getOldValue()).contains(this.dRepresentation);
        }
        return notification.getOldValue() == obj;
    }

    private boolean isTargetDetachment(Notification notification) {
        boolean detachedTarget = false;
        if (DanglingRefRemovalTrigger.IS_DETACHMENT.apply((Object)notification) && this.dRepresentation instanceof DSemanticDecorator) {
            EObject target = ((DSemanticDecorator)this.dRepresentation).getTarget();
            detachedTarget = this.isInOldValue(notification, target) && target.eContainer() == null;
        }
        return detachedTarget;
    }
}

