/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.api.project;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.SourceVersion;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sirius.viewpoint.description.DescriptionFactory;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.eclipse.sirius.viewpoint.description.Group;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.osgi.framework.Bundle;

public final class ViewpointSpecificationProject {
    public static final String VIEWPOINT_MODEL_EXTENSION = SiriusEditPlugin.INSTANCE.getString("_UI_SiriusEditorFilenameExtension");
    public static final String INITIAL_OBJECT_NAME = DescriptionPackage.Literals.GROUP.getName();
    public static final String ENCODING_DEFAULT = "UTF-8";
    private static final String NL = System.getProperty("line.separator");
    private static final DescriptionPackage DESCRIPTION_PACKAGE = DescriptionPackage.eINSTANCE;
    private static final DescriptionFactory DESCRIPTION_FACTORY = DESCRIPTION_PACKAGE.getDescriptionFactory();
    private static final String DEFAULT_PACKAGE_NAME = "defaultpackage";
    private static final String UNAUTHORIZED_CHARACTER = "[^a-zA-Z0-9_\\.-]";

    private ViewpointSpecificationProject() {
    }

    public static IProject createNewViewpointSpecificationProject(String projectName, String modelName) throws CoreException {
        IPath projectLocationPath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        Shell activeShell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
        ProgressMonitorDialog monitorDialog = new ProgressMonitorDialog(activeShell);
        return ViewpointSpecificationProject.createNewViewpointSpecificationProject(PlatformUI.getWorkbench(), projectName, projectLocationPath, modelName, INITIAL_OBJECT_NAME, ENCODING_DEFAULT, (IRunnableContext)monitorDialog);
    }

    public static IProject createNewViewpointSpecificationProject(final IWorkbench workbench, final String projectName, final IPath projectLocationPath, final String modelName, final String modelInitialObjectName, final String encoding, final IRunnableContext runnable) throws CoreException {
        IWorkspaceRunnable create = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                if (!project.exists()) {
                    IFile modelFile;
                    IProjectDescription desc = project.getWorkspace().newProjectDescription(projectName);
                    IPath projectLocationPathTemp = projectLocationPath;
                    if (projectLocationPath != null && ResourcesPlugin.getWorkspace().getRoot().getLocation().equals((Object)projectLocationPath)) {
                        projectLocationPathTemp = null;
                    }
                    desc.setLocation(projectLocationPathTemp);
                    project.create(desc, monitor);
                    project.open(monitor);
                    ViewpointSpecificationProject.createFolder(project, monitor, "src");
                    ViewpointSpecificationProject.createFolder(project, monitor, "description");
                    try {
                        modelFile = ViewpointSpecificationProject.createODesignFile(project, modelName, modelInitialObjectName, encoding, runnable);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    catch (InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    ViewpointSpecificationProject.selectAndOpen(workbench, modelFile);
                    ViewpointSpecificationProject.convert(project, modelName, monitor);
                }
                if (!project.isOpen()) {
                    project.open(monitor);
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(create, null);
        return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
    }

    protected static void createFolder(IProject prj, IProgressMonitor monitor, String folderName) throws CoreException {
        IFolder folder = prj.getFolder((IPath)new Path(folderName));
        if (!folder.exists()) {
            folder.create(true, true, monitor);
        }
    }

    protected static IFile createODesignFile(IProject prj, final String modelName, final String modelInitialObjectName, final String encoding, IRunnableContext runnable) throws IOException, InvocationTargetException, InterruptedException {
        final IFile modelFile = ViewpointSpecificationProject.getModelFile(prj, modelName);
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor progressMonitor) {
                try {
                    try {
                        ResourceSetImpl resourceSet = new ResourceSetImpl();
                        URI fileURI = URI.createPlatformResourceURI((String)modelFile.getFullPath().toString(), (boolean)true);
                        Resource resource = resourceSet.createResource(fileURI);
                        EObject rootObject = ViewpointSpecificationProject.createInitialModel(modelInitialObjectName);
                        if (rootObject != null) {
                            if (rootObject instanceof Group) {
                                ((Group)rootObject).setName(modelName.replaceAll("." + VIEWPOINT_MODEL_EXTENSION, ""));
                            }
                            resource.getContents().add((Object)rootObject);
                        }
                        HashMap<String, String> options = new HashMap<String, String>();
                        options.put("ENCODING", encoding);
                        resource.save(options);
                    }
                    catch (IOException ioe) {
                        Status status = new Status(4, "org.eclipse.sirius.ui", 0, ioe.getMessage(), (Throwable)ioe);
                        SiriusEditPlugin.getPlugin().getLog().log((IStatus)status);
                        progressMonitor.done();
                    }
                }
                finally {
                    progressMonitor.done();
                }
            }
        };
        try {
            runnable.run(false, false, (IRunnableWithProgress)operation);
        }
        catch (InvocationTargetException exception) {
            Status status = new Status(4, "org.eclipse.sirius.ui", 0, exception.getMessage(), (Throwable)exception);
            SiriusEditPlugin.getPlugin().getLog().log((IStatus)status);
        }
        catch (InterruptedException exception) {
            Status status = new Status(4, "org.eclipse.sirius.ui", 0, exception.getMessage(), (Throwable)exception);
            SiriusEditPlugin.getPlugin().getLog().log((IStatus)status);
        }
        return modelFile;
    }

    private static void selectAndOpen(IWorkbench workbench, IFile modelFile) {
        IWorkbenchPage activePage = workbench.getActiveWorkbenchWindow().getActivePage();
        final IWorkbenchPart activePart = activePage.getActivePart();
        if (activePart instanceof ISetSelectionTarget) {
            StructuredSelection targetSelection = new StructuredSelection((Object)modelFile);
            ViewpointSpecificationProject.getShell().getDisplay().asyncExec(new Runnable((ISelection)targetSelection){
                private final /* synthetic */ ISelection val$targetSelection;
                {
                    this.val$targetSelection = iSelection;
                }

                @Override
                public void run() {
                    ((ISetSelectionTarget)activePart).selectReveal(this.val$targetSelection);
                }
            });
        }
        try {
            activePage.openEditor((IEditorInput)new FileEditorInput(modelFile), workbench.getEditorRegistry().getDefaultEditor(modelFile.getFullPath().toString()).getId());
        }
        catch (PartInitException exception) {
            MessageDialog.openError((Shell)ViewpointSpecificationProject.getShell(), (String)SiriusEditPlugin.INSTANCE.getString("_UI_OpenEditorError_label"), (String)exception.getMessage());
        }
    }

    private static Shell getShell() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    private static void convert(IProject prj, String modelName, IProgressMonitor monitor) {
        String modelNameWithoutExtension = modelName.replaceAll("\\." + VIEWPOINT_MODEL_EXTENSION + "$", "");
        HashMap<String, String> replacements = new HashMap<String, String>();
        String projectName = prj.getName().replaceAll(UNAUTHORIZED_CHARACTER, "_");
        String packageName = SourceVersion.isName(prj.getName()) ? prj.getName() : (SourceVersion.isName(projectName) ? projectName : DEFAULT_PACKAGE_NAME);
        replacements.put("pluginId", projectName);
        replacements.put("projectName", projectName);
        replacements.put("modelName", modelNameWithoutExtension);
        replacements.put("packageName", packageName);
        ViewpointSpecificationProject.createFileFromTemplate(prj, "build.properties", "resources/build.properties", replacements, monitor);
        ViewpointSpecificationProject.createFileFromTemplate(prj, "src/" + packageName.replaceAll("\\.", "/") + "/Activator.java", "resources/Activator.java_", replacements, monitor);
        ViewpointSpecificationProject.createFileFromTemplate(prj, ".classpath", "resources/classpath.xml", replacements, monitor);
        ViewpointSpecificationProject.createFileFromTemplate(prj, "META-INF/MANIFEST.MF", "resources/MANIFEST.MF", replacements, monitor);
        ViewpointSpecificationProject.createFileFromTemplate(prj, ".project", "resources/project.xml", replacements, monitor);
        ViewpointSpecificationProject.createFileFromTemplate(prj, "plugin.xml", "resources/plugin.xml", replacements, monitor);
    }

    private static void createFileFromTemplate(IProject prj, String newFilePath, String templatePath, Map<String, String> replacements, IProgressMonitor monitor) {
        try {
            String templateContent = ViewpointSpecificationProject.getTemplateFileContents(templatePath);
            String finalContent = ViewpointSpecificationProject.applyReplacements(templateContent, replacements);
            ViewpointSpecificationProject.createFile(prj, (IPath)new Path(newFilePath), finalContent, monitor);
        }
        catch (IOException e) {
            Status status = new Status(4, "org.eclipse.sirius.ui", 0, e.getMessage(), (Throwable)e);
            SiriusEditPlugin.getPlugin().getLog().log((IStatus)status);
        }
    }

    private static String getTemplateFileContents(String path) throws IOException {
        InputStream is = FileLocator.openStream((Bundle)SiriusEditPlugin.getPlugin().getBundle(), (IPath)new Path(path), (boolean)false);
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                sb.append(line).append(NL);
            }
        }
        finally {
            is.close();
        }
        return sb.toString();
    }

    private static String applyReplacements(String text, Map<String, String> replacements) {
        String result = text;
        for (Map.Entry<String, String> replacement : replacements.entrySet()) {
            result = result.replaceAll("%" + replacement.getKey(), replacement.getValue());
        }
        return result;
    }

    private static void createFile(IProject prj, IPath projectRelativePath, String content, IProgressMonitor monitor) {
        try {
            IContainer container = ViewpointSpecificationProject.createContainer(prj, projectRelativePath, monitor);
            IFile file = container.getFile((IPath)new Path(projectRelativePath.lastSegment()));
            if (!file.exists() && file.getParent().exists()) {
                IResource[] members;
                IResource[] iResourceArray = members = file.getParent().members(1);
                int n = members.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource element = iResourceArray[n2];
                    if (element instanceof IFile && file.getName().toLowerCase().equals(element.getName().toLowerCase())) {
                        file = (IFile)element;
                        break;
                    }
                    ++n2;
                }
            }
            ByteArrayInputStream javaStream = new ByteArrayInputStream(content.getBytes("UTF8"));
            if (!file.exists()) {
                file.create((InputStream)javaStream, true, monitor);
            } else {
                file.setContents((InputStream)javaStream, true, false, monitor);
            }
        }
        catch (CoreException e) {
            Status status = new Status(4, "org.eclipse.sirius.ui", 0, e.getMessage(), (Throwable)e);
            SiriusEditPlugin.getPlugin().getLog().log((IStatus)status);
        }
        catch (UnsupportedEncodingException e) {
            Status status = new Status(4, "org.eclipse.sirius.ui", 0, e.getMessage(), (Throwable)e);
            SiriusEditPlugin.getPlugin().getLog().log((IStatus)status);
        }
    }

    private static IContainer createContainer(IProject prj, IPath projectRelativePath, IProgressMonitor monitor) throws CoreException {
        String[] folders;
        IProject container = prj;
        String[] stringArray = folders = projectRelativePath.removeLastSegments(1).segments();
        int n = folders.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            if (!(container = container.getFolder((IPath)new Path(element))).exists()) {
                ((IFolder)container).create(true, true, monitor);
            }
            ++n2;
        }
        return container;
    }

    private static IFile getModelFile(IProject project, String modelName) {
        return ResourcesPlugin.getWorkspace().getRoot().getFile(project.getFullPath().append("description/" + modelName));
    }

    private static EObject createInitialModel(String modelInitialObjectName) {
        EClass eClass = (EClass)DESCRIPTION_PACKAGE.getEClassifier(modelInitialObjectName);
        EObject rootObject = DESCRIPTION_FACTORY.create(eClass);
        return rootObject;
    }
}

