/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.editor;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.TransactionChangeDescription;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.sirius.business.api.query.DRepresentationElementQuery;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.business.internal.session.SessionEventBrokerImpl;
import org.eclipse.sirius.business.internal.session.danalysis.DanglingRefRemovalTrigger;
import org.eclipse.sirius.common.ui.tools.api.util.EclipseUIUtil;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.UIState;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.eclipse.ui.IEditorPart;

public class SelectDRepresentationElementsListener
extends ResourceSetListenerImpl {
    private static final NotificationFilter DEFAULT_NOTIFICATION_FILTER = NotificationFilter.createFeatureFilter((EStructuralFeature)ViewpointPackage.Literals.UI_STATE__ELEMENTS_TO_SELECT).or(NotificationFilter.NOT_TOUCH.and(SessionEventBrokerImpl.asFilter((Predicate)DanglingRefRemovalTrigger.IS_ATTACHMENT)).and(NotificationFilter.createNotifierTypeFilter((EClassifier)ViewpointPackage.Literals.DREPRESENTATION).or(NotificationFilter.createNotifierTypeFilter((EClassifier)ViewpointPackage.Literals.DREPRESENTATION_ELEMENT))));
    protected DialectEditor dialectEditor;
    private boolean selectOnlyViewWithNewSemanticTarget;

    public SelectDRepresentationElementsListener(DialectEditor editor, boolean selectOnlyViewWithNewSemanticTarget) {
        super(DEFAULT_NOTIFICATION_FILTER);
        TransactionalEditingDomain domain;
        this.dialectEditor = (DialectEditor)Preconditions.checkNotNull((Object)editor);
        this.selectOnlyViewWithNewSemanticTarget = selectOnlyViewWithNewSemanticTarget;
        DRepresentation representation = editor.getRepresentation();
        if (representation != null && (domain = TransactionUtil.getEditingDomain((EObject)representation)) != null) {
            domain.addResourceSetListener((ResourceSetListener)this);
        }
    }

    public boolean isPostcommitOnly() {
        return true;
    }

    public void resourceSetChanged(ResourceSetChangeEvent event) {
        DRepresentation currentRep;
        List<DRepresentationElement> elementsToSelect;
        IEditorPart activeEditor = EclipseUIUtil.getActiveEditor();
        if (!Boolean.TRUE.equals(event.getTransaction().getOptions().get("is_undo_redo_transaction")) && this.dialectEditor.equals(activeEditor) && (elementsToSelect = this.extractElementsToSelect(event, currentRep = this.dialectEditor.getRepresentation())) != null) {
            EclipseUIUtil.displayAsyncExec((Runnable)new SetSelectionRunnable(this.dialectEditor, elementsToSelect));
        }
    }

    private List<DRepresentationElement> extractElementsToSelect(ResourceSetChangeEvent event, DRepresentation currentRep) {
        UIState uiState;
        List<DRepresentationElement> elementsToSelectFromUiState;
        List<Object> elementsToSelect = null;
        ArrayList notifiedElements = Lists.newArrayList();
        boolean elementsToSelectUpdated = this.analyseNotifications(event, currentRep, notifiedElements);
        elementsToSelect = elementsToSelectUpdated ? ((elementsToSelectFromUiState = this.extractSelectionFromUIState(currentRep, notifiedElements)) != null ? elementsToSelectFromUiState : (notifiedElements.size() > 0 ? notifiedElements : null)) : (notifiedElements.isEmpty() ? null : notifiedElements);
        if (elementsToSelect != null && !elementsToSelect.isEmpty() && (uiState = currentRep.getUiState()) != null && uiState.isInverseSelectionOrder()) {
            Collections.reverse(elementsToSelect);
        }
        return elementsToSelect;
    }

    private List<DRepresentationElement> extractSelectionFromUIState(DRepresentation currentRep, List<DRepresentationElement> notifiedElements) {
        ArrayList selectedElements = null;
        ArrayList dRepElements = Lists.newArrayList();
        ArrayList semanticElements = Lists.newArrayList();
        UIState uiState = currentRep.getUiState();
        if (uiState != null && uiState.isSetElementsToSelect()) {
            EList elementsToSelectFromUIState = uiState.getElementsToSelect();
            boolean hasRepElement = false;
            boolean hasSemanticElement = false;
            boolean hasRepresentation = false;
            for (EObject currentElement : elementsToSelectFromUIState) {
                if (currentElement instanceof DRepresentationElement) {
                    hasRepElement = true;
                    dRepElements.add((DRepresentationElement)currentElement);
                    continue;
                }
                if (currentElement instanceof DRepresentation) {
                    hasRepresentation = true;
                    break;
                }
                hasSemanticElement = true;
                semanticElements.add(currentElement);
            }
            if (hasSemanticElement && !hasRepresentation && !hasRepElement) {
                selectedElements = Lists.newArrayList();
                this.caseHasSemanticElement(selectedElements, notifiedElements, semanticElements, currentRep);
            } else if (hasRepElement && !hasRepresentation && !hasSemanticElement) {
                if (!notifiedElements.isEmpty()) {
                    dRepElements.retainAll(notifiedElements);
                }
                selectedElements = Lists.newArrayList((Iterable)dRepElements);
            } else {
                selectedElements = Lists.newArrayList();
            }
        }
        return selectedElements;
    }

    private void caseHasSemanticElement(List<DRepresentationElement> selectedElements, List<DRepresentationElement> notifiedElements, List<EObject> semanticElements, DRepresentation currentRep) {
        for (EObject semanticElement : semanticElements) {
            ArrayList repElementsFromSemantic = Lists.newArrayList();
            EObjectQuery eObjectQuery = new EObjectQuery(semanticElement);
            Collection referencers = eObjectQuery.getInverseReferences(ViewpointPackage.Literals.DSEMANTIC_DECORATOR__TARGET);
            for (EObject referencer : referencers) {
                if (!(referencer instanceof DRepresentationElement) || !currentRep.equals(new EObjectQuery(referencer).getRepresentation().get())) continue;
                repElementsFromSemantic.add((DRepresentationElement)referencer);
            }
            boolean notifiedElementsEmpty = notifiedElements.isEmpty();
            if (!notifiedElementsEmpty) {
                for (DRepresentationElement elem : notifiedElements) {
                    if (!notifiedElementsEmpty && !repElementsFromSemantic.contains(elem)) continue;
                    selectedElements.add(elem);
                }
                continue;
            }
            selectedElements.addAll(repElementsFromSemantic);
        }
    }

    private boolean isViewWithNewSemanticTarget(ResourceSetChangeEvent event, DRepresentationElement view) {
        boolean isViewWithNewSemanticTarget = false;
        TransactionChangeDescription changeDescription = event.getTransaction().getChangeDescription();
        if (changeDescription != null) {
            EList attachedEObjects = changeDescription.getObjectsToDetach();
            isViewWithNewSemanticTarget = EcoreUtil.isAncestor((Collection)attachedEObjects, (EObject)view.getTarget());
        }
        return isViewWithNewSemanticTarget;
    }

    private boolean analyseNotifications(ResourceSetChangeEvent event, DRepresentation currentRep, List<DRepresentationElement> keptNotifiedElements) {
        boolean elementsToSelectUpdated = false;
        for (Notification n : event.getNotifications()) {
            if (!n.getFeature().equals(ViewpointPackage.Literals.UI_STATE__ELEMENTS_TO_SELECT) && !n.getFeature().equals(ViewpointPackage.Literals.DREPRESENTATION__UI_STATE)) {
                Set<DRepresentationElement> notificationValues = this.getNotificationValues(n);
                for (DRepresentationElement elt : notificationValues) {
                    if (currentRep != new DRepresentationElementQuery(elt).getParentRepresentation() || this.selectOnlyViewWithNewSemanticTarget && !this.isViewWithNewSemanticTarget(event, elt) || EcoreUtil.isAncestor(keptNotifiedElements, (EObject)elt)) continue;
                    keptNotifiedElements.add(elt);
                }
                continue;
            }
            elementsToSelectUpdated = true;
        }
        return elementsToSelectUpdated;
    }

    private Set<DRepresentationElement> getNotificationValues(Notification notification) {
        LinkedHashSet values = Sets.newLinkedHashSet();
        Object value = notification.getNewValue();
        if (value instanceof Collection) {
            Iterables.addAll((Collection)values, (Iterable)Iterables.filter((Iterable)((Collection)value), DRepresentationElement.class));
        } else if (value instanceof DRepresentationElement) {
            values.add((DRepresentationElement)value);
        }
        return values;
    }

    public void dispose() {
        if (this.getTarget() != null) {
            this.getTarget().removeResourceSetListener((ResourceSetListener)this);
        }
    }

    private static class SetSelectionRunnable
    implements Runnable {
        private final DialectEditor dialectEditor;
        private List<DRepresentationElement> newSelection;

        public SetSelectionRunnable(DialectEditor dialectEditor, Collection<DRepresentationElement> elementsToSelect) {
            this.dialectEditor = dialectEditor;
            this.newSelection = Lists.newArrayList(elementsToSelect);
        }

        @Override
        public void run() {
            DialectUIManager.INSTANCE.setSelection(this.dialectEditor, this.newSelection);
        }
    }
}

