/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.views.common.action;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.text.MessageFormat;
import java.util.Collection;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sirius.business.api.dialect.command.MoveRepresentationCommand;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.danalysis.DAnalysisSessionHelper;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.ecore.extender.business.api.permission.PermissionAuthorityRegistry;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.sirius.ui.business.api.session.IEditingSession;
import org.eclipse.sirius.ui.business.api.session.SessionUIManager;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationContainer;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class MoveRepresentationAction
extends Action {
    private final Collection<DRepresentation> representations;
    private final DAnalysis targetAnalysis;
    private final Session session;

    public MoveRepresentationAction(Session session, DAnalysis targetAnalysis, Collection<DRepresentation> selection) {
        this.targetAnalysis = targetAnalysis;
        this.session = session;
        this.representations = selection;
        ImageDescriptor descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sirius.ui", (String)"/icons/full/others/forward.gif");
        this.setImageDescriptor(descriptor);
        this.setText(MessageFormat.format(Messages.MoveRepresentationAction_text, targetAnalysis.eResource().getURI().toString()));
        if (!this.isValidSelection()) {
            this.setEnabled(false);
        }
    }

    public void run() {
        IEditingSession uiSession = SessionUIManager.INSTANCE.getUISession(this.session);
        if (uiSession != null) {
            for (DRepresentation representation : this.representations) {
                DialectEditor editor = uiSession.getEditor(representation);
                if (editor == null) continue;
                editor.getEditorSite().getPage().closeEditor((IEditorPart)editor, false);
            }
        }
        this.session.getTransactionalEditingDomain().getCommandStack().execute((Command)new MoveRepresentationCommand(this.session, this.targetAnalysis, this.representations));
    }

    private boolean isValidSelection() {
        boolean anyInvalidMove = Iterables.any(this.representations, (Predicate)new Predicate<DRepresentation>(){

            public boolean apply(DRepresentation input) {
                IPermissionAuthority permissionAuthority;
                DRepresentationContainer targetContainer;
                IPermissionAuthority permissionAuthority2;
                boolean invalid = false;
                EObject container = input.eContainer();
                if (container instanceof DRepresentationContainer && (permissionAuthority2 = PermissionAuthorityRegistry.getDefault().getPermissionAuthority(container)) != null && !permissionAuthority2.canDeleteInstance((EObject)input)) {
                    invalid = true;
                }
                if (!invalid && (targetContainer = DAnalysisSessionHelper.findContainerForAddedRepresentation((DAnalysis)MoveRepresentationAction.this.targetAnalysis, (DRepresentation)input)) != null && (permissionAuthority = PermissionAuthorityRegistry.getDefault().getPermissionAuthority((EObject)targetContainer)) != null && !permissionAuthority.canCreateIn((EObject)targetContainer)) {
                    invalid = true;
                }
                return invalid;
            }
        });
        return !anyInvalidMove;
    }
}

