/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.services.cs.text.generators;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.ide.IDE;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.IGrammarAccess;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.validation.IConcreteSyntaxValidator;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.activityexplorer.model.ViewpointActivityExplorer.ViewpointActivityExplorer;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpbuild.Build;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpconf.Configuration;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Aspect;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Data;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Viewpoint;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.ViewpointElement;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdiagram.DiagramSet;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpservices.PropertySet;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpservices.Rule;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpservices.RuleSet;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpservices.Service;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpservices.ServiceSet;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpui.UIDescription;
import org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.data.DataSpec;
import org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.diagram.Diagrams;
import org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.helpers.vpspec.CoreModelHelper;
import org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.identifiers.EditorIDs;
import org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.resources.ResourceHelper;
import org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.services.VpspecGrammarAccess;
import org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.ui.UserInterface;
import org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.util.PluginUtil;
import org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.vpspec.VpspecFactory;
import org.polarsys.kitalpha.ad.viewpoint.dsl.services.cs.text.generators.IViewpointBackwardSynchronizer;
import org.polarsys.kitalpha.ad.viewpoint.dsl.services.cs.text.generators.setup.BackwardSynchronizerSetup;
import org.polarsys.kitalpha.ad.viewpoint.dsl.services.cs.text.generators.util.GeneratorsUtil;
import org.polarsys.kitalpha.ad.viewpoint.dsl.services.cs.text.generators.util.ReferenceUtil;

public abstract class AbstractSynchronizer
implements IViewpointBackwardSynchronizer {
    @Inject
    private Injector injector;
    protected EcoreUtil.Copier copier;

    protected Injector getInjector() {
        if (this.injector == null) {
            this.injector = new BackwardSynchronizerSetup().createInjectorAndDoEMFRegistration();
        }
        return this.injector;
    }

    protected void createCopier(List<EObject> input) {
        this.copier = new EcoreUtil.Copier(true, true);
        this.copier.copyAll(input);
        this.copier.copyReferences();
    }

    public void doBackwardSynchronize(IStructuredSelection selection) {
        this.doBackwardSynchronize(GeneratorsUtil.computeURI(selection));
    }

    public boolean doBackwardSynchronize(URI emfURI) {
        ResourceSet resourceSet = (ResourceSet)this.getInjector().getInstance(XtextResourceSet.class);
        EObject modelRoot = this.loadInputModel(emfURI, resourceSet);
        if (modelRoot != null) {
            Viewpoint sourceVp = (Viewpoint)modelRoot;
            ArrayList<EObject> input = new ArrayList<EObject>();
            for (EObject aspect : modelRoot.eContents()) {
                EcoreUtil.resolveAll((EObject)aspect);
                input.add(aspect);
            }
            this.createCopier(input);
            Resource primaryResource = this.loadPrimaryResource(modelRoot, resourceSet);
            org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.vpspec.Viewpoint targetVp = null;
            if (!primaryResource.getContents().isEmpty()) {
                targetVp = (org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.vpspec.Viewpoint)primaryResource.getContents().get(0);
            } else {
                targetVp = VpspecFactory.eINSTANCE.createViewpoint();
                targetVp.setName(sourceVp.getName() != null ? sourceVp.getName() : sourceVp.getShortName());
                targetVp.setShortName(sourceVp.getShortName());
                primaryResource.getContents().add((Object)targetVp);
            }
            ReferenceUtil.setTargetReferences(sourceVp, targetVp, resourceSet);
            targetVp = this.doBackwardSynchronize(modelRoot, targetVp, resourceSet);
            if (this.validateObject((EObject)targetVp, (XtextResource)primaryResource)) {
                String serializationContent = ((XtextResource)primaryResource).getSerializer().serialize((EObject)targetVp);
                String newContent = String.valueOf(this.appendCopyRightHeader((EObject)targetVp, targetVp.getShortName())) + serializationContent;
                this.saveNewResource((XtextResource)primaryResource, newContent);
                return true;
            }
        }
        return false;
    }

    public org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.vpspec.Viewpoint doBackwardSynchronize(EObject modelRoot, org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.vpspec.Viewpoint viewpoint, ResourceSet resourceSet) {
        Iterable filter;
        HashMap<Integer, EObject> output = new HashMap<Integer, EObject>();
        Data data = ((Viewpoint)modelRoot).getVP_Data();
        output.put(0, this.backwardSynchronize(data, this.loadDataResource((EObject)data, resourceSet)));
        EList aspects = ((Viewpoint)modelRoot).getVP_Aspects();
        Aspect aspect = (Aspect)IterableExtensions.findFirst((Iterable)aspects, (Functions.Function1)new Functions.Function1<Aspect, Boolean>(){

            public Boolean apply(Aspect c) {
                return c instanceof Configuration;
            }
        });
        if (aspect != null) {
            output.put(5, this.backwardSynchronize((Configuration)aspect, this.loadConfigurationResource((EObject)aspect, resourceSet)));
        }
        if ((aspect = (Aspect)IterableExtensions.findFirst((Iterable)aspects, (Functions.Function1)new Functions.Function1<Aspect, Boolean>(){

            public Boolean apply(Aspect c) {
                return c instanceof UIDescription;
            }
        })) != null) {
            output.put(1, this.backwardSynchronize((UIDescription)aspect, this.loadUIResource((EObject)aspect, resourceSet)));
        }
        if ((aspect = (Aspect)IterableExtensions.findFirst((Iterable)aspects, (Functions.Function1)new Functions.Function1<Aspect, Boolean>(){

            public Boolean apply(Aspect c) {
                return c instanceof DiagramSet;
            }
        })) != null) {
            output.put(2, this.backwardSynchronize((DiagramSet)aspect, this.loadDiagramResource((EObject)aspect, resourceSet)));
        }
        if ((aspect = (Aspect)IterableExtensions.findFirst((Iterable)aspects, (Functions.Function1)new Functions.Function1<Aspect, Boolean>(){

            public Boolean apply(Aspect c) {
                return c instanceof ViewpointActivityExplorer;
            }
        })) != null) {
            output.put(3, this.backwardSynchronize((ViewpointActivityExplorer)aspect, this.loadViewpointActivityExplorerResource((EObject)aspect, resourceSet)));
        }
        if ((filter = IterableExtensions.filter((Iterable)aspects, (Functions.Function1)new Functions.Function1<Aspect, Boolean>(){

            public Boolean apply(Aspect c) {
                return c instanceof RuleSet || c instanceof PropertySet || c instanceof ServiceSet;
            }
        })).iterator().hasNext()) {
            output.put(4, this.assembleServices(filter, this.loadServicesResource((EObject)filter.iterator().next(), resourceSet)));
        }
        if ((aspect = (Aspect)IterableExtensions.findFirst((Iterable)aspects, (Functions.Function1)new Functions.Function1<Aspect, Boolean>(){

            public Boolean apply(Aspect c) {
                return c instanceof Build;
            }
        })) != null) {
            output.put(5, this.backwardSynchronize((Build)aspect, this.loadBuildResource((EObject)aspect, resourceSet)));
        }
        return this.assembleViewpoint(viewpoint, output);
    }

    @Override
    public abstract EObject backwardSynchronize(UIDescription var1, Resource var2);

    @Override
    public abstract EObject backwardSynchronize(Data var1, Resource var2);

    @Override
    public abstract EObject backwardSynchronize(Configuration var1, Resource var2);

    @Override
    public abstract EObject backwardSynchronize(DiagramSet var1, Resource var2);

    @Override
    public abstract EObject backwardSynchronize(Build var1, Resource var2);

    @Override
    public abstract EObject backwardSynchronize(ViewpointActivityExplorer var1, Resource var2);

    public void doGenerate(Resource input, IFileSystemAccess fsa) {
    }

    protected EObject backwardSynchronize(EObject inputAspect, Resource resource) {
        XtextResource textResource = (XtextResource)resource;
        String newContent = null;
        EObject clone = (EObject)this.copier.get((Object)inputAspect);
        if (textResource.getContents().isEmpty()) {
            textResource.getContents().add((Object)clone);
        } else {
            EObject oldRoot = (EObject)textResource.getContents().get(0);
            EcoreUtil2.replace((EObject)oldRoot, (EObject)clone);
        }
        ReferenceUtil.recoverReferences(inputAspect, this.copier);
        String serializationContent = textResource.getSerializer().serialize(clone);
        newContent = String.valueOf(this.appendCopyRightHeader(clone, CoreModelHelper.getViewpointShortName((Object)inputAspect))) + serializationContent;
        if (this.saveNewResource(textResource, newContent)) {
            return (EObject)textResource.getContents().get(0);
        }
        return null;
    }

    protected EObject assembleServices(Iterable<Aspect> inputAspects, Resource resource) {
        XtextResource textResource = (XtextResource)resource;
        ArrayList<Aspect> aspects = new ArrayList<Aspect>();
        Object function = new Functions.Function1<Aspect, Boolean>(){

            public Boolean apply(Aspect c) {
                return c instanceof RuleSet;
            }
        };
        aspects.add((Aspect)IterableExtensions.findFirst(inputAspects, (Functions.Function1)function));
        function = new Functions.Function1<Aspect, Boolean>(){

            public Boolean apply(Aspect c) {
                return c instanceof PropertySet;
            }
        };
        aspects.add((Aspect)IterableExtensions.findFirst(inputAspects, (Functions.Function1)function));
        function = new Functions.Function1<Aspect, Boolean>(){

            public Boolean apply(Aspect c) {
                return c instanceof ServiceSet;
            }
        };
        aspects.add((Aspect)IterableExtensions.findFirst(inputAspects, (Functions.Function1)function));
        EObject service = this.backwardSynchronize(aspects, (Resource)textResource);
        return service;
    }

    protected org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.vpspec.Viewpoint assembleViewpoint(org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.vpspec.Viewpoint viewpoint, Map<Integer, EObject> output) {
        IResourceServiceProvider resourceServiceProvider = ((XtextResource)viewpoint.eResource()).getResourceServiceProvider();
        VpspecGrammarAccess grammar = (VpspecGrammarAccess)resourceServiceProvider.get(IGrammarAccess.class);
        viewpoint.getVP_Aspects().clear();
        viewpoint.getType().clear();
        for (Integer key : output.keySet()) {
            if (output.get(key) instanceof DataSpec) {
                viewpoint.setVP_Data(((DataSpec)output.get(key)).getData());
            }
            if (output.get(key) instanceof UserInterface) {
                viewpoint.getVP_Aspects().add((Object)((UserInterface)output.get(key)).getUiDescription());
                viewpoint.getType().add((Object)grammar.getViewpointAccess().getTypeUIKeyword_14_0_0().getValue());
            }
            if (!(output.get(key) instanceof Diagrams)) continue;
            viewpoint.getVP_Aspects().add((Object)((Diagrams)output.get(key)).getDiagrams());
            viewpoint.getType().add((Object)grammar.getViewpointAccess().getTypeDiagramsKeyword_15_0_0().getValue());
        }
        return viewpoint;
    }

    protected Resource loadPrimaryResource(EObject inputObject, ResourceSet resourceSet) {
        String projectName = EcoreUtil.getURI((EObject)inputObject).segment(1);
        URI uri = ResourceHelper.getPrimaryResourceURI((String)projectName);
        if (uri == null) {
            Resource resource = ResourceHelper.createResource((URI)GeneratorsUtil.computeURI(inputObject, "spec.vptext", null), (ResourceSet)resourceSet);
            PluginUtil.addModelReuseExtension((String)projectName, (EObject)inputObject, (URI)resource.getURI());
            return resource;
        }
        List primaryObjects = ResourceHelper.loadPrimaryResource((URI)uri, (ResourceSet)resourceSet);
        if (primaryObjects != null && !primaryObjects.isEmpty() && primaryObjects.get(0) != null) {
            return ((EObject)primaryObjects.get(0)).eResource();
        }
        return resourceSet.getResource(uri, false);
    }

    protected Resource loadDataResource(EObject inputObject, ResourceSet resourceSet) {
        String projectName = EcoreUtil.getURI((EObject)inputObject).segment(1);
        List uris = ResourceHelper.getSecondaryResourceURIsByExtension((String)"data.vptext", (String)projectName);
        if (uris.isEmpty()) {
            Resource resource = ResourceHelper.createResource((URI)GeneratorsUtil.computeURI(inputObject, "data.vptext", null), (ResourceSet)resourceSet);
            ResourceHelper.loadExternalLibrary((ResourceSet)resourceSet);
            PluginUtil.addModelReuseExtension((String)projectName, (EObject)inputObject, (URI)resource.getURI());
            return resource;
        }
        List dataResource = ResourceHelper.loadDataResource((URI)((URI)uris.get(0)), (ResourceSet)resourceSet);
        for (EObject object : dataResource) {
            if (object.eResource() == null) continue;
            return object.eResource();
        }
        return ResourceHelper.loadResource((URI)((URI)uris.get(0)), (ResourceSet)resourceSet);
    }

    protected Resource loadConfigurationResource(EObject inputObject, ResourceSet resourceSet) {
        String projectName = EcoreUtil.getURI((EObject)inputObject).segment(1);
        List uris = ResourceHelper.getSecondaryResourceURIsByExtension((String)"conf.vptext", (String)projectName);
        if (uris.isEmpty()) {
            Resource resource = ResourceHelper.createResource((URI)GeneratorsUtil.computeURI(inputObject, "conf.vptext", null), (ResourceSet)resourceSet);
            PluginUtil.addModelReuseExtension((String)projectName, (EObject)inputObject, (URI)resource.getURI());
            return resource;
        }
        List configObjects = ResourceHelper.loadConfigurationResource((URI)((URI)uris.get(0)), (ResourceSet)resourceSet);
        if (configObjects != null && !configObjects.isEmpty() && configObjects.get(0) != null) {
            return ((EObject)configObjects.get(0)).eResource();
        }
        return ResourceHelper.loadResource((URI)((URI)uris.get(0)), (ResourceSet)resourceSet);
    }

    protected Resource loadBuildResource(EObject inputObject, ResourceSet resourceSet) {
        String projectName = EcoreUtil.getURI((EObject)inputObject).segment(1);
        List uris = ResourceHelper.getSecondaryResourceURIsByExtension((String)"build.vptext", (String)projectName);
        if (uris.isEmpty()) {
            Resource resource = ResourceHelper.createResource((URI)GeneratorsUtil.computeURI(inputObject, "build.vptext", null), (ResourceSet)resourceSet);
            PluginUtil.addModelReuseExtension((String)projectName, (EObject)inputObject, (URI)resource.getURI());
            return resource;
        }
        List buildObjects = ResourceHelper.loadBuildResource((URI)((URI)uris.get(0)), (ResourceSet)resourceSet);
        if (buildObjects != null && !buildObjects.isEmpty() && buildObjects.get(0) != null) {
            return ((EObject)buildObjects.get(0)).eResource();
        }
        return ResourceHelper.loadResource((URI)((URI)uris.get(0)), (ResourceSet)resourceSet);
    }

    protected Resource loadDiagramResource(EObject inputObject, ResourceSet resourceSet) {
        String projectName = EcoreUtil.getURI((EObject)inputObject).segment(1);
        List uris = ResourceHelper.getSecondaryResourceURIsByExtension((String)"diagram.vptext", (String)projectName);
        if (uris.isEmpty()) {
            Resource resource = ResourceHelper.createResource((URI)GeneratorsUtil.computeURI(inputObject, "diagram.vptext", null), (ResourceSet)resourceSet);
            PluginUtil.addModelReuseExtension((String)projectName, (EObject)inputObject, (URI)resource.getURI());
            return resource;
        }
        List diagramResource = ResourceHelper.loadDiagramResource((URI)((URI)uris.get(0)), (ResourceSet)resourceSet);
        for (EObject object : diagramResource) {
            if (object.eResource() == null) continue;
            return object.eResource();
        }
        return ResourceHelper.loadResource((URI)((URI)uris.get(0)), (ResourceSet)resourceSet);
    }

    protected Resource loadUIResource(EObject inputObject, ResourceSet resourceSet) {
        String projectName = EcoreUtil.getURI((EObject)inputObject).segment(1);
        List uris = ResourceHelper.getSecondaryResourceURIsByExtension((String)"ui.vptext", (String)projectName);
        if (uris.isEmpty()) {
            Resource resource = ResourceHelper.createResource((URI)GeneratorsUtil.computeURI(inputObject, "ui.vptext", null), (ResourceSet)resourceSet);
            PluginUtil.addModelReuseExtension((String)projectName, (EObject)inputObject, (URI)resource.getURI());
            return resource;
        }
        List uiResource = ResourceHelper.loadUIResource((URI)((URI)uris.get(0)), (ResourceSet)resourceSet);
        for (EObject object : uiResource) {
            if (object.eResource() == null) continue;
            return object.eResource();
        }
        return ResourceHelper.loadResource((URI)((URI)uris.get(0)), (ResourceSet)resourceSet);
    }

    protected Resource loadServicesResource(EObject inputObject, ResourceSet resourceSet) {
        String projectName = EcoreUtil.getURI((EObject)inputObject).segment(1);
        List uris = ResourceHelper.getSecondaryResourceURIsByExtension((String)"services.vptext", (String)projectName);
        if (uris.isEmpty()) {
            Resource resource = ResourceHelper.createResource((URI)GeneratorsUtil.computeURI(inputObject, "services.vptext", null), (ResourceSet)resourceSet);
            PluginUtil.addModelReuseExtension((String)projectName, (EObject)inputObject, (URI)resource.getURI());
            return resource;
        }
        List serviceResource = ResourceHelper.loadServicesResource((URI)((URI)uris.get(0)), (ResourceSet)resourceSet);
        for (EObject object : serviceResource) {
            if (object.eResource() == null) continue;
            return object.eResource();
        }
        return ResourceHelper.loadResource((URI)((URI)uris.get(0)), (ResourceSet)resourceSet);
    }

    protected Resource loadViewpointActivityExplorerResource(EObject inputObject, ResourceSet resourceSet) {
        String projectName = EcoreUtil.getURI((EObject)inputObject).segment(1);
        List uris = ResourceHelper.getSecondaryResourceURIsByExtension((String)"activityexplorer.vptext", (String)projectName);
        if (uris.isEmpty()) {
            Resource resource = ResourceHelper.createResource((URI)GeneratorsUtil.computeURI(inputObject, "activityexplorer.vptext", null), (ResourceSet)resourceSet);
            PluginUtil.addModelReuseExtension((String)projectName, (EObject)inputObject, (URI)resource.getURI());
            return resource;
        }
        List activityExplorerContent = ResourceHelper.loadActivityexplorerResource((URI)((URI)uris.get(0)), (ResourceSet)resourceSet);
        for (EObject eObject : activityExplorerContent) {
            if (eObject.eResource() == null) continue;
            return eObject.eResource();
        }
        return ResourceHelper.loadResource((URI)((URI)uris.get(0)), (ResourceSet)resourceSet);
    }

    protected EObject loadInputModel(IFile file, ResourceSet resourceSet) {
        IPath emfResourcePath = file.getFullPath();
        URI emfUri = ResourceHelper.URIFix.createPlatformResourceURI((String)emfResourcePath.toString(), (boolean)true);
        return this.loadInputModel(emfUri, resourceSet);
    }

    protected EObject loadInputModel(URI emfUri, ResourceSet resourceSet) {
        Resource emfResource = resourceSet.getResource(emfUri, true);
        EObject modelRoot = (EObject)emfResource.getContents().get(0);
        if (modelRoot != null) {
            EcoreUtil.resolveAll((EObject)modelRoot);
        }
        return modelRoot;
    }

    protected boolean saveNewResource(XtextResource textResource, String content) {
        try {
            textResource.reparse(content);
            HashMap<String, String> saveOptions = new HashMap<String, String>();
            saveOptions.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
            textResource.save(saveOptions);
            IFile file = this.getWorkspaceRoot().getFile((IPath)new Path(textResource.getURI().toPlatformString(true)));
            if (file != null) {
                IDE.setDefaultEditor((IFile)file, (String)EditorIDs.getEditorID((String)ResourceHelper.getFileExtension((IFile)file)));
            }
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    protected String appendCopyRightHeader(EObject modelRoot, String shortName) {
        ICompositeNode node = NodeModelUtils.getNode((EObject)modelRoot);
        if (node != null) {
            ICompositeNode rootNode = node.getRootNode();
            Iterable leafNodes = rootNode.getLeafNodes();
            for (ILeafNode l : leafNodes) {
                if (!this.isCommentNode((INode)l)) continue;
                return "";
            }
        }
        return this.getHeaderComment(shortName);
    }

    protected boolean isCommentNode(INode node) {
        if (node instanceof ILeafNode && ((ILeafNode)node).isHidden() && node.getGrammarElement() instanceof AbstractRule) {
            return this.isComment((AbstractRule)node.getGrammarElement());
        }
        return false;
    }

    protected boolean isComment(AbstractRule rule) {
        return rule != null && ("ML_COMMENT".equals(rule.getName()) || "SL_COMMENT".equals(rule.getName()));
    }

    protected void removeUnmanagedTransientValues(EObject modelRoot) {
        if (modelRoot instanceof ViewpointElement) {
            ((ViewpointElement)modelRoot).setId(null);
            TreeIterator allContents = EcoreUtil2.getAllContents((EObject)modelRoot, (boolean)true);
            while (allContents.hasNext()) {
                EObject objectToChange = (EObject)allContents.next();
                if (objectToChange instanceof ViewpointElement) {
                    ((ViewpointElement)objectToChange).setId(null);
                }
                if (objectToChange instanceof Rule) {
                    ((Rule)objectToChange).eUnset(objectToChange.eClass().getEStructuralFeature(3));
                }
                if (!(objectToChange instanceof Service)) continue;
                ((Service)objectToChange).eUnset(objectToChange.eClass().getEStructuralFeature(3));
            }
        }
    }

    protected boolean validateObject(EObject object, XtextResource hostingResource) {
        this.removeUnmanagedTransientValues(object);
        ArrayList diagnostics = new ArrayList();
        IConcreteSyntaxValidator concreteSyntaxValidator = hostingResource.getConcreteSyntaxValidator();
        concreteSyntaxValidator.validateRecursive(object, (IConcreteSyntaxValidator.IDiagnosticAcceptor)new IConcreteSyntaxValidator.DiagnosticListAcceptor(diagnostics), new HashMap());
        return diagnostics.isEmpty();
    }

    protected String getHeaderComment(String shortName) {
        String fileHeader = "/**\n * Copyright (c) PolarSys, " + GeneratorsUtil.getCurrentYear() + ". All rights reserved. \n" + " *\n" + " *\tViewpoint " + shortName + "\n" + " *\t@author: " + GeneratorsUtil.getCurrentUserName() + "\n" + " *\t@date: " + GeneratorsUtil.getCurrentDate() + "\n" + " *\n" + " */\n";
        return fileHeader;
    }

    protected IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }
}

