/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.ui.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.polarsys.kitalpha.ad.common.AD_Log;
import org.polarsys.kitalpha.ad.viewpoint.ui.Messages;
import org.polarsys.kitalpha.resourcereuse.helper.ResourceReuse;
import org.polarsys.kitalpha.resourcereuse.model.Resource;
import org.polarsys.kitalpha.resourcereuse.model.SearchCriteria;

public class LoadViewpointModelDialog
extends TitleAreaDialog {
    private ListViewer viewer;
    private List<Resource> result = new ArrayList<Resource>();
    private final IProject project;
    private final String excludedPath;
    private final SearchCriteria criteria;

    public LoadViewpointModelDialog(Shell parentShell, IProject project, String excludedPath) {
        this(parentShell, project, excludedPath, LoadViewpointModelDialog.createDefaultCriteria());
    }

    public LoadViewpointModelDialog(Shell parentShell, IProject project, String excludedPath, SearchCriteria criteria) {
        super(parentShell);
        this.project = project;
        this.excludedPath = excludedPath;
        this.criteria = criteria;
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        this.initializeDialogUnits((Control)parentComposite);
        Composite contents = this.createComposite(parentComposite);
        this.createWidgets(contents);
        this.init();
        Dialog.applyDialogFont((Control)parentComposite);
        return contents;
    }

    public void init() {
        HashSet<String> bundleScope = null;
        if (this.project != null) {
            bundleScope = new HashSet<String>();
            IPluginModelBase model = PluginRegistry.findModel((IProject)this.project);
            if (model == null) {
                this.setErrorMessage(Messages.LoadModelDialog_error1);
                return;
            }
            this.fillScope(model, bundleScope);
        }
        Resource[] resources = ResourceReuse.createHelper().getResources(this.criteria);
        this.viewer.setInput(this.filter(resources, bundleScope));
    }

    protected static SearchCriteria createDefaultCriteria() {
        SearchCriteria searchCriteria = new SearchCriteria();
        searchCriteria.setDomain("AF");
        searchCriteria.getTags().add("vp");
        return searchCriteria;
    }

    private void fillScope(IPluginModelBase model, Set<String> bundleScope) {
        BundleDescription description = model.getBundleDescription();
        String symbolicName = description.getSymbolicName();
        if (bundleScope.contains(symbolicName)) {
            return;
        }
        bundleScope.add(symbolicName);
        BundleSpecification[] bundleSpecificationArray = description.getRequiredBundles();
        int n = bundleSpecificationArray.length;
        int n2 = 0;
        while (n2 < n) {
            BundleSpecification req = bundleSpecificationArray[n2];
            if (req.getSupplier() == null) {
                AD_Log.getDefault().logWarning(NLS.bind((String)Messages.LoadModelDialog_error2, (Object)req.hashCode()));
            } else {
                IPluginModelBase reqModel = PluginRegistry.findModel((BundleDescription)req.getSupplier().getSupplier());
                symbolicName = reqModel.getBundleDescription().getSymbolicName();
                this.fillScope(reqModel, bundleScope);
            }
            ++n2;
        }
    }

    private Collection<Resource> filter(Resource[] resources, Set<String> bundleScope) {
        if (bundleScope == null) {
            return Arrays.asList(resources);
        }
        HashMap<String, Resource> res = new HashMap<String, Resource>();
        Resource[] resourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            Resource resource = resourceArray[n2];
            if (!res.containsKey(resource.getPath()) && bundleScope.contains(resource.getProviderSymbolicName()) && !resource.getPath().contains(this.excludedPath)) {
                res.put(resource.getPath(), resource);
            }
            ++n2;
        }
        return res.values();
    }

    private void createWidgets(Composite parent) {
        this.viewer = new ListViewer(parent);
        this.viewer.getList().setLayoutData((Object)new GridData(1808));
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                LoadViewpointModelDialog.this.getButton(0).setEnabled(!event.getSelection().isEmpty());
            }
        });
        this.viewer.setSorter(new ViewerSorter());
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                LoadViewpointModelDialog.this.okPressed();
            }
        });
        this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Collection) {
                    return ((Collection)inputElement).toArray();
                }
                return new Object[0];
            }
        });
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                Resource vp = (Resource)element;
                return String.valueOf(vp.getName()) + "  [" + vp.getProviderSymbolicName() + "]";
            }
        });
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, Messages.Dialog_Add_label, true).setEnabled(false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    private Composite createComposite(Composite parentComposite) {
        Composite contents = new Composite(parentComposite, 0);
        contents.setLayout((Layout)new GridLayout(1, false));
        contents.setLayoutData((Object)new GridData(1808));
        this.setTitle(Messages.LoadAFModelDialog_title);
        this.setMessage(Messages.LoadAFModelDialog_description);
        return contents;
    }

    protected void okPressed() {
        IStructuredSelection ss = (IStructuredSelection)this.viewer.getSelection();
        Object[] objectArray = ss.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            this.result.add((Resource)obj);
            ++n2;
        }
        super.okPressed();
    }

    public List<Resource> getResult() {
        return this.result;
    }
}

