/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.ui.views;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;
import org.polarsys.kitalpha.ad.common.AD_Log;
import org.polarsys.kitalpha.ad.services.manager.ViewpointActivationException;
import org.polarsys.kitalpha.ad.services.manager.ViewpointManager;
import org.polarsys.kitalpha.ad.viewpoint.ui.Activator;
import org.polarsys.kitalpha.ad.viewpoint.ui.views.OpenViewAction;
import org.polarsys.kitalpha.ad.viewpoint.ui.views.SelectionListener2;
import org.polarsys.kitalpha.ad.viewpoint.ui.views.ViewpointManagerContentProvider;
import org.polarsys.kitalpha.ad.viewpoint.ui.views.ViewpointManagerLabelProvider;
import org.polarsys.kitalpha.resourcereuse.model.Resource;

public class ViewpointManagerView
extends ViewPart {
    private TableViewer viewer;
    private Action startAction;
    private Action stopAction;
    private Action refreshAction;
    private OpenViewAction openViewAction;
    private ViewpointManager.OverallListener vpListener = new ViewpointManager.OverallListener(){

        public void hasBeenDeactivated(Object ctx, Resource vp) {
            ViewpointManagerView.this.performInit();
        }

        public void hasBeenActivated(Object ctx, Resource vp) {
            ViewpointManagerView.this.performInit();
        }

        public void hasBeenFiltered(Object ctx, Resource vp) {
            ViewpointManagerView.this.performInit();
        }

        public void hasBeenDisplayed(Object ctx, Resource vp) {
            ViewpointManagerView.this.performInit();
        }
    };
    private final IResourceChangeListener wsListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            IResource resource = event.getResource();
            int type = event.getType();
            if ((type == 4 || type == 2) && resource instanceof IProject) {
                ViewpointManagerView.this.performInit();
            } else if (type == 1) {
                IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren();
                int n = iResourceDeltaArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResourceDelta childDelta = iResourceDeltaArray[n2];
                    resource = childDelta.getResource();
                    if (resource instanceof IProject) {
                        ViewpointManagerView.this.performInit();
                        break;
                    }
                    ++n2;
                }
            }
        }
    };

    public void createPartControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout clayout = new GridLayout();
        clayout.numColumns = 3;
        composite.setLayout((Layout)clayout);
        this.createViewer(composite);
        this.init();
        ViewpointManager.addOverallListener((ViewpointManager.OverallListener)this.vpListener);
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.wsListener);
    }

    public void createViewer(Composite composite) {
        this.viewer = new TableViewer(composite, 68356);
        this.viewer.getControl().setFont(composite.getFont());
        TableViewerSorter comparator = new TableViewerSorter();
        this.viewer.setComparator((ViewerComparator)comparator);
        GridData data = new GridData(1808);
        data.horizontalSpan = 2;
        this.viewer.getControl().setLayoutData((Object)data);
        Table table = this.viewer.getTable();
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        table.setHeaderVisible(true);
        table.setLayoutData((Object)new GridData(1808));
        TableViewerColumn nameColumn = new TableViewerColumn(this.viewer, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(4, 100, true));
        nameColumn.getColumn().setText("Name");
        nameColumn.getColumn().setResizable(true);
        TableViewerColumn stateColumn = new TableViewerColumn(this.viewer, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(2, 50, true));
        stateColumn.getColumn().setText("State");
        stateColumn.getColumn().setResizable(true);
        TableViewerColumn locationColumn = new TableViewerColumn(this.viewer, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(3, 75, true));
        locationColumn.getColumn().setText("Location");
        locationColumn.getColumn().setResizable(true);
        TableViewerColumn providerColumn = new TableViewerColumn(this.viewer, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(5, 150, true));
        providerColumn.getColumn().setText("Provider");
        providerColumn.getColumn().setResizable(true);
        int i = 0;
        while (i < table.getColumnCount()) {
            TableColumn col = table.getColumn(i);
            col.addSelectionListener((SelectionListener)new HeaderSelectionListener(comparator, i));
            ++i;
        }
        table.setSortColumn(nameColumn.getColumn());
        table.setSortDirection(1024);
        this.viewer.setContentProvider((IContentProvider)new ViewpointManagerContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewpointManagerLabelProvider());
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ViewpointManagerView.this.updateButtons((IStructuredSelection)event.getSelection());
            }
        });
    }

    private void performInit() {
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ViewpointManagerView.this.init();
            }
        });
    }

    private void init() {
        this.viewer.setInput((Object)ViewpointManager.getAvailableViewpoints());
        this.updateButtons(null);
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ViewpointManagerView.this.startAction.run();
            }
        });
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ViewpointManagerView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.startAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.stopAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.openViewAction);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.startAction);
        manager.add((IAction)this.stopAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.openViewAction);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.refreshAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.startAction);
        manager.add((IAction)this.stopAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.openViewAction);
    }

    protected void updateButtons(IStructuredSelection selection) {
        int size;
        int n = size = selection == null ? 0 : selection.size();
        if (size == 1) {
            Resource res = (Resource)selection.getFirstElement();
            boolean active = ViewpointManager.getInstance(null).isUsed(res.getId());
            this.startAction.setEnabled(!active);
            this.stopAction.setEnabled(active);
            this.openViewAction.setEnabled(active);
            this.openViewAction.setResource(res);
        } else {
            this.startAction.setEnabled(false);
            this.stopAction.setEnabled(false);
            this.openViewAction.setEnabled(false);
            this.openViewAction.setResource(null);
        }
    }

    private void makeActions() {
        this.startAction = new Action(){

            public void run() {
                IStructuredSelection ss = (IStructuredSelection)ViewpointManagerView.this.viewer.getSelection();
                int size = ss.size();
                if (size != 1) {
                    return;
                }
                Resource res = (Resource)ss.getFirstElement();
                if (ViewpointManager.getInstance(null).isActive(res.getId())) {
                    return;
                }
                try {
                    ViewpointManager.getInstance(null).activate(res.getId());
                }
                catch (ViewpointActivationException e) {
                    MessageDialog.openError((Shell)ViewpointManagerView.this.getSite().getShell(), (String)"Error", (String)e.getMessage());
                    AD_Log.getDefault().logError((Throwable)e);
                }
            }
        };
        this.startAction.setText("Start");
        this.startAction.setToolTipText("Start the viewpoint");
        this.startAction.setImageDescriptor(Activator.getDefault().getImageDescriptor("icons/start.gif"));
        this.stopAction = new Action(){

            public void run() {
                IStructuredSelection ss = (IStructuredSelection)ViewpointManagerView.this.viewer.getSelection();
                int size = ss.size();
                if (size != 1) {
                    return;
                }
                Resource res = (Resource)ss.getFirstElement();
                if (!ViewpointManager.getInstance(null).isActive(res.getId())) {
                    return;
                }
                try {
                    ViewpointManager.getInstance(null).desactivate(res.getId());
                }
                catch (ViewpointActivationException e) {
                    MessageDialog.openError((Shell)ViewpointManagerView.this.getSite().getShell(), (String)"Error", (String)e.getMessage());
                    Activator.getDefault().logError(e);
                }
            }
        };
        this.stopAction.setText("Stop");
        this.stopAction.setToolTipText("Stop the viewpoint");
        this.stopAction.setImageDescriptor(Activator.getDefault().getImageDescriptor("icons/stop.gif"));
        this.refreshAction = new Action(){

            public void run() {
                ViewpointManagerView.this.init();
            }
        };
        this.refreshAction.setText("Refresh");
        this.refreshAction.setToolTipText("Refresh the view");
        this.refreshAction.setImageDescriptor(Activator.getDefault().getImageDescriptor("icons/refresh.gif"));
        this.openViewAction = new OpenViewAction();
        this.openViewAction.setText("Show in view");
        this.openViewAction.setToolTipText("Show the viewpoint view");
        this.openViewAction.setImageDescriptor(Activator.getDefault().getImageDescriptor("icons/VP.gif"));
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void dispose() {
        super.dispose();
        ViewpointManager.removeOverallListener((ViewpointManager.OverallListener)this.vpListener);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.wsListener);
    }

    private final class HeaderSelectionListener
    extends SelectionListener2 {
        private final TableViewerSorter comparator;
        private final int columnIndex;

        private HeaderSelectionListener(TableViewerSorter comparator, int columnIndex) {
            this.comparator = comparator;
            this.columnIndex = columnIndex;
        }

        @Override
        public void widgetSelected(SelectionEvent e) {
            int lastSortColumn = this.comparator.getSortColumn();
            boolean lastAscending = this.comparator.isAscending();
            if (lastSortColumn == this.columnIndex) {
                this.comparator.setAscending(!lastAscending);
            } else {
                this.comparator.setAscending(true);
                this.comparator.setSortColumn(this.columnIndex);
            }
            ViewpointManagerView.this.viewer.refresh();
        }
    }

    private final class TableViewerSorter
    extends ViewerComparator {
        private int sortColumn = 0;
        private boolean ascending = true;

        private TableViewerSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            ITableLabelProvider labelProvider = (ITableLabelProvider)((TableViewer)viewer).getLabelProvider();
            String name1 = labelProvider.getColumnText(e1, this.sortColumn);
            String name2 = labelProvider.getColumnText(e2, this.sortColumn);
            if (this.ascending) {
                return this.getComparator().compare(name1, name2);
            }
            return this.getComparator().compare(name2, name1);
        }

        public int getSortColumn() {
            return this.sortColumn;
        }

        public void setSortColumn(int sortColumn) {
            this.sortColumn = sortColumn;
        }

        public boolean isAscending() {
            return this.ascending;
        }

        public void setAscending(boolean ascending) {
            this.ascending = ascending;
        }
    }
}

