/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.ui.views.tabs.overview;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.polarsys.kitalpha.ad.common.utils.URIFix;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Viewpoint;
import org.polarsys.kitalpha.ad.viewpoint.handlers.IMiscHandler;
import org.polarsys.kitalpha.ad.viewpoint.ui.Activator;
import org.polarsys.kitalpha.ad.viewpoint.ui.Messages;
import org.polarsys.kitalpha.ad.viewpoint.ui.dialogs.LoadViewpointModelDialog;
import org.polarsys.kitalpha.ad.viewpoint.ui.views.tabs.AbstractTab;
import org.polarsys.kitalpha.ad.viewpoint.ui.views.tabs.ResourceTableSorter;
import org.polarsys.kitalpha.ad.viewpoint.ui.views.tabs.overview.ParentsContentProvider;
import org.polarsys.kitalpha.ad.viewpoint.ui.views.tabs.overview.ParentslLabelProvider;
import org.polarsys.kitalpha.resourcereuse.model.Resource;

public class OverviewTab
extends AbstractTab {
    private static final String NAME_COLUMN = "name";
    private TableViewer parentsViewer;
    private Button addBtn;
    private Button deleteBtn;
    private Button abstractButton;
    private Text nameText;
    private Text versionText;
    private Text descriptionText;

    public OverviewTab() {
        super(new ParentslLabelProvider());
    }

    @Override
    public ISelectionProvider getSelectionProvider() {
        return this.parentsViewer;
    }

    @Override
    public void createTab(FormToolkit toolkit, CTabFolder folder) {
        Composite composite = this.createTab(toolkit, folder, Messages.OverviewTab_title, "icons/misc.gif");
        GridLayout clayout = new GridLayout();
        clayout.numColumns = 3;
        composite.setLayout((Layout)clayout);
        this.createLeftControls(toolkit, composite);
        this.createRightControls(toolkit, composite);
    }

    private void createLeftControls(FormToolkit toolkit, Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        GridLayout clayout = new GridLayout();
        composite.setLayout((Layout)clayout);
        composite.setLayoutData((Object)new GridData(1808));
        toolkit.createLabel(composite, Messages.OverviewTab_name_label);
        this.nameText = toolkit.createText(composite, "");
        this.nameText.setLayoutData((Object)new GridData(768));
        this.nameText.addFocusListener((FocusListener)new AbstractTab.FocusListener2(this){

            @Override
            public void doFocusLost(FocusEvent e) {
                IMiscHandler miscHandler = OverviewTab.this.modelManager.getMiscHandler();
                if (miscHandler != null) {
                    miscHandler.setName(OverviewTab.this.nameText.getText());
                }
            }
        });
        toolkit.createLabel(composite, Messages.OverviewTab_version_label);
        this.versionText = toolkit.createText(composite, "");
        this.versionText.setLayoutData((Object)new GridData(768));
        this.versionText.addFocusListener((FocusListener)new AbstractTab.FocusListener2(this){

            @Override
            public void doFocusLost(FocusEvent e) {
                IMiscHandler miscHandler = OverviewTab.this.modelManager.getMiscHandler();
                if (miscHandler != null) {
                    miscHandler.setVersion(OverviewTab.this.versionText.getText());
                }
            }
        });
        toolkit.createLabel(composite, Messages.OverviewTab_description_label);
        this.descriptionText = toolkit.createText(composite, "");
        this.descriptionText.setLayoutData((Object)new GridData(1808));
        this.descriptionText.addFocusListener((FocusListener)new AbstractTab.FocusListener2(this){

            @Override
            public void doFocusLost(FocusEvent e) {
                IMiscHandler miscHandler = OverviewTab.this.modelManager.getMiscHandler();
                if (miscHandler != null) {
                    miscHandler.setDescription(OverviewTab.this.descriptionText.getText());
                }
            }
        });
    }

    public void createRightControls(FormToolkit toolkit, Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        GridLayout clayout = new GridLayout();
        composite.setLayout((Layout)clayout);
        composite.setLayoutData((Object)new GridData(1808));
        this.abstractButton = toolkit.createButton(composite, Messages.OverviewTab_abstract_button_label, 32);
        this.abstractButton.addSelectionListener((SelectionListener)new AbstractTab.SelectionListener2(this){

            @Override
            public void doWidgetSelected(SelectionEvent e) {
                IMiscHandler miscHandler = OverviewTab.this.modelManager.getMiscHandler();
                if (miscHandler != null) {
                    miscHandler.setAbstract(OverviewTab.this.abstractButton.getSelection());
                }
            }
        });
        this.parentsViewer = new TableViewer(composite, 67584);
        final Table table = this.parentsViewer.getTable();
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        table.setHeaderVisible(true);
        table.setLayoutData((Object)new GridData(1808));
        AbstractTab.SelectionListener2 headerListener = new AbstractTab.SelectionListener2(this){

            @Override
            public void doWidgetSelected(SelectionEvent e) {
                TableColumn newSortColumn;
                TableColumn currentSortColumn = table.getSortColumn();
                if (currentSortColumn.equals(newSortColumn = (TableColumn)e.getSource())) {
                    int sortDirection = table.getSortDirection();
                    table.setSortDirection(sortDirection == 128 ? 1024 : 128);
                } else {
                    table.setSortColumn(newSortColumn);
                    table.setSortDirection(1024);
                }
                OverviewTab.this.parentsViewer.refresh();
            }
        };
        TableViewerColumn nameColumn = new TableViewerColumn(this.parentsViewer, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(3, 90, true));
        nameColumn.getColumn().addSelectionListener((SelectionListener)headerListener);
        nameColumn.getColumn().setText(Messages.OverviewTab_parent_label);
        nameColumn.getColumn().setResizable(true);
        nameColumn.getColumn().setData((Object)0);
        table.setSortColumn(nameColumn.getColumn());
        table.setSortDirection(1024);
        this.parentsViewer.setColumnProperties(new String[]{NAME_COLUMN});
        this.parentsViewer.setContentProvider((IContentProvider)ParentsContentProvider.INSTANCE);
        this.parentsViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.parentsViewer.setSorter((ViewerSorter)new ResourceTableSorter());
        Composite btnBar = toolkit.createComposite(parent);
        btnBar.setLayout((Layout)new GridLayout());
        this.addBtn = toolkit.createButton(btnBar, "", 8);
        this.addBtn.setToolTipText(Messages.OverviewTab_add_tooltip);
        this.addBtn.setImage(Activator.getDefault().getImage("icons/add.gif"));
        this.addBtn.addSelectionListener((SelectionListener)new AbstractTab.SelectionListener2(this){

            @Override
            public void doWidgetSelected(SelectionEvent e) {
                IMiscHandler miscHandler = OverviewTab.this.modelManager.getMiscHandler();
                URI uri = OverviewTab.this.viewpoint.eResource().getURI();
                IPath path = new Path(uri.path()).removeFirstSegments(1);
                String segment = uri.segment(1);
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                IProject project = root.getProject(segment);
                LoadViewpointModelDialog loadResourceDialog = new LoadViewpointModelDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), project, path.toPortableString());
                if (loadResourceDialog.open() == 0) {
                    ResourceSet resourceSet = OverviewTab.this.viewpoint.eResource().getResourceSet();
                    ArrayList<Viewpoint> vps = new ArrayList<Viewpoint>();
                    for (Resource res : loadResourceDialog.getResult()) {
                        path = new Path(res.getPath());
                        project = root.getProject(path.segment(0));
                        uri = project.isAccessible() ? URIFix.createPlatformResourceURI((String)res.getPath(), (boolean)false) : URIFix.createPlatformPluginURI((String)res.getPath(), (boolean)false);
                        Viewpoint vp = (Viewpoint)resourceSet.getEObject(uri, true);
                        vps.add(vp);
                    }
                    miscHandler.addParents(vps);
                }
            }
        });
        this.deleteBtn = toolkit.createButton(btnBar, "", 8);
        this.deleteBtn.setToolTipText(Messages.OverviewTab_delete_tooltip);
        this.deleteBtn.setImage(Activator.getDefault().getImage("icons/delete.gif"));
        this.deleteBtn.setEnabled(false);
        this.deleteBtn.addSelectionListener((SelectionListener)new AbstractTab.SelectionListener2(this){

            @Override
            public void doWidgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)OverviewTab.this.parentsViewer.getSelection();
                ArrayList<Viewpoint> vps = new ArrayList<Viewpoint>();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    vps.add((Viewpoint)obj);
                    ++n2;
                }
                IMiscHandler miscHandler = OverviewTab.this.modelManager.getMiscHandler();
                miscHandler.removeParents(vps);
            }
        });
        this.parentsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                OverviewTab.this.updateButtons((IStructuredSelection)event.getSelection());
            }
        });
    }

    @Override
    public void init() {
        this.parentsViewer.setInput((Object)this.viewpoint);
        this.workspaceHasChanged();
    }

    @Override
    public void workspaceHasChanged() {
        super.workspaceHasChanged();
        IMiscHandler miscHandler = this.modelManager.getMiscHandler();
        if (miscHandler == null) {
            this.abstractButton.setSelection(false);
            this.descriptionText.setText("");
            this.nameText.setText("");
            this.versionText.setText("");
        } else {
            this.abstractButton.setSelection(miscHandler.isAbstract());
            this.descriptionText.setText(miscHandler.getDescription() == null ? "" : miscHandler.getDescription());
            this.nameText.setText(miscHandler.getName() == null ? "" : miscHandler.getName());
            this.versionText.setText(miscHandler.getVersion() == null ? "" : miscHandler.getVersion());
        }
        this.parentsViewer.refresh();
        this.updateButtons((IStructuredSelection)this.parentsViewer.getSelection());
    }

    private void updateButtons(IStructuredSelection selection) {
        boolean readOnly = this.getModelManager().getResourceManager().isReadOnly() || this.getModelManager().isLocal();
        this.abstractButton.setEnabled(!readOnly);
        this.descriptionText.setEnabled(!readOnly);
        this.nameText.setEnabled(!readOnly);
        this.versionText.setEnabled(!readOnly);
        this.addBtn.setEnabled(!readOnly);
        this.deleteBtn.setEnabled(!readOnly && !selection.isEmpty());
    }
}

