/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.ui.views.tabs.services;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Rule;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Service;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.edit.provider.ViewpointEditPlugin;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.tools.model.ViewpointElement;
import org.polarsys.kitalpha.ad.viewpoint.handlers.IElementHandler;
import org.polarsys.kitalpha.ad.viewpoint.handlers.ModelListener;
import org.polarsys.kitalpha.ad.viewpoint.handlers.ProjectUtils;
import org.polarsys.kitalpha.ad.viewpoint.integration.services.Implementations;
import org.polarsys.kitalpha.ad.viewpoint.integration.services.ServiceImplementation;
import org.polarsys.kitalpha.ad.viewpoint.ui.Activator;
import org.polarsys.kitalpha.ad.viewpoint.ui.Messages;
import org.polarsys.kitalpha.ad.viewpoint.ui.integration.services.NewServiceCreationWizard;
import org.polarsys.kitalpha.ad.viewpoint.ui.views.editing.ComboStringEditingSupport;
import org.polarsys.kitalpha.ad.viewpoint.ui.views.editing.ServiceTypeEditingSupport;
import org.polarsys.kitalpha.ad.viewpoint.ui.views.editing.StringEditingSupport;
import org.polarsys.kitalpha.ad.viewpoint.ui.views.tabs.AbstractTab;
import org.polarsys.kitalpha.ad.viewpoint.ui.views.tabs.GenericHandlerContentProvider;
import org.polarsys.kitalpha.ad.viewpoint.ui.views.tabs.ResourceTableSorter;
import org.polarsys.kitalpha.ad.viewpoint.ui.views.tabs.services.RelatedRulesEditingSupport;
import org.polarsys.kitalpha.ad.viewpoint.ui.views.tabs.services.ServiceLabelProvider;
import org.polarsys.kitalpha.ad.viewpoint.utils.ElementHelper;
import org.polarsys.kitalpha.ad.viewpoint.utils.ModelAccessor;

public class ServiceTab
extends AbstractTab
implements ModelListener {
    private static final String ID_COLUMN = "id";
    private static final String BTN_COLUMN = "btn";
    private static final String NAME_COLUMN = "name";
    private static final String DESCRIPTION_COLUMN = "description";
    private TableViewer serviceViewer;
    private Button createBtn;
    private Button deleteBtn;
    private Button addBtn;
    private ComboStringEditingSupport idEditingSupport;
    private ServiceTypeEditingSupport typeEditingSupport;
    private RelatedRulesEditingSupport relatedRulesEditingSupport;
    private final ISelectionListener listener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            boolean partVisible = ServiceTab.this.site.getPage().isPartVisible(ServiceTab.this.site.getPart());
            if (partVisible) {
                ServiceTab.this.serviceViewer.refresh();
            }
        }
    };
    private final BundleListener bundleListener = new BundleListener(){

        public void bundleChanged(BundleEvent event) {
            if (Implementations.hasProvider((Bundle)event.getBundle())) {
                this.refresh();
                return;
            }
        }

        private void refresh() {
            if (ServiceTab.this.site != null) {
                ServiceTab.this.site.getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (ServiceTab.this.serviceViewer != null && ServiceTab.this.serviceViewer.getTable() != null && !ServiceTab.this.serviceViewer.getTable().isDisposed()) {
                            ServiceTab.this.serviceViewer.refresh(true);
                        }
                    }
                });
            }
        }
    };

    public ServiceTab() {
        super(new ServiceLabelProvider());
    }

    @Override
    public ISelectionProvider getSelectionProvider() {
        return this.serviceViewer;
    }

    @Override
    public void createTab(FormToolkit toolkit, CTabFolder folder) {
        final Composite composite = this.createTab(toolkit, folder, Messages.ServiceTab_title, ViewpointEditPlugin.INSTANCE.getImage("full/obj16/Service"));
        GridLayout clayout = new GridLayout();
        clayout.numColumns = 2;
        composite.setLayout((Layout)clayout);
        this.serviceViewer = new TableViewer(composite, 67584){

            protected void doUpdateItem(Widget w, Object element, boolean fullMap) {
                boolean enabled;
                super.doUpdateItem(w, element, fullMap);
                final TableItem item = (TableItem)w;
                Table table = this.getTable();
                TableEditor editor = (TableEditor)item.getData("editor");
                Button button = null;
                if (editor == null) {
                    editor = new TableEditor(table);
                    item.setData("editor", (Object)editor);
                    button = new Button((Composite)table, 8);
                    button.setImage(Activator.getDefault().getImage("icons/run.gif"));
                    button.addSelectionListener((SelectionListener)new AbstractTab.SelectionListener2(ServiceTab.this){

                        @Override
                        public void doWidgetSelected(SelectionEvent e) {
                            Service service = (Service)item.getData();
                            try {
                                ServiceImplementation impl = Implementations.getInstance((Service)service);
                                impl.run(service, new ModelAccessor(ServiceTab.this.modelManager), ServiceTab.this.selectionProvider == null ? new Object[]{} : ServiceTab.this.selectionProvider.getSelection().toArray());
                            }
                            catch (CoreException e1) {
                                MessageDialog.openError((Shell)composite.getShell(), (String)"Error", (String)e1.getMessage());
                                Activator.getDefault().logError(e1);
                            }
                        }
                    });
                    button.pack();
                    final TableEditor fEditor = editor;
                    final Button fButton = button;
                    item.addDisposeListener(new DisposeListener(){

                        public void widgetDisposed(DisposeEvent e) {
                            fEditor.dispose();
                            fButton.dispose();
                        }
                    });
                    editor.minimumWidth = button.getSize().x;
                    editor.horizontalAlignment = 16384;
                    editor.setEditor((Control)button, item, 0);
                }
                button = (Button)editor.getEditor();
                Service service = (Service)item.getData();
                boolean bl = enabled = service != null && service.getType() != null && !"".equals(service.getType());
                if (enabled) {
                    try {
                        boolean canRun;
                        ServiceImplementation impl = Implementations.getInstance((Service)service);
                        enabled = canRun = impl != null && impl.canRun(service, new ModelAccessor(ServiceTab.this.modelManager), ServiceTab.this.selectionProvider.getSelection().toArray());
                    }
                    catch (Exception e1) {
                        Activator.getDefault().logError(e1);
                        enabled = false;
                    }
                }
                button.setEnabled(enabled);
            }
        };
        final Table table = this.serviceViewer.getTable();
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        table.setHeaderVisible(true);
        table.setLayoutData((Object)new GridData(1808));
        AbstractTab.SelectionListener2 headerListener = new AbstractTab.SelectionListener2(this){

            @Override
            public void doWidgetSelected(SelectionEvent e) {
                TableColumn newSortColumn;
                TableColumn currentSortColumn = table.getSortColumn();
                if (currentSortColumn.equals(newSortColumn = (TableColumn)e.getSource())) {
                    int sortDirection = table.getSortDirection();
                    table.setSortDirection(sortDirection == 128 ? 1024 : 128);
                } else {
                    table.setSortColumn(newSortColumn);
                    table.setSortDirection(1024);
                }
                ServiceTab.this.serviceViewer.refresh();
            }
        };
        TableViewerColumn activeColumn = new TableViewerColumn(this.serviceViewer, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, 40, false));
        activeColumn.getColumn().addSelectionListener((SelectionListener)headerListener);
        activeColumn.getColumn().setText("");
        activeColumn.getColumn().setResizable(false);
        activeColumn.getColumn().setData((Object)0);
        TableViewerColumn idColumn = new TableViewerColumn(this.serviceViewer, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(3, 50, true));
        idColumn.getColumn().addSelectionListener((SelectionListener)headerListener);
        idColumn.getColumn().setText(Messages.ServiceTab_column_id_label);
        idColumn.getColumn().setResizable(true);
        idColumn.getColumn().setData((Object)1);
        this.idEditingSupport = new ComboStringEditingSupport(this.serviceViewer, Rule.class, ID_COLUMN);
        idColumn.setEditingSupport((EditingSupport)this.register(this.idEditingSupport));
        TableViewerColumn nameColumn = new TableViewerColumn(this.serviceViewer, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(3, 100, true));
        nameColumn.getColumn().addSelectionListener((SelectionListener)headerListener);
        nameColumn.getColumn().setText(Messages.ServiceTab_column_name_label);
        nameColumn.getColumn().setResizable(true);
        nameColumn.getColumn().setData((Object)2);
        nameColumn.setEditingSupport((EditingSupport)this.register(new StringEditingSupport(this.serviceViewer, Service.class, NAME_COLUMN)));
        TableViewerColumn typeColumn = new TableViewerColumn(this.serviceViewer, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(8, 100, true));
        typeColumn.getColumn().addSelectionListener((SelectionListener)headerListener);
        typeColumn.getColumn().setText(Messages.ServiceTab_column_type_label);
        typeColumn.getColumn().setResizable(true);
        typeColumn.getColumn().setData((Object)3);
        this.typeEditingSupport = new ServiceTypeEditingSupport(this.serviceViewer);
        typeColumn.setEditingSupport((EditingSupport)this.register(this.typeEditingSupport));
        TableViewerColumn relatedRulesColumn = new TableViewerColumn(this.serviceViewer, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(8, 100, true));
        relatedRulesColumn.getColumn().addSelectionListener((SelectionListener)headerListener);
        relatedRulesColumn.getColumn().setText(Messages.ServiceTab_column_details_label);
        relatedRulesColumn.getColumn().setResizable(true);
        relatedRulesColumn.getColumn().setData((Object)5);
        this.relatedRulesEditingSupport = new RelatedRulesEditingSupport(this.serviceViewer);
        relatedRulesColumn.setEditingSupport((EditingSupport)this.register(this.relatedRulesEditingSupport));
        TableViewerColumn descColumn = new TableViewerColumn(this.serviceViewer, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(12, 100, true));
        descColumn.getColumn().addSelectionListener((SelectionListener)headerListener);
        descColumn.getColumn().setText(Messages.ServiceTab_column_description_label);
        descColumn.getColumn().setResizable(true);
        descColumn.getColumn().setData((Object)4);
        descColumn.setEditingSupport((EditingSupport)this.register(new StringEditingSupport(this.serviceViewer, Service.class, DESCRIPTION_COLUMN)));
        table.setSortColumn(nameColumn.getColumn());
        table.setSortDirection(1024);
        this.serviceViewer.setColumnProperties(new String[]{BTN_COLUMN, ID_COLUMN, NAME_COLUMN, DESCRIPTION_COLUMN});
        this.serviceViewer.setContentProvider((IContentProvider)GenericHandlerContentProvider.INSTANCE);
        this.serviceViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.serviceViewer.setSorter((ViewerSorter)new ResourceTableSorter());
        Composite btnBar = toolkit.createComposite(composite);
        btnBar.setLayout((Layout)new GridLayout());
        this.createBtn = toolkit.createButton(btnBar, "", 8);
        this.createBtn.setToolTipText(Messages.ServiceTab_create_tooltip);
        this.createBtn.setImage(Activator.getDefault().getImage("icons/NewService.gif"));
        this.createBtn.addSelectionListener((SelectionListener)new AbstractTab.SelectionListener2(this){

            @Override
            public void doWidgetSelected(SelectionEvent e) {
                IProject containingProject = ProjectUtils.getContainingProject((EObject)ServiceTab.this.viewpoint);
                NewServiceCreationWizard wizard = new NewServiceCreationWizard(ServiceTab.this.getModelManager().getServiceHandler());
                wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)new StructuredSelection(new Object[]{containingProject}));
                WizardDialog dialog = new WizardDialog(ServiceTab.this.site.getShell(), (IWizard)wizard);
                dialog.open();
            }
        });
        this.addBtn = toolkit.createButton(btnBar, "", 8);
        this.addBtn.setToolTipText(Messages.ServiceTab_add_tooltip);
        this.addBtn.setImage(Activator.getDefault().getImage("icons/add.gif"));
        this.addBtn.addSelectionListener((SelectionListener)new AbstractTab.SelectionListener2(this){

            @Override
            public void doWidgetSelected(SelectionEvent e) {
                String id = ElementHelper.computeNewId((IElementHandler)ServiceTab.this.modelManager.getServiceHandler(), (String)(String.valueOf(ServiceTab.this.viewpoint.getId()) + ".service"));
                ServiceTab.this.getModelManager().getServiceHandler().createService(id, Messages.ServiceTab_new_service_label, null, new ArrayList());
            }
        });
        this.deleteBtn = toolkit.createButton(btnBar, "", 8);
        this.deleteBtn.setToolTipText(Messages.ServiceTab_delete_tooltip);
        this.deleteBtn.setImage(Activator.getDefault().getImage("icons/delete.gif"));
        this.deleteBtn.setEnabled(false);
        this.deleteBtn.addSelectionListener((SelectionListener)new AbstractTab.SelectionListener2(this){

            @Override
            public void doWidgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ServiceTab.this.serviceViewer.getSelection();
                ArrayList<Service> services = new ArrayList<Service>();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    if (obj instanceof Service) {
                        services.add((Service)obj);
                    }
                    ++n2;
                }
                ServiceTab.this.modelManager.getServiceHandler().removeServices(services);
            }
        });
        this.serviceViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object[] objectArray = ((IStructuredSelection)event.getSelection()).toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    if (!ServiceTab.this.modelManager.getServiceHandler().isRemovable((ViewpointElement)((Service)obj))) {
                        ServiceTab.this.deleteBtn.setEnabled(false);
                        return;
                    }
                    ++n2;
                }
                ServiceTab.this.deleteBtn.setEnabled(!event.getSelection().isEmpty());
            }
        });
        Activator.getDefault().getBundle().getBundleContext().addBundleListener(this.bundleListener);
    }

    @Override
    public void init() {
        this.selectionProvider.addListener(this.listener);
        this.serviceViewer.setInput((Object)this.modelManager.getServiceHandler());
        this.workspaceHasChanged();
    }

    @Override
    public void workspaceHasChanged() {
        super.workspaceHasChanged();
        this.serviceViewer.refresh();
        boolean readOnly = this.getModelManager().getResourceManager().isReadOnly();
        this.deleteBtn.setEnabled(!readOnly && !this.serviceViewer.getSelection().isEmpty());
        this.addBtn.setEnabled(!readOnly);
        this.createBtn.setEnabled(!readOnly);
        List values = ElementHelper.getIdsFromParents((IElementHandler)this.modelManager.getServiceHandler());
        this.idEditingSupport.setItems(values.toArray(new String[values.size()]));
        this.relatedRulesEditingSupport.setRuleHandler(this.getModelManager().getRuleHandler());
    }

    @Override
    public void dispose() {
        if (this.selectionProvider != null) {
            this.selectionProvider.removeListener(this.listener);
        }
        Activator.getDefault().getBundle().getBundleContext().removeBundleListener(this.bundleListener);
        super.dispose();
    }
}

