/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.generation.diagram.javaservice;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.diagram.javaservice.JavaMethodData;

public class JavaServiceData {
    private String PackageName;
    private String ClassName;
    private List<JavaMethodData> Methods = new ArrayList<JavaMethodData>();
    private EObject _context;

    public JavaServiceData(String pack, String clazz) {
        this.PackageName = pack;
        this.ClassName = clazz;
    }

    public JavaServiceData(String name) {
        String[] nameElement = name.split("\\.");
        this.PackageName = nameElement[0];
        this.ClassName = nameElement[nameElement.length - 1];
        int i = 1;
        while (i < nameElement.length - 1) {
            this.PackageName = String.valueOf(this.PackageName) + "." + nameElement[i];
            ++i;
        }
    }

    public List<String> getAllRequiredClassesFQN() {
        ArrayList<String> result = new ArrayList<String>();
        for (JavaMethodData javaMethodData : this.Methods) {
            List<String> requiredClassesFQN = javaMethodData.getRequiredClassesFQN();
            for (String classFQN : requiredClassesFQN) {
                if (result.contains(classFQN)) continue;
                result.add(classFQN);
            }
        }
        return result;
    }

    public void addMethod(JavaMethodData methodData) {
        for (JavaMethodData iJavaMethodData : this.Methods) {
            if (!iJavaMethodData.equals(methodData)) continue;
            return;
        }
        this.Methods.add(methodData);
    }

    public void addMethod(String method_name, JavaMethodData.JavaMethodReturnType method_return_type) {
        JavaMethodData methodData = new JavaMethodData(method_name, method_return_type);
        for (JavaMethodData iJavaMethodData : this.Methods) {
            if (!iJavaMethodData.equals(methodData)) continue;
            return;
        }
        this.Methods.add(methodData);
    }

    public EObject getContext() {
        return this._context;
    }

    public void setContext(EObject context) {
        if (this._context == null || this._context != context) {
            this._context = context;
        }
    }

    public String getPackageName() {
        return this.PackageName;
    }

    public String getClassName() {
        return this.ClassName;
    }

    public List<JavaMethodData> getMethods() {
        return this.Methods;
    }

    public boolean equals(Object arg0) {
        if (arg0 instanceof JavaServiceData) {
            JavaServiceData foreignJavaServiceData = (JavaServiceData)arg0;
            String foreignPackage = foreignJavaServiceData.getPackageName();
            String foreignClass = foreignJavaServiceData.getClassName();
            List<JavaMethodData> foreignMethods = foreignJavaServiceData.getMethods();
            if (this.PackageName != foreignPackage.toLowerCase() || this.ClassName != foreignClass.toLowerCase()) {
                return false;
            }
            if (this.Methods.size() != foreignMethods.size()) {
                return false;
            }
            for (JavaMethodData iMethod : this.Methods) {
                boolean found = false;
                for (JavaMethodData jMethod : foreignMethods) {
                    if (!iMethod.equals(jMethod)) continue;
                    found = true;
                }
                if (found) continue;
                return false;
            }
            return true;
        }
        return super.equals(arg0);
    }
}

