/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.generation.diagram.mappingimport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.ContainerMappingImport;
import org.eclipse.sirius.diagram.description.DescriptionFactory;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.diagram.description.NodeMappingImport;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.diagram.mappingimport.MappingImportData;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.diagram.mappingimport.MappingImportKind;

public class MappingImportAgent {
    private Layer _Layer;
    private List<MappingImportData> _MappingImportList;

    public MappingImportAgent(Layer layer) {
        if (layer == null) {
            throw new IllegalArgumentException("Mapping Import Agent Layer can not be null");
        }
        this._Layer = layer;
        this._MappingImportList = new ArrayList<MappingImportData>();
    }

    public MappingImportAgent(EObject eObject) {
        this(MappingImportAgent.getCorrespondingLayer(eObject));
    }

    public void registerSpecifiedImport(AbstractNodeMapping original, AbstractNodeMapping imported) {
        MappingImportData data = new MappingImportData(original, imported, MappingImportKind.SPECIFIED);
        this.registerImportData(data);
    }

    public void registerAutoImport(AbstractNodeMapping original) {
        MappingImportData data = new MappingImportData(original, null, MappingImportKind.AUTO);
        this.registerImportData(data);
    }

    public Layer get_Layer() {
        return this._Layer;
    }

    public boolean isAgentConcerned(EObject eObject) {
        Layer layer = MappingImportAgent.getCorrespondingLayer(eObject);
        if (layer != null) {
            return layer.equals(this._Layer);
        }
        return false;
    }

    public boolean isImportRegistred(MappingImportData data) {
        boolean result = false;
        for (MappingImportData iMappingImportData : this._MappingImportList) {
            if (!iMappingImportData.equals(data) && !iMappingImportData.original_equals(data)) continue;
            result = true;
            break;
        }
        return result;
    }

    public void patchImports(boolean save) throws Exception {
        for (MappingImportData iMappingImportData : this._MappingImportList) {
            if (iMappingImportData.getParent() != null || !iMappingImportData.getImport_kind().equals((Object)MappingImportKind.AUTO)) continue;
            this.patchAutoImport(iMappingImportData);
        }
        for (MappingImportData iMappingImportData : this._MappingImportList) {
            this.patchMappingReuse(iMappingImportData);
        }
    }

    public void clear() {
        this._MappingImportList.clear();
        this._Layer = null;
    }

    private void patchAutoImport(MappingImportData data) throws Exception {
        this.createImport(data);
        this.addImportToItParent(data);
        for (MappingImportData iMappingImportData : this.lookForChildrenOf(data)) {
            this.patchAutoImport(iMappingImportData);
        }
    }

    private void addImportToItParent(MappingImportData data) throws Exception {
        MappingImportData parent_data = data.getParent();
        AbstractNodeMapping imported_mapping = data.getImported_mapping();
        AbstractNodeMapping original_mapping = data.getOriginal_mapping();
        if (imported_mapping == null) {
            throw new Exception("Import Agent doesn't find a MappingImport");
        }
        if (parent_data == null) {
            if (imported_mapping instanceof NodeMappingImport) {
                this._Layer.getNodeMappings().add((Object)((NodeMappingImport)imported_mapping));
            }
            if (imported_mapping instanceof ContainerMappingImport) {
                this._Layer.getContainerMappings().add((Object)((ContainerMappingImport)imported_mapping));
            }
        } else {
            NodeMapping parent_Node_imported_m;
            ContainerMapping parent_container_imported_m;
            AbstractNodeMapping parent_imported_m = parent_data.getImported_mapping();
            if (imported_mapping instanceof ContainerMapping) {
                parent_container_imported_m = (ContainerMapping)parent_imported_m;
                parent_container_imported_m.getSubContainerMappings().remove((Object)original_mapping);
                parent_container_imported_m.getSubContainerMappings().add((Object)((ContainerMapping)imported_mapping));
            }
            if (parent_imported_m instanceof NodeMapping && (parent_Node_imported_m = (NodeMapping)parent_imported_m).getBorderedNodeMappings().contains((Object)original_mapping)) {
                parent_Node_imported_m.getBorderedNodeMappings().remove((Object)original_mapping);
                parent_Node_imported_m.getBorderedNodeMappings().add((Object)((NodeMapping)imported_mapping));
            }
            if (parent_imported_m instanceof ContainerMapping) {
                parent_container_imported_m = (ContainerMapping)parent_imported_m;
                if (parent_container_imported_m.getSubContainerMappings().contains((Object)original_mapping)) {
                    parent_container_imported_m.getSubContainerMappings().remove((Object)original_mapping);
                    parent_container_imported_m.getSubContainerMappings().add((Object)((ContainerMapping)imported_mapping));
                }
                if (parent_container_imported_m.getSubNodeMappings().contains((Object)original_mapping)) {
                    parent_container_imported_m.getSubNodeMappings().remove((Object)original_mapping);
                    parent_container_imported_m.getSubNodeMappings().add((Object)((NodeMapping)imported_mapping));
                }
                if (parent_container_imported_m.getBorderedNodeMappings().contains((Object)original_mapping)) {
                    parent_container_imported_m.getBorderedNodeMappings().remove((Object)original_mapping);
                    parent_container_imported_m.getBorderedNodeMappings().add((Object)((NodeMapping)imported_mapping));
                }
            }
        }
    }

    private void createImport(MappingImportData data) {
        AbstractNodeMapping original_m = data.getOriginal_mapping();
        AbstractNodeMapping imported_m = data.getImported_mapping();
        if (imported_m == null && original_m != null) {
            ContainerMappingImport mapping_import = null;
            if (original_m instanceof ContainerMapping) {
                ContainerMappingImport container_mapping_import;
                ContainerMapping container_mapping_original = (ContainerMapping)original_m;
                mapping_import = container_mapping_import = DescriptionFactory.eINSTANCE.createContainerMappingImport();
                container_mapping_import.setImportedMapping(container_mapping_original);
            }
            if (original_m instanceof NodeMapping) {
                NodeMapping node_original_m = (NodeMapping)original_m;
                NodeMappingImport node_mapping_import = DescriptionFactory.eINSTANCE.createNodeMappingImport();
                mapping_import = node_mapping_import;
                node_mapping_import.setImportedMapping(node_original_m);
            }
            if (mapping_import != null) {
                mapping_import.setName(String.valueOf(original_m.getName()) + "_Import");
                mapping_import.setLabel(original_m.getLabel() != null ? String.valueOf(original_m.getLabel()) + "_Import" : mapping_import.getName());
                mapping_import.setDomainClass(original_m.getDomainClass());
                mapping_import.setPreconditionExpression(original_m.getPreconditionExpression());
                mapping_import.setSemanticElements(original_m.getSemanticElements());
                MappingImportAgent.reuseTools(original_m, (AbstractNodeMapping)mapping_import);
                MappingImportAgent.reuseMappings(original_m, (AbstractNodeMapping)mapping_import);
            }
            data.setImported_mapping((AbstractNodeMapping)mapping_import);
            data.setGenerated(true);
        }
    }

    public static void reuseMappings(AbstractNodeMapping original_m, AbstractNodeMapping imported_m) {
        imported_m.getReusedBorderedNodeMappings().addAll((Collection)original_m.getAllBorderedNodeMappings());
        if (imported_m instanceof ContainerMappingImport) {
            ContainerMapping original_container_m = (ContainerMapping)original_m;
            ContainerMappingImport container_import = (ContainerMappingImport)imported_m;
            container_import.getReusedNodeMappings().addAll((Collection)original_container_m.getAllNodeMappings());
            container_import.getReusedContainerMappings().addAll((Collection)original_container_m.getAllContainerMappings());
        }
    }

    public static void reuseTools(AbstractNodeMapping original_m, AbstractNodeMapping imported_m) {
        if (original_m != null && imported_m != null) {
            if (imported_m instanceof NodeMappingImport) {
                NodeMappingImport node_mapping_import = (NodeMappingImport)imported_m;
                node_mapping_import.getDropDescriptions().addAll((Collection)((NodeMapping)original_m).getDropDescriptions());
            }
            if (imported_m instanceof ContainerMappingImport) {
                ContainerMappingImport container_mapping_import = (ContainerMappingImport)imported_m;
                container_mapping_import.getDropDescriptions().addAll((Collection)((ContainerMapping)original_m).getDropDescriptions());
            }
            imported_m.getDetailDescriptions().addAll((Collection)original_m.getDetailDescriptions());
            imported_m.setDeletionDescription(original_m.getDeletionDescription());
            imported_m.getPasteDescriptions().addAll((Collection)original_m.getPasteDescriptions());
            imported_m.setDoubleClickDescription(original_m.getDoubleClickDescription());
            imported_m.setLabelDirectEdit(original_m.getLabelDirectEdit());
            imported_m.getNavigationDescriptions().addAll((Collection)original_m.getNavigationDescriptions());
        }
    }

    private List<MappingImportData> lookForChildrenOf(MappingImportData data) {
        ArrayList<MappingImportData> result = new ArrayList<MappingImportData>();
        if (data != null) {
            for (MappingImportData iMappingImportData : this._MappingImportList) {
                if (iMappingImportData.getParent() == null || !iMappingImportData.getParent().equals(data)) continue;
                result.add(iMappingImportData);
            }
        }
        return result;
    }

    private void patchMappingReuse(MappingImportData data_to_reuse) {
        for (MappingImportData iMappingImportData : this._MappingImportList) {
            ContainerMapping reusing_container;
            AbstractNodeMapping reusing_node = iMappingImportData.getImported_mapping();
            AbstractNodeMapping node_to_reuse = data_to_reuse.getImported_mapping();
            if (node_to_reuse instanceof NodeMapping) {
                MappingImportAgent.reuseBorderedNode(reusing_node, data_to_reuse);
                if (!(reusing_node instanceof ContainerMapping)) continue;
                reusing_container = (ContainerMapping)reusing_node;
                MappingImportAgent.reuseNode(reusing_container, data_to_reuse);
                continue;
            }
            if (!(node_to_reuse instanceof ContainerMapping) || !(reusing_node instanceof ContainerMapping)) continue;
            reusing_container = (ContainerMapping)reusing_node;
            MappingImportAgent.reuseContainer(reusing_container, data_to_reuse);
        }
    }

    public static void reuseBorderedNode(AbstractNodeMapping reusing, MappingImportData data_to_reuse) {
        boolean reused = false;
        NodeMapping reused_Node_Mapping = null;
        for (NodeMapping iBorderedNode : reusing.getReusedBorderedNodeMappings()) {
            if (!iBorderedNode.equals(data_to_reuse.getOriginal_mapping())) continue;
            reused_Node_Mapping = iBorderedNode;
            reused = true;
            break;
        }
        if (reused) {
            reusing.getReusedBorderedNodeMappings().remove(reused_Node_Mapping);
            reusing.getReusedBorderedNodeMappings().add((Object)((NodeMapping)data_to_reuse.getImported_mapping()));
        }
    }

    public static void reuseNode(ContainerMapping reusing, MappingImportData data_to_reuse) {
        boolean reused = false;
        NodeMapping reused_Node_Mapping = null;
        for (NodeMapping iNode : reusing.getReusedNodeMappings()) {
            if (!iNode.equals(data_to_reuse.getOriginal_mapping())) continue;
            reused_Node_Mapping = iNode;
            reused = true;
            break;
        }
        if (reused) {
            reusing.getReusedNodeMappings().remove(reused_Node_Mapping);
            reusing.getReusedNodeMappings().add((Object)((NodeMapping)data_to_reuse.getImported_mapping()));
        }
    }

    public static void reuseContainer(ContainerMapping reusing, MappingImportData data_to_reuse) {
        boolean reused = false;
        ContainerMapping reused_Container_Mapping = null;
        for (ContainerMapping iContainer : reusing.getReusedContainerMappings()) {
            if (!iContainer.equals(data_to_reuse.getOriginal_mapping())) continue;
            reused_Container_Mapping = iContainer;
            reused = true;
            break;
        }
        if (reused) {
            reusing.getReusedContainerMappings().remove(reused_Container_Mapping);
            reusing.getReusedContainerMappings().add((Object)((ContainerMapping)data_to_reuse.getImported_mapping()));
        }
    }

    private void registerImportData(MappingImportData data) {
        if (!this.isImportRegistred(data)) {
            this._MappingImportList.add(data);
            this.computeAutoImport(data);
        } else {
            for (MappingImportData iMappingImportData : this._MappingImportList) {
                if (!iMappingImportData.equals(data) && !iMappingImportData.original_equals(data) || !iMappingImportData.getImport_kind().equals((Object)MappingImportKind.AUTO)) continue;
                iMappingImportData.setGenerated(true);
                iMappingImportData.setImport_kind(data.getImport_kind());
                iMappingImportData.setImported_mapping(data.getImported_mapping());
                iMappingImportData.setParent(data.getParent());
            }
        }
    }

    private void computeAutoImport(MappingImportData current_data) {
        AbstractNodeMapping original_m = current_data.getOriginal_mapping();
        if (!(original_m.eContainer() instanceof Layer)) {
            MappingImportData parrent_data = this.createOrGetParentDataOf(current_data);
            if (!this.isImportRegistred(parrent_data)) {
                this.registerImportData(parrent_data);
            }
            if (current_data.getParent() == null && current_data.getImport_kind().equals((Object)MappingImportKind.AUTO)) {
                current_data.setParent(parrent_data);
            }
        }
        Layer original_layer = MappingImportAgent.getCorrespondingLayer((EObject)original_m);
        if (original_m instanceof NodeMapping) {
            for (ContainerMapping iContainerMapping : original_layer.getContainerMappings()) {
                if (!iContainerMapping.getReusedBorderedNodeMappings().contains((Object)original_m) && !iContainerMapping.getReusedNodeMappings().contains((Object)original_m)) continue;
                this.registerImportData(new MappingImportData((AbstractNodeMapping)iContainerMapping));
            }
            for (NodeMapping iNodeMapping : original_layer.getNodeMappings()) {
                if (!iNodeMapping.getReusedBorderedNodeMappings().contains((Object)original_m) || original_m.equals(iNodeMapping)) continue;
                this.registerImportData(new MappingImportData((AbstractNodeMapping)iNodeMapping));
            }
        }
        if (original_m instanceof ContainerMapping) {
            for (ContainerMapping iContainerMapping : original_layer.getContainerMappings()) {
                if (!iContainerMapping.getReusedContainerMappings().contains((Object)original_m) || original_m.equals(iContainerMapping)) continue;
                this.registerImportData(new MappingImportData((AbstractNodeMapping)iContainerMapping));
            }
        }
    }

    private MappingImportData createOrGetParentDataOf(MappingImportData data) {
        if (data.getParent() != null) {
            return data.getParent();
        }
        if (!(data.getOriginal_mapping().eContainer() instanceof Layer)) {
            AbstractNodeMapping parent_original_mapping = (AbstractNodeMapping)data.getOriginal_mapping().eContainer();
            MappingImportData parent_data = new MappingImportData(parent_original_mapping);
            return this.lookForMappingInRegisteredMapping(parent_data);
        }
        return null;
    }

    private MappingImportData lookForMappingInRegisteredMapping(MappingImportData data) {
        if (data != null) {
            for (MappingImportData iMappingImportData : this._MappingImportList) {
                if (!iMappingImportData.equals(data)) continue;
                return iMappingImportData;
            }
        }
        return data;
    }

    private static Layer getCorrespondingLayer(EObject eObject) {
        if (eObject instanceof Layer) {
            return (Layer)eObject;
        }
        if (eObject instanceof AbstractNodeMapping) {
            AbstractNodeMapping aNodeMapping = (AbstractNodeMapping)eObject;
            EObject parent = aNodeMapping.eContainer();
            while (parent.eContainer() != null && !(parent instanceof Layer)) {
                parent = parent.eContainer();
            }
            if (parent != null && parent instanceof Layer) {
                return (Layer)parent;
            }
        }
        return null;
    }
}

