/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.generation.diagram.util;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.desc.helper.configuration.VpDslConfigurationHelper;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.desc.helper.project.VpDslProjectHelper;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.NamedElement;

public class IconPathHelper {
    private static final String no_icon_name = "Icon name must have a value";
    private static final String vpElement_is_null = "Viewpoint element must be not null";
    private static final String vpElement_name_is_null = "Viewpoint element name must be not null";
    private static final String default_icon_folder = "icons";
    private static final String default_design_project = "design";
    private static final NullProgressMonitor null_progress_monitor = new NullProgressMonitor();

    public static String computeDslIconPath(String icon_name, NamedElement vpElement) {
        if (icon_name == null || icon_name != null && icon_name.trim().length() == 0) {
            throw new IllegalArgumentException(no_icon_name);
        }
        if (vpElement == null) {
            throw new IllegalArgumentException(vpElement_is_null);
        }
        String plugin_ID = VpDslConfigurationHelper.getRootProjectName((Object)vpElement);
        String icon_path = "/" + plugin_ID + "." + default_design_project + "/" + default_icon_folder + "/" + icon_name;
        return icon_path;
    }

    public static boolean copyIconFile(String icon_name, NamedElement vpElement) throws CoreException, InvocationTargetException, InterruptedException {
        boolean result = true;
        IFolder source_folder = VpDslProjectHelper.getVpDslIconFolder((EObject)vpElement, (boolean)false);
        if (source_folder == null || !source_folder.exists()) {
            return false;
        }
        final IFile source_icon = source_folder.getFile(icon_name);
        if (source_icon == null || !source_icon.exists()) {
            return false;
        }
        IFolder target_folder = IconPathHelper.getTargetFolder(vpElement);
        final IFile target_icon = target_folder.getFile(icon_name);
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                if (target_icon.exists()) {
                    target_icon.delete(false, (IProgressMonitor)null_progress_monitor);
                }
                source_icon.copy(target_icon.getFullPath(), true, (IProgressMonitor)null_progress_monitor);
            }
        };
        operation.run((IProgressMonitor)null_progress_monitor);
        return result;
    }

    private static IFolder getTargetFolder(NamedElement vpElement) throws CoreException, InvocationTargetException, InterruptedException {
        String plugin_ID = VpDslConfigurationHelper.getRootProjectName((Object)vpElement);
        String Design_Project_path = "/" + plugin_ID + "." + default_design_project;
        IProject design_project = ResourcesPlugin.getWorkspace().getRoot().getProject(Design_Project_path);
        final IFolder design_icon_folder = design_project.getFolder(default_icon_folder);
        if (!design_icon_folder.exists()) {
            WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                    design_icon_folder.create(true, true, (IProgressMonitor)null_progress_monitor);
                }
            };
            operation.run((IProgressMonitor)null_progress_monitor);
        }
        return design_icon_folder;
    }

    @Deprecated
    private static String computeTargetIconFileName(String icon_name, NamedElement vpElement) {
        String vpElement_name = vpElement.getName();
        String icon_ext = IconPathHelper.getIconFileExtension(icon_name);
        if (vpElement_name.trim().length() == 0) {
            throw new IllegalArgumentException(vpElement_name_is_null);
        }
        return icon_ext.trim().length() > 0 ? String.valueOf(vpElement_name) + "." + icon_ext : vpElement_name;
    }

    private static String getIconFileExtension(String icon_name) {
        int point_index = icon_name.lastIndexOf(".");
        String icon_ext = "";
        if (point_index != -1) {
            icon_ext = icon_name.substring(point_index + 1);
        }
        return icon_ext;
    }
}

