/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.tools.model.ViewpointElement;
import org.polarsys.kitalpha.ad.viewpoint.handlers.IElementHandler;

public class ElementHelper {
    public static String computeNewId(IElementHandler handler, String radix) {
        List<String> values = ElementHelper.getIds(handler);
        return ElementHelper.computeUniqueValue(values, radix);
    }

    public static String computeNewName(IElementHandler handler, String radix) {
        List<String> names = ElementHelper.getNames(handler);
        return ElementHelper.computeUniqueValue(names, radix);
    }

    private static String computeUniqueValue(List<String> names, String radix) {
        int nb = 1;
        String candidate = radix;
        while (names.contains(candidate)) {
            candidate = String.valueOf(radix) + nb;
            ++nb;
        }
        return candidate;
    }

    public static List<String> getNamesFromParents(IElementHandler handler) {
        HashSet<String> set = new HashSet<String>();
        for (ViewpointElement elt : handler.getElementsFromParents()) {
            String name = elt.getName();
            if (name == null) continue;
            set.add(name);
        }
        return ElementHelper.getAsSortedList(set);
    }

    private static List<String> getAsSortedList(Set<String> set) {
        ArrayList<String> result = new ArrayList<String>(set);
        Collections.sort(result);
        return result;
    }

    public static List<String> getNames(IElementHandler handler) {
        HashSet<String> set = new HashSet<String>();
        for (ViewpointElement elt : handler.getElements()) {
            String name = elt.getName();
            if (name == null) continue;
            set.add(name);
        }
        return ElementHelper.getAsSortedList(set);
    }

    public static List<String> getIds(IElementHandler handler) {
        HashSet<String> set = new HashSet<String>();
        for (ViewpointElement elt : handler.getElements()) {
            String id = elt.getId();
            if (id == null) continue;
            set.add(id);
        }
        return ElementHelper.getAsSortedList(set);
    }

    public static List<String> getIdsFromParents(IElementHandler handler) {
        HashSet<String> set = new HashSet<String>();
        for (ViewpointElement elt : handler.getElementsFromParents()) {
            String id = elt.getId();
            if (id == null) continue;
            set.add(id);
        }
        return ElementHelper.getAsSortedList(set);
    }
}

