/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.doc.gen.business.ecore.actions;

import java.util.Collection;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.egf.model.domain.Domain;
import org.eclipse.egf.model.domain.DomainViewpoint;
import org.eclipse.egf.model.domain.EMFDomain;
import org.eclipse.egf.model.fcore.Activity;
import org.eclipse.egf.model.fcore.Contract;
import org.eclipse.egf.model.fcore.FactoryComponent;
import org.eclipse.egf.model.fcore.Viewpoint;
import org.eclipse.egf.model.pattern.TypePatternSubstitution;
import org.eclipse.egf.model.types.Type;
import org.eclipse.egf.model.types.TypeString;
import org.eclipse.egf.pattern.EGFPatternPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.swt.widgets.Display;
import org.polarsys.kitalpha.doc.gen.business.core.sirius.util.session.DiagramSessionHelper;
import org.polarsys.kitalpha.doc.gen.business.core.ui.helper.InvokeActivityHelper;
import org.polarsys.kitalpha.doc.gen.business.core.util.DocGenHtmlUtil;
import org.polarsys.kitalpha.doc.gen.business.ecore.Activator;
import org.polarsys.kitalpha.doc.gen.business.ecore.services.GenerateDiagramsService;

public class GenDocCommand {
    private Activity launcher;
    private String folderPath;
    private Resource resource;
    private IPath path;
    private TypePatternSubstitution patternSubstitutions;
    private URI airdUri;
    private GenerateDiagramsService generateDiagramService;
    private final IProgressMonitor progressMonitor;

    public GenDocCommand(Activity launcher, String folderPath, Resource resource, TypePatternSubstitution substitutions, IProgressMonitor monitor) {
        this.launcher = launcher;
        this.folderPath = folderPath;
        this.resource = resource;
        this.patternSubstitutions = substitutions;
        this.progressMonitor = monitor;
    }

    public void execute(IProgressMonitor progressMonitor) {
        this.createProject();
        this.cleanFiles();
        this.generateDiagrams(progressMonitor);
        if (this.airdUri != null) {
            this.generateDocumentation(progressMonitor);
        } else {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.polarsys.kitalpha.doc.gen.business.ecore", "Cannot Generate Diagrams"));
        }
    }

    private void createProject() {
        this.path = new Path(this.folderPath);
        this.path = this.path.append("output");
        IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(this.path);
        if (!folder.exists()) {
            try {
                folder.create(true, true, null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    private void generateDocumentation(IProgressMonitor progressMonitor) {
        DiagramSessionHelper.setAirdUri((URI)this.airdUri);
        Session session = DiagramSessionHelper.initSession();
        if (this.launcher instanceof FactoryComponent) {
            FactoryComponent factoryComponent = (FactoryComponent)this.launcher;
            this.setContract(factoryComponent, "projectName", this.getProjectName(this.folderPath));
            this.setContract(factoryComponent, "outputFolder", String.valueOf(this.getOutputFolder(this.folderPath)) + "/output");
            this.setDomain(factoryComponent, this.resource.getURI());
            if (this.patternSubstitutions != null) {
                this.setPatternsubstitutionContract(factoryComponent, "pattern.substitutions", this.patternSubstitutions);
            }
            try {
                InvokeActivityHelper.invoke((Activity)factoryComponent, (IProgressMonitor)progressMonitor);
            }
            catch (Exception e) {
                EGFPatternPlugin.getDefault().logError((Throwable)e);
            }
        }
        if (session.isOpen()) {
            session.save(progressMonitor);
            session.close(progressMonitor);
        }
        OperationHistoryFactory.getOperationHistory().dispose(IOperationHistory.GLOBAL_UNDO_CONTEXT, true, true, true);
    }

    private void cleanFiles() {
        if (this.resource.getContents() == null || this.resource.getContents() != null && this.resource.getContents().size() <= 0) {
            return;
        }
        String modelName = DocGenHtmlUtil.getModelName((EObject)((EObject)this.resource.getContents().get(0)));
        IPath modelPath = this.path.append(modelName);
        IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(modelPath);
        try {
            if (folder != null && folder.exists()) {
                IResource[] members;
                IResource[] iResourceArray = members = folder.members();
                int n = members.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource resource = iResourceArray[n2];
                    resource.delete(true, this.progressMonitor);
                    ++n2;
                }
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void layoutRepresentations() {
        if (this.airdUri != null) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    GenDocCommand.this.generateDiagramService.layout(GenDocCommand.this.airdUri);
                }
            });
        }
    }

    private void generateDiagrams(IProgressMonitor progressMonitor) {
        this.generateDiagramService = new GenerateDiagramsService(this.resource, this.path);
        this.airdUri = this.generateDiagramService.generateAIRD(progressMonitor);
    }

    private void setDomain(FactoryComponent factoryComponent, URI uri) {
        DomainViewpoint domainViewpoint;
        Domain domain;
        Viewpoint viewpoint = factoryComponent.getViewpointContainer().getViewpoint(DomainViewpoint.class);
        if (viewpoint instanceof DomainViewpoint && (domain = (Domain)(domainViewpoint = (DomainViewpoint)viewpoint).getDomains().get(0)) instanceof EMFDomain) {
            EMFDomain domainURI = (EMFDomain)domain;
            domainURI.setUri(uri);
        }
    }

    private void setPatternsubstitutionContract(FactoryComponent factoryComponent, String contractName, TypePatternSubstitution value) {
        if (value == null || value != null && value.getSubstitutions().size() <= 0) {
            return;
        }
        Contract invokedContract = factoryComponent.getContract(contractName);
        Type type = invokedContract.getType();
        if (type instanceof TypePatternSubstitution) {
            TypePatternSubstitution typePatternSubstitution = (TypePatternSubstitution)type;
            typePatternSubstitution.getSubstitutions().addAll((Collection)value.getSubstitutions());
        }
    }

    private void setContract(FactoryComponent factoryComponent, String contractName, String value) {
        Contract invokedContract = factoryComponent.getContract(contractName);
        Type type = invokedContract.getType();
        if (type instanceof TypeString) {
            TypeString typeString = (TypeString)type;
            typeString.setValue(value);
        }
    }

    private String getOutputFolder(String containerName) {
        String projectName = this.getProjectName(containerName);
        Path outputFolderPath = new Path(containerName);
        outputFolderPath = outputFolderPath.makeRelativeTo((IPath)new Path(projectName));
        return outputFolderPath.toString();
    }

    private String getProjectName(String containerName) {
        IFolder container = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)new Path(containerName));
        return container.getProject().getName();
    }
}

