/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.doc.gen.business.ecore.services;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.sirius.business.api.dialect.command.MoveRepresentationCommand;
import org.eclipse.sirius.business.api.resource.ResourceDescriptor;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.danalysis.DAnalysisSession;
import org.eclipse.sirius.business.api.session.resource.AirdResource;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.sirius.ui.business.api.session.IEditingSession;
import org.eclipse.sirius.ui.business.api.session.SessionUIManager;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.ViewpointFactory;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.polarsys.kitalpha.doc.gen.business.ecore.Activator;

public class ExtractRepresentationSilentCommand {
    private final TransactionalEditingDomain domain;
    private Session session;
    private Collection<DRepresentation> representations;
    private Resource pickedResource;
    private URI fragmentResourceURI;

    public ExtractRepresentationSilentCommand(Session session, URI fragmentResourceURI, TransactionalEditingDomain domain, Collection<DRepresentation> movableRepresentations) {
        this.domain = session.getTransactionalEditingDomain();
        this.session = session;
        this.representations = movableRepresentations;
        this.fragmentResourceURI = fragmentResourceURI;
    }

    public boolean execute() {
        DiagramFileCreationOperation op = new DiagramFileCreationOperation();
        boolean errorCatch = false;
        if (errorCatch = this.createAIRDFile((IRunnableWithProgress)op, errorCatch)) {
            return false;
        }
        DAnalysis slaveAnalysis = this.prepareNewAnalysis();
        this.moveRepresentations(slaveAnalysis);
        return true;
    }

    private void moveRepresentations(final DAnalysis slaveAnalysis) {
        IRunnableWithProgress moveReps = new IRunnableWithProgress(){

            public void run(IProgressMonitor mon) {
                ExtractRepresentationSilentCommand.this.domain.getCommandStack().execute((Command)new MoveRepresentationCommand(ExtractRepresentationSilentCommand.this.session, slaveAnalysis, ExtractRepresentationSilentCommand.this.representations));
            }
        };
        try {
            moveReps.run((IProgressMonitor)new NullProgressMonitor());
        }
        catch (InterruptedException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(1, "org.polarsys.kitalpha.doc.gen.business.ecore", "the move representations action was interrupted", (Throwable)e));
        }
        catch (InvocationTargetException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.polarsys.kitalpha.doc.gen.business.ecore", "the move representations encountered an exception", (Throwable)e));
        }
    }

    private boolean createAIRDFile(IRunnableWithProgress op, boolean error) {
        boolean errorCatch = error;
        try {
            op.run((IProgressMonitor)new NullProgressMonitor());
        }
        catch (InterruptedException e) {
            errorCatch = true;
        }
        catch (InvocationTargetException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.polarsys.kitalpha.doc.gen.business.ecore", "Error creating aird session data", e.getTargetException()));
            errorCatch = true;
        }
        return errorCatch;
    }

    private DAnalysis prepareNewAnalysis() {
        DAnalysis slaveAnalysis = ViewpointFactory.eINSTANCE.createDAnalysis();
        this.domain.getCommandStack().execute((Command)new LocalPrepareNewAnalysisCommand(this.domain, this.pickedResource, slaveAnalysis, this.session));
        return slaveAnalysis;
    }

    private void closeRepresentations(Collection<DRepresentation> diagrams) {
        IEditingSession uiSession = SessionUIManager.INSTANCE.getUISession(this.session);
        if (uiSession != null) {
            for (DRepresentation representation : diagrams) {
                this.closeOpenedEditor(uiSession, representation);
            }
        }
    }

    private void closeOpenedEditor(IEditingSession uiSession, DRepresentation representation) {
        DialectEditor editor = uiSession.getEditor(representation);
        if (editor != null) {
            editor.getEditorSite().getPage().closeEditor((IEditorPart)editor, false);
        }
    }

    public Resource getCreatedResource() {
        return this.pickedResource;
    }

    private class DiagramFileCreationOperation
    extends WorkspaceModifyOperation {
        public DiagramFileCreationOperation() {
            super(null);
        }

        protected void execute(IProgressMonitor monitor) throws CoreException, InterruptedException {
            ResourceSet set = ExtractRepresentationSilentCommand.this.session.getTransactionalEditingDomain().getResourceSet();
            Set allSessionResources = ExtractRepresentationSilentCommand.this.session.getReferencedSessionResources();
            boolean fragmentAvailable = false;
            for (Resource resource : allSessionResources) {
                if (!(resource instanceof AirdResource) || !resource.getURI().equals(ExtractRepresentationSilentCommand.this.fragmentResourceURI)) continue;
                fragmentAvailable = true;
                break;
            }
            if (fragmentAvailable) {
                ExtractRepresentationSilentCommand.this.pickedResource = set.getResource(ExtractRepresentationSilentCommand.this.fragmentResourceURI, true);
            } else {
                ExtractRepresentationSilentCommand.this.pickedResource = set.createResource(ExtractRepresentationSilentCommand.this.fragmentResourceURI);
                try {
                    ExtractRepresentationSilentCommand.this.pickedResource.save(Collections.emptyMap());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private class LocalPrepareNewAnalysisCommand
    extends RecordingCommand {
        private DAnalysis slaveAnalysis;
        private Resource resource;
        private Session session;

        public LocalPrepareNewAnalysisCommand(TransactionalEditingDomain domain, Resource resource, DAnalysis newAnalysis, Session session) {
            super(domain, "Prepare new Analysis");
            this.slaveAnalysis = newAnalysis;
            this.resource = resource;
            this.session = session;
        }

        protected void doExecute() {
            if (this.slaveAnalysis != null && this.resource != null) {
                this.resource.getContents().add((Object)this.slaveAnalysis);
            }
            if (this.slaveAnalysis != null && this.session instanceof DAnalysisSession) {
                ((DAnalysisSession)this.session).addReferencedAnalysis(this.slaveAnalysis);
                for (Resource semResource : this.session.getSemanticResources()) {
                    if (semResource.getContents().isEmpty()) continue;
                    this.slaveAnalysis.getSemanticResources().add((Object)new ResourceDescriptor(semResource.getURI()));
                }
            }
        }

        public boolean canUndo() {
            return false;
        }
    }
}

