/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.emde.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreSwitch;
import org.polarsys.kitalpha.emde.model.EmdePackage;

public class ExtensionValidationHelper {
    private final ResourceSet set = new ResourceSetImpl();
    private static final EPackage.Registry REGISTRY = new EPackageRegistryImpl(EPackage.Registry.INSTANCE);

    private void loadModels() throws CoreException {
        HashSet<IFile> files = new HashSet<IFile>();
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject proj = iProjectArray[n2];
            if (proj.isAccessible()) {
                this.visit((IContainer)proj, files);
            }
            ++n2;
        }
        for (IFile file : files) {
            URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString());
            Resource resource = this.set.getResource(uri, true);
            EPackage pack = (EPackage)resource.getContents().get(0);
            REGISTRY.put((Object)pack.getNsURI(), (Object)pack);
        }
    }

    public void validateSuperTypes(BasicDiagnostic diagnostic, EClass eclass) {
        EAnnotation annotation1 = eclass.getEAnnotation("http://www.polarsys.org/kitalpha/emde/1.0.0/constraint");
        if (annotation1 == null) {
            return;
        }
        EClass elementExtension = EmdePackage.eINSTANCE.getElementExtension();
        String nsURI = elementExtension.getEPackage().getNsURI();
        for (EClass cls : eclass.getEAllSuperTypes()) {
            if (!nsURI.equals(cls.getEPackage().getNsURI()) || !elementExtension.getName().equals(cls.getName())) continue;
            return;
        }
        diagnostic.add((Diagnostic)new BasicDiagnostic(4, "EClass " + eclass.getName(), 0, "The EClass must extends ElementExtension", new Object[]{eclass}));
    }

    public void validateConstraintAnnotation(BasicDiagnostic diagnostic, EClass eclass) {
        EAnnotation annotation = eclass.getEAnnotation("http://www.polarsys.org/kitalpha/emde/1.0.0/constraint");
        if (annotation != null) {
            String value = (String)annotation.getDetails().get((Object)"ExtendedElement");
            if (value == null) {
                diagnostic.add((Diagnostic)new BasicDiagnostic(4, "EClass " + eclass.getName(), 0, "Missing annotation details 'ExtendedElement'", new Object[]{eclass}));
                return;
            }
            String[] stringArray = value.trim().split("\\s");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String val = stringArray[n2];
                this.doValidateConstraintValue(eclass, val, diagnostic);
                ++n2;
            }
        }
    }

    private void doValidateConstraintValue(EClass eclass, String value, BasicDiagnostic diagnostic) {
        EPackage ePackage;
        if (value == null || "".equals(value)) {
            return;
        }
        URI uri = URI.createURI((String)value);
        String fragment = uri.fragment();
        if (fragment.startsWith("//")) {
            fragment = fragment.substring(2);
        }
        if ((ePackage = REGISTRY.getEPackage((uri = uri.trimFragment()).toString())) == null) {
            diagnostic.add((Diagnostic)new BasicDiagnostic(4, "EClass " + eclass.getName(), 0, "Cannot find package with nsURI '" + uri.toString() + "'", new Object[]{eclass}));
            return;
        }
        EClassifier eClassifier = ePackage.getEClassifier(fragment);
        if (eClassifier == null) {
            diagnostic.add((Diagnostic)new BasicDiagnostic(4, "EPackage " + ePackage.getName(), 0, "Cannot find EClass '" + fragment + "' in package '" + ePackage.getNsURI() + "'", new Object[]{eclass}));
            return;
        }
    }

    private static Diagnostic toDiagnostic(Resource.Diagnostic child) {
        BasicDiagnostic diagnostic = new BasicDiagnostic(4, "", 0, String.valueOf(child.getMessage()) + " Location:" + child.getLocation() + " (" + child.getLine() + "," + child.getColumn() + " )", null);
        return diagnostic;
    }

    private void visit(IContainer container, Set<IFile> files) throws CoreException {
        IResource[] iResourceArray = container.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource res = iResourceArray[n2];
            if (res.isAccessible()) {
                IFile file;
                if (res.getType() == 2) {
                    this.visit((IContainer)res, files);
                } else if (res.getType() == 1 && "ecore".equals((file = (IFile)res).getFileExtension())) {
                    files.add(file);
                }
            }
            ++n2;
        }
    }

    public static BasicDiagnostic visit(List<? extends Object> objects) throws CoreException {
        final BasicDiagnostic diagnostic = new BasicDiagnostic(0, "", 0, "Extension validation", null);
        ExtensionValidationHelper helper = ExtensionValidationHelper.createHelper();
        EcoreSwitch<String> _switch = new EcoreSwitch<String>(){

            public String caseEClass(EClass object) {
                ExtensionValidationHelper.this.validateSuperTypes(diagnostic, object);
                ExtensionValidationHelper.this.validateConstraintAnnotation(diagnostic, object);
                return "";
            }

            public String caseEPackage(EPackage object) {
                for (EClassifier cls : object.getEClassifiers()) {
                    this.doSwitch((EObject)cls);
                }
                return "";
            }
        };
        for (Object object : objects) {
            if (!(object instanceof EObject)) continue;
            _switch.doSwitch((EObject)object);
        }
        return diagnostic;
    }

    public static BasicDiagnostic visit(Object object) throws CoreException {
        ArrayList<Object> objs = new ArrayList<Object>();
        objs.add(object);
        return ExtensionValidationHelper.visit(objs);
    }

    private static ExtensionValidationHelper createHelper() throws CoreException {
        ExtensionValidationHelper helper = new ExtensionValidationHelper();
        helper.loadModels();
        return helper;
    }
}

