/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.model.attachment.ui.merge;

import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.diffmerge.api.IMergeSelector;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.api.diff.IDifference;
import org.eclipse.emf.diffmerge.diffdata.EElementPresence;
import org.eclipse.emf.diffmerge.diffdata.EReferenceValuePresence;
import org.eclipse.emf.ecore.EObject;

public final class AttachmentMergeSelector
implements IMergeSelector {
    private Collection<String> selectedUris;
    private Collection<IDifference> conflicts;

    public AttachmentMergeSelector(Collection<String> selectedUris, Collection<IDifference> conflicts) {
        this.selectedUris = selectedUris;
        this.conflicts = conflicts;
    }

    public Role getMergeDirection(IDifference difference_p) {
        Role computeMergeDirection = this.computeMergeDirection(difference_p);
        if (computeMergeDirection != null && difference_p.isConflicting()) {
            this.conflicts.add(difference_p);
            return null;
        }
        return computeMergeDirection;
    }

    private Role computeMergeDirection(IDifference difference_p) {
        if (difference_p instanceof EReferenceValuePresence) {
            EReferenceValuePresence diff = (EReferenceValuePresence)difference_p;
            if (diff.getValue().getReference() == null) {
                return null;
            }
            if (this.toMerge(diff.getValue().getReference())) {
                return Role.TARGET;
            }
            EList eCrossReferences = diff.getValue().getReference().eCrossReferences();
            return this.toMerge((EObject[])eCrossReferences.toArray((Object[])new EObject[eCrossReferences.size()])) ? Role.TARGET : null;
        }
        if (difference_p instanceof EElementPresence) {
            EElementPresence diff = (EElementPresence)difference_p;
            return this.toMerge(diff.getElement(), true) ? Role.TARGET : null;
        }
        return null;
    }

    private boolean toMerge(EObject ... objs) {
        EObject[] eObjectArray = objs;
        int n = objs.length;
        int n2 = 0;
        while (n2 < n) {
            EObject obj = eObjectArray[n2];
            if (obj == null) {
                return false;
            }
            if (this.selectedUris.contains(obj.eClass().getEPackage().getNsURI())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean toMerge(EObject obj, boolean checkContainers) {
        boolean merge = this.toMerge(obj);
        if (merge || !checkContainers) {
            return merge;
        }
        EObject eContainer = obj.eContainer();
        if (eContainer == null) {
            return false;
        }
        return this.toMerge(eContainer, true);
    }
}

