/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.emde.ui.actions;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.ui.dialogs.DiagnosticDialog;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.polarsys.kitalpha.emde.extension.utils.Log;
import org.polarsys.kitalpha.emde.model.ExtensionValidationHelper;

public class ValidateExtensionAction
extends Action
implements IActionDelegate {
    private ISelection selection;

    public void run(IAction action) {
        try {
            BasicDiagnostic diagnostic = ExtensionValidationHelper.visit((List)((IStructuredSelection)this.selection).toList());
            this.displayResult((Diagnostic)diagnostic);
            String fullMessage = this.toString(new StringBuilder(), (Diagnostic)diagnostic).toString();
            if (diagnostic.getSeverity() == 4) {
                Log.getDefault().logError(fullMessage);
            } else if (diagnostic.getSeverity() == 2) {
                Log.getDefault().logError(fullMessage);
            }
            Log.getDefault().logInfo(fullMessage);
        }
        catch (CoreException e) {
            Log.getDefault().logError((Throwable)e);
        }
    }

    StringBuilder toString(StringBuilder sb, Diagnostic diagnostic) {
        sb.append(diagnostic.getMessage());
        if (!diagnostic.getData().isEmpty()) {
            sb.append(" on element ");
            for (Object obj : diagnostic.getData()) {
                if (!(obj instanceof ENamedElement)) continue;
                sb.append("'").append(((ENamedElement)obj).getName()).append("' ");
            }
        }
        sb.append("\n");
        for (Diagnostic diag : diagnostic.getChildren()) {
            this.toString(sb, diag);
        }
        return sb;
    }

    private void displayResult(Diagnostic diagnostic) {
        String title = "Validation Result";
        if (diagnostic.getSeverity() == 4) {
            DiagnosticDialog.openProblem((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)title, (String)"The extension declaration contains some errors", (Diagnostic)diagnostic);
        } else {
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)title, (String)"The extension declaration contains no errors");
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }
}

