/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.sdk.manager;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.osgi.framework.BundleException;
import org.polarsys.kitalpha.ad.common.AD_Log;
import org.polarsys.kitalpha.ad.services.manager.AlreadyInStateException;
import org.polarsys.kitalpha.ad.services.manager.ViewpointActivationException;
import org.polarsys.kitalpha.ad.services.manager.ViewpointManager;
import org.polarsys.kitalpha.ad.viewpoint.sdk.Messages;
import org.polarsys.kitalpha.ad.viewpoint.sdk.manager.BundleManager;
import org.polarsys.kitalpha.resourcereuse.model.Resource;

public class WorkspaceViewpointManager
extends ViewpointManager {
    static {
        ResourcesPlugin.getWorkspace().addResourceChangeListener(new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                if (INSTANCE == null) {
                    return;
                }
                IProject project = event.getResource().getProject();
                if (project == null) {
                    return;
                }
                IPluginModelBase bundle = PluginRegistry.findModel((IProject)project);
                if (bundle == null) {
                    return;
                }
                String symbolicName = bundle.getBundleDescription().getSymbolicName();
                INSTANCE;
                Resource[] resourceArray = ViewpointManager.getAvailableViewpoints();
                int n = resourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Resource res = resourceArray[n2];
                    if (symbolicName.equals(res.getProviderSymbolicName())) {
                        try {
                            INSTANCE.desactivate(res.getId());
                        }
                        catch (AlreadyInStateException alreadyInStateException) {
                        }
                        catch (ViewpointActivationException e) {
                            AD_Log.getDefault().logError((Throwable)e);
                        }
                    }
                    ++n2;
                }
            }
        }, 4);
    }

    protected void activateBundle(String id) throws ViewpointActivationException {
        try {
            BundleManager.INSTANCE.load(id);
        }
        catch (Exception e) {
            throw new ViewpointActivationException(NLS.bind((String)Messages.ManageBundle_error_title8, (Object)id), (Throwable)e);
        }
    }

    protected void desactivateBundle(String id) throws ViewpointActivationException {
        if (!BundleManager.INSTANCE.isManaged(id)) {
            return;
        }
        try {
            BundleManager.INSTANCE.unLoad(id);
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (BundleException e) {
            throw new ViewpointActivationException(NLS.bind((String)Messages.ManageBundle_error_title9, (Object)id), (Throwable)e);
        }
    }
}

