/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.design.service;

import com.google.common.base.Ascii;
import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypeParameter;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EStringToStringMapEntryImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecoretools.design.service.AutosizeTrigger;
import org.eclipse.emf.ecoretools.design.service.DiagnosticAttachment;
import org.eclipse.emf.ecoretools.design.service.EAttributeServices;
import org.eclipse.emf.ecoretools.design.service.EGenericsServices;
import org.eclipse.emf.ecoretools.design.service.EOperationServices;
import org.eclipse.emf.ecoretools.design.service.EReferenceServices;
import org.eclipse.emf.ecoretools.design.service.EcoreToolsDesignPlugin;
import org.eclipse.emf.ecoretools.design.service.RelatedElementsSwitch;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DNodeList;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.business.api.query.DDiagramQuery;
import org.eclipse.sirius.diagram.business.internal.helper.task.operations.CreateViewTask;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.tool.CreateView;
import org.eclipse.sirius.diagram.description.tool.ToolFactory;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ecore.extender.business.api.accessor.exception.FeatureNotFoundException;
import org.eclipse.sirius.ecore.extender.business.api.accessor.exception.MetaClassNotFoundException;
import org.eclipse.sirius.ext.emf.AllContents;
import org.eclipse.sirius.tools.api.command.CommandContext;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.ViewpointPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DesignServices
extends EReferenceServices {
    private static final String CLASS_DIAGRAM_CLASS_MAPPINGID = "EC EClass";
    protected static final String GEN_MODEL_PACKAGE_NS_URI = "http://www.eclipse.org/emf/2002/GenModel";
    protected static final String ECORE_PACKAGE_NS_URI = "http://www.eclipse.org/emf/2002/Ecore";

    public Collection<EObject> allRoots(EObject any) {
        Resource res = any.eResource();
        if (res != null && res.getResourceSet() != null) {
            ArrayList<EObject> roots = new ArrayList<EObject>();
            for (Resource childRes : res.getResourceSet().getResources()) {
                roots.addAll((Collection<EObject>)childRes.getContents());
            }
            return roots;
        }
        return Collections.emptySet();
    }

    public Collection<EPackage> rootEPackages(EObject any) {
        return Sets.newLinkedHashSet((Iterable)Iterables.filter(this.allRoots(any), EPackage.class));
    }

    public Boolean isEOperation(EObject any) {
        return any instanceof EOperation;
    }

    public Boolean isEStructuralFeature(EObject any) {
        return any instanceof EStructuralFeature;
    }

    public Boolean isEPackage(EObject any) {
        return any instanceof EPackage;
    }

    public Boolean isEClass(EObject any) {
        return any instanceof EClass;
    }

    public Boolean isEEnum(EObject any) {
        return any instanceof EEnum;
    }

    public EObject markForAutosize(EObject any) {
        if (any != null) {
            any.eAdapters().add((Object)AutosizeTrigger.AUTO_SIZE_MARKER);
        }
        return any;
    }

    public EObject eContainerEContainer(EObject any) {
        if (any.eContainer() != null) {
            return any.eContainer().eContainer();
        }
        return null;
    }

    public Collection<EStringToStringMapEntryImpl> getVisibleDocAnnotations(EObject self, DSemanticDiagram diag) {
        LinkedHashSet result = Sets.newLinkedHashSet();
        for (EModelElement displayed : this.getDisplayedEModelElements(diag)) {
            EAnnotation eAnnot;
            if (displayed instanceof EAttribute || displayed instanceof EEnumLiteral || displayed instanceof EOperation || (eAnnot = displayed.getEAnnotation(GEN_MODEL_PACKAGE_NS_URI)) == null) continue;
            for (EStringToStringMapEntryImpl mapEntry : Iterables.filter((Iterable)eAnnot.getDetails(), EStringToStringMapEntryImpl.class)) {
                if (!"documentation".equals(mapEntry.getKey())) continue;
                result.add(mapEntry);
            }
        }
        return result;
    }

    public Collection<EStringToStringMapEntryImpl> getVisibleConstraintsAnnotations(EObject self, DSemanticDiagram diag) {
        LinkedHashSet result = Sets.newLinkedHashSet();
        for (EModelElement displayed : this.getDisplayedEModelElements(diag)) {
            EAnnotation eAnnot;
            if (displayed instanceof EAttribute || displayed instanceof EEnumLiteral || displayed instanceof EOperation || (eAnnot = displayed.getEAnnotation(ECORE_PACKAGE_NS_URI)) == null) continue;
            for (EStringToStringMapEntryImpl mapEntry : Iterables.filter((Iterable)eAnnot.getDetails(), EStringToStringMapEntryImpl.class)) {
                if (!"constraints".equals(mapEntry.getKey())) continue;
                result.add(mapEntry);
            }
        }
        return result;
    }

    public boolean hasNoClassifier(DSemanticDiagram diagram) {
        UnmodifiableIterator it = Iterators.filter((Iterator)diagram.getOwnedDiagramElements().iterator(), DSemanticDecorator.class);
        while (it.hasNext()) {
            DSemanticDecorator dec = (DSemanticDecorator)it.next();
            if (!(dec.getTarget() instanceof EClassifier)) continue;
            return true;
        }
        return false;
    }

    public Set<EClass> getDisplayedEClasses(DSemanticDiagram diagram) {
        LinkedHashSet result = Sets.newLinkedHashSet();
        for (DDiagramElement dec : new DDiagramQuery((DDiagram)diagram).getAllDiagramElements()) {
            if (!(dec.getTarget() instanceof EClass)) continue;
            result.add((EClass)dec.getTarget());
        }
        return result;
    }

    private Set<EClass> getInternalEClasses(DSemanticDiagram diagram) {
        LinkedHashSet result = Sets.newLinkedHashSet();
        UnmodifiableIterator it = Iterators.filter(new DDiagramQuery((DDiagram)diagram).getAllDiagramElements().iterator(), DNodeList.class);
        while (it.hasNext()) {
            DNodeList dec = (DNodeList)it.next();
            if (!(dec.getTarget() instanceof EClass) || dec.getActualMapping() == null || !CLASS_DIAGRAM_CLASS_MAPPINGID.equals(dec.getActualMapping().getName())) continue;
            result.add((EClass)dec.getTarget());
        }
        return result;
    }

    public Collection<EClass> getExternalEClasses(EPackage root, DSemanticDiagram diagram) {
        LinkedHashSet related = Sets.newLinkedHashSet();
        Set<EClass> eClasses = this.getInternalEClasses(diagram);
        RelatedElementsSwitch relations = new RelatedElementsSwitch();
        for (EClass eClass : eClasses) {
            for (EClass other : Iterables.filter(relations.getRelatedElements((EObject)eClass), EClass.class)) {
                related.add(other);
            }
        }
        return Sets.difference((Set)related, eClasses);
    }

    public Collection<EReference> getEReferencesToDisplay(EPackage root, DSemanticDiagram diagram) {
        Set<EClass> eClasses = this.getDisplayedEClasses(diagram);
        LinkedHashSet eRefs = Sets.newLinkedHashSet();
        for (EClass clazz : eClasses) {
            eRefs.addAll(clazz.getEAllReferences());
        }
        return eRefs;
    }

    public Boolean targetIsInterface(EClass clazz, EObject view) {
        EdgeTarget target;
        if (view instanceof DEdge && (target = ((DEdge)view).getTargetNode()) instanceof DSemanticDecorator && ((DSemanticDecorator)target).getTarget() instanceof EClass) {
            return ((EClass)((DSemanticDecorator)target).getTarget()).isInterface();
        }
        return false;
    }

    public List<EReference> getEOppositeSemanticElements(EReference ref) {
        LinkedHashSet allRefs = Sets.newLinkedHashSet();
        allRefs.add(ref);
        if (ref.getEOpposite() != null) {
            allRefs.add(ref.getEOpposite());
        }
        return Ordering.natural().onResultOf((Function)new Function<EReference, String>(){

            public String apply(EReference input) {
                return input.getName();
            }
        }).sortedCopy((Iterable)allRefs);
    }

    public Collection<EModelElement> getDisplayedEModelElements(DSemanticDiagram diagram) {
        LinkedHashSet modelelements = Sets.newLinkedHashSet();
        UnmodifiableIterator it = Iterators.filter((Iterator)Iterators.concat((Iterator)Iterators.singletonIterator((Object)diagram), new DDiagramQuery((DDiagram)diagram).getAllDiagramElements().iterator()), DSemanticDecorator.class);
        while (it.hasNext()) {
            DSemanticDecorator dec = (DSemanticDecorator)it.next();
            if (!(dec.getTarget() instanceof EModelElement)) continue;
            modelelements.add((EModelElement)dec.getTarget());
        }
        return modelelements;
    }

    public List<EObject> getValidsForDiagram(EObject element, DSemanticDecorator containerView) {
        Predicate<EObject> validForClassDiagram = new Predicate<EObject>(){

            public boolean apply(EObject input) {
                return input instanceof EPackage || input instanceof EClassifier;
            }
        };
        return this.allValidSessionElements(element, validForClassDiagram);
    }

    public Collection<EObject> getRelated(EObject firstView, List<EObject> allSelectedViews, DDiagram diag) {
        LinkedHashSet relateds = Sets.newLinkedHashSet();
        for (DSemanticDecorator decorator : Iterables.filter(allSelectedViews, DSemanticDecorator.class)) {
            relateds.addAll(new RelatedElementsSwitch().getRelatedElements(decorator.getTarget()));
        }
        return relateds;
    }

    public Collection<EObject> getRelated(EObject firstView, EObject aView, DDiagram diag) {
        return this.getRelated(firstView, Lists.newArrayList((Object[])new EObject[]{aView}), diag);
    }

    private List<EObject> allValidSessionElements(EObject cur, Predicate<EObject> validForClassDiagram) {
        Session found = SessionManager.INSTANCE.getSession(cur);
        ArrayList result = Lists.newArrayList();
        if (found != null) {
            for (Resource res : found.getSemanticResources()) {
                if (!res.getURI().isPlatformResource() && !res.getURI().isPlatformPlugin()) continue;
                Iterators.addAll((Collection)result, (Iterator)Iterators.filter((Iterator)res.getAllContents(), validForClassDiagram));
            }
        }
        return result;
    }

    public String eResourceName(EObject current) {
        if (current != null && current.eResource() != null) {
            return current.eResource().getURI().lastSegment();
        }
        return null;
    }

    public String toCamelCase(EObject any, String from) {
        if (from != null) {
            StringBuffer buffer = new StringBuffer(from.length());
            for (String word : Splitter.on((CharMatcher)CharMatcher.WHITESPACE).trimResults().split((CharSequence)from)) {
                buffer.append(this.toU1Case(word));
            }
            return buffer.toString();
        }
        return from;
    }

    private String toU1Case(String word) {
        if (word != null && word.length() > 0) {
            return new StringBuilder(word.length()).append(Ascii.toUpperCase((char)word.charAt(0))).append(word.substring(1)).toString();
        }
        return word;
    }

    public String render(EAttribute attr) {
        return new EAttributeServices().render(attr);
    }

    public EAttribute performEdit(EAttribute attr, String editString) {
        return new EAttributeServices().performEdit(attr, editString);
    }

    public String render(EOperation op) {
        return new EOperationServices().render(op);
    }

    public String renderTooltip(EObject current) {
        String result = "";
        Optional<Diagnostic> diag = DiagnosticAttachment.get(current);
        if (diag.isPresent()) {
            result = String.valueOf(result) + this.prettyMessage((Diagnostic)diag.get());
        }
        return result;
    }

    private String prettyMessage(Diagnostic diag) {
        String result = "";
        for (Diagnostic child : diag.getChildren()) {
            result = String.valueOf(result) + "\n" + this.severityLabel(child.getSeverity()) + " : " + child.getMessage();
            result = String.valueOf(result) + this.prettyMessage(child);
        }
        return result;
    }

    private String severityLabel(int severity) {
        switch (severity) {
            case 4: {
                return "ERROR";
            }
            case 8: {
                return "CANCEL";
            }
            case 1: {
                return "INFO";
            }
            case 2: {
                return "WARNING";
            }
            case 0: {
                return "OK";
            }
        }
        return "UNKNOWN";
    }

    public String renderEOperationTooltip(EOperation op) {
        String validationTooltip = this.renderTooltip((EObject)op);
        String operationSignature = new EOperationServices().renderEOperationTooltip(op);
        if (validationTooltip != null && validationTooltip.length() > 0) {
            return String.valueOf(validationTooltip) + "\n" + operationSignature;
        }
        return operationSignature;
    }

    public EOperation performEdit(EOperation op, String editString) {
        return new EOperationServices().performEdit(op, editString);
    }

    public List<ENamedElement> getAllAssociatedElements(EOperation op) {
        return new EOperationServices().getAllAssociatedElements(op);
    }

    @Override
    public String render(EReference ref) {
        return new EReferenceServices().render(ref);
    }

    public String renderEOpposite(EReference ref) {
        if (ref.getEOpposite() != null) {
            return new EReferenceServices().render(ref.getEOpposite());
        }
        return "";
    }

    @Override
    public EReference performEdit(EReference ref, String editString) {
        return new EReferenceServices().performEdit(ref, editString);
    }

    public EClassifier findTypeByName(EObject obj, String name) {
        EClassifier result = this.findTypeByName(this.allRoots(obj), name);
        if (result == null) {
            result = this.findTypeByNameFrom((EObject)EcorePackage.eINSTANCE, name);
        }
        return result;
    }

    public EObject getRootContainer(EObject eObject) {
        return EcoreUtil.getRootContainer((EObject)eObject);
    }

    private EClassifier findTypeByName(Iterable<EObject> roots, String name) {
        for (EObject root : roots) {
            EClassifier result = this.findTypeByNameFrom(root, name);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private EClassifier findTypeByNameFrom(EObject root, String name) {
        if (root instanceof EClassifier && this.nameMatches((EClassifier)root, name)) {
            return (EClassifier)root;
        }
        for (EObject obj : AllContents.of((EObject)root)) {
            if (!(obj instanceof EClassifier) || !this.nameMatches((EClassifier)obj, name)) continue;
            return (EClassifier)obj;
        }
        return null;
    }

    private boolean nameMatches(EClassifier type, String name) {
        if (type != null && type.getName() != null && name != null) {
            return type.getName().trim().equalsIgnoreCase(name.trim());
        }
        return false;
    }

    public Boolean hasError(EObject eObj) {
        if (eObj instanceof EClass || eObj instanceof EStructuralFeature) {
            Diagnostic diag;
            DiagnosticAttachment attachment = DiagnosticAttachment.getAttachment(eObj);
            if (attachment == null) {
                Diagnostic diagnostic = Diagnostician.INSTANCE.validate(eObj);
                attachment = DiagnosticAttachment.getOrCreate(eObj, diagnostic);
            }
            if ((diag = attachment.getDiagnostic()) != null) {
                if (diag.getSeverity() == 4) {
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public Boolean isEDataType(EObject eObj) {
        if (eObj.eClass() == EcorePackage.eINSTANCE.getEDataType()) {
            return true;
        }
        return false;
    }

    public Boolean isDDiagram(EObject any, EObject view) {
        return view instanceof DDiagram;
    }

    public List<EObject> eOperationSemanticElements(EOperation eOp) {
        ArrayList result = Lists.newArrayList((Iterable)Ordering.natural().onResultOf((Function)new Function<EParameter, String>(){

            public String apply(EParameter arg0) {
                return arg0.getName();
            }
        }).sortedCopy((Iterable)eOp.getEParameters()));
        result.add(0, eOp);
        return result;
    }

    public Boolean viewContainerNotSemanticContainer(EObject self, DSemanticDiagram diag, DSemanticDecorator containerView) {
        if (containerView.getTarget() != self.eContainer()) {
            return true;
        }
        return false;
    }

    public Boolean noEOpposite(EReference ref) {
        if (ref.getEOpposite() == null) {
            return true;
        }
        return false;
    }

    public boolean hasNoDocAnnotation(EObject eObj) {
        if (eObj instanceof EModelElement) {
            return EcoreUtil.getDocumentation((EModelElement)((EModelElement)eObj)) == null;
        }
        return true;
    }

    public EEnumLiteral arrowsFillDiamond(EObject any) {
        return DiagramPackage.eINSTANCE.getEdgeArrows().getEEnumLiteral("FillDiamond");
    }

    public EEnumLiteral fontFormatBold(EObject any) {
        return ViewpointPackage.eINSTANCE.getFontFormat().getEEnumLiteral("bold");
    }

    public void reconnectEReferenceSource(EObject element, EObject newValue) {
        if (newValue instanceof EClass && element instanceof EReference) {
            EReference eRef = (EReference)element;
            EClass srcClass = (EClass)newValue;
            if (eRef.eContainer() != srcClass) {
                srcClass.getEStructuralFeatures().add((Object)eRef);
            }
        }
    }

    public void reconnectEReferenceTarget(EObject element, EObject newValue) {
        if (newValue != null && element instanceof EReference) {
            EReference eRef = (EReference)element;
            if (newValue instanceof EClass) {
                EClass targetClass = (EClass)newValue;
                if (eRef.getEType() != newValue) {
                    eRef.setEType((EClassifier)targetClass);
                }
            } else if (newValue instanceof ETypeParameter && eRef.getEType() != newValue) {
                EGenericsServices.setETypeWithGenerics((ETypedElement)eRef, newValue);
            }
        }
    }

    private void createView(final EObject semanticElement, final DSemanticDecorator containerView, final Session session, String containerViewVariable) {
        List<DiagramElementMapping> semanticElementMappings = this.getMappings(semanticElement, containerView, session);
        final CreateView createViewOp = ToolFactory.eINSTANCE.createCreateView();
        Iterator<DiagramElementMapping> iterator = semanticElementMappings.iterator();
        while (iterator.hasNext()) {
            DiagramElementMapping copiedElementMapping;
            DiagramElementMapping tmpCopiedElementMapping = copiedElementMapping = iterator.next();
            createViewOp.setMapping(tmpCopiedElementMapping);
            String containerViewExpression = "var:" + containerViewVariable;
            createViewOp.setContainerViewExpression(containerViewExpression);
            session.getTransactionalEditingDomain().getCommandStack().execute((Command)new RecordingCommand(session.getTransactionalEditingDomain()){

                protected void doExecute() {
                    try {
                        DRepresentation representation = null;
                        if (containerView instanceof DRepresentation) {
                            representation = (DRepresentation)containerView;
                        } else if (containerView instanceof DDiagramElement) {
                            representation = ((DDiagramElement)containerView).getParentDiagram();
                        }
                        CommandContext context = new CommandContext(semanticElement, representation);
                        new CreateViewTask(context, session.getModelAccessor(), createViewOp, session.getInterpreter()).execute();
                    }
                    catch (MetaClassNotFoundException e) {
                        EcoreToolsDesignPlugin.INSTANCE.log((Object)e);
                    }
                    catch (FeatureNotFoundException e) {
                        EcoreToolsDesignPlugin.INSTANCE.log((Object)e);
                    }
                }
            });
        }
    }

    public void paste(EObject container, EObject semanticElement, DSemanticDecorator elementView, DSemanticDecorator containerView) {
        Session session = SessionManager.INSTANCE.getSession(container);
        TransactionalEditingDomain domain = session.getTransactionalEditingDomain();
        Command cmd = AddCommand.create((EditingDomain)domain, (Object)container, null, (Object)semanticElement);
        if (cmd.canExecute()) {
            cmd.execute();
        }
        this.createView(semanticElement, containerView, session, "containerView");
    }

    private List<DiagramElementMapping> getMappings(EObject semanticElement, DSemanticDecorator containerView, Session session) {
        ArrayList<DiagramElementMapping> mappings;
        block5: {
            String domainClass;
            ModelAccessor modelAccessor;
            block4: {
                String domainClass2;
                modelAccessor = session.getModelAccessor();
                mappings = new ArrayList<DiagramElementMapping>();
                if (!(containerView instanceof DSemanticDiagram)) break block4;
                for (DiagramElementMapping mapping : ((DSemanticDiagram)containerView).getDescription().getAllContainerMappings()) {
                    domainClass2 = ((AbstractNodeMapping)mapping).getDomainClass();
                    if (!modelAccessor.eInstanceOf(semanticElement, domainClass2) || mapping.isCreateElements()) continue;
                    mappings.add(mapping);
                }
                for (DiagramElementMapping mapping : ((DSemanticDiagram)containerView).getDescription().getAllNodeMappings()) {
                    domainClass2 = ((AbstractNodeMapping)mapping).getDomainClass();
                    if (!modelAccessor.eInstanceOf(semanticElement, domainClass2) || mapping.isCreateElements()) continue;
                    mappings.add(mapping);
                }
                break block5;
            }
            if (!(containerView instanceof DNodeContainer)) break block5;
            for (DiagramElementMapping mapping : ((DNodeContainer)containerView).getActualMapping().getAllContainerMappings()) {
                domainClass = ((AbstractNodeMapping)mapping).getDomainClass();
                if (!modelAccessor.eInstanceOf(semanticElement, domainClass) || mapping.isCreateElements()) continue;
                mappings.add(mapping);
            }
            for (DiagramElementMapping mapping : ((DNodeContainer)containerView).getActualMapping().getAllNodeMappings()) {
                domainClass = ((AbstractNodeMapping)mapping).getDomainClass();
                if (!modelAccessor.eInstanceOf(semanticElement, domainClass) || mapping.isCreateElements()) continue;
                mappings.add(mapping);
            }
        }
        return mappings;
    }

    public String getClassesTableName(EObject cur) {
        if (cur instanceof EStructuralFeature && ((EStructuralFeature)cur).isDerived()) {
            return "/" + ((EStructuralFeature)cur).getName();
        }
        if (cur instanceof ENamedElement) {
            return ((ENamedElement)cur).getName();
        }
        return cur.eClass().getName();
    }
}

