/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.graphical.edit.policies;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.BendpointLocator;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.PolylineDecoration;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Handle;
import org.eclipse.gef.editpolicies.SelectionHandlesEditPolicy;
import org.eclipse.gef.handles.BendpointMoveHandle;
import org.eclipse.gef.handles.ConnectionEndHandle;
import org.eclipse.gef.handles.ConnectionStartHandle;
import org.eclipse.gef.handles.NonResizableHandleKit;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramEdgeEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramNameEditPart;
import org.eclipse.sirius.diagram.ui.edit.internal.part.DiagramEdgeEditPartOperation;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.AbstractDEdgeNameEditPart;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractEdgeSelectionFeedbackEditPolicy
extends SelectionHandlesEditPolicy {
    private static final int WIDTH_FEEDBACK = 2;

    protected void showSelection() {
        if (this.getEdgeEditPart() == null) {
            return;
        }
        super.showSelection();
        AbstractDiagramEdgeEditPart.ViewEdgeFigure fig = this.getViewEdgeFigure();
        if (fig != null && Display.getCurrent() != null) {
            fig.setForegroundColor(Display.getCurrent().getSystemColor(26));
            fig.setLineWidth(DiagramEdgeEditPartOperation.getLineWidth(this.getEdgeEditPart()) + 2);
            for (Object child : fig.getChildren()) {
                if (!(child instanceof PolylineDecoration)) continue;
                PolylineDecoration decoration = (PolylineDecoration)child;
                decoration.setLineWidth(DiagramEdgeEditPartOperation.getLineWidth(this.getEdgeEditPart()) + 2);
            }
        }
    }

    protected List<Handle> createSelectionHandles() {
        ArrayList list = Lists.newArrayList();
        list.addAll(this.createNameSelectionHandles());
        AbstractDiagramEdgeEditPart edgeEditPart = this.getEdgeEditPart();
        if (edgeEditPart != null) {
            list.add(new ConnectionEndHandle((ConnectionEditPart)edgeEditPart));
            list.add(new ConnectionStartHandle((ConnectionEditPart)edgeEditPart));
            PointList points = ((Connection)edgeEditPart.getFigure()).getPoints();
            int i = 1;
            while (i < points.size() - 1) {
                list.add(new BendpointMoveHandle((ConnectionEditPart)edgeEditPart, i, (Locator)new BendpointLocator((Connection)edgeEditPart.getFigure(), i)));
                ++i;
            }
        }
        return list;
    }

    private AbstractDiagramEdgeEditPart.ViewEdgeFigure getViewEdgeFigure() {
        if (this.getEdgeEditPart() != null && this.getEdgeEditPart().getFigure() instanceof AbstractDiagramEdgeEditPart.ViewEdgeFigure) {
            return (AbstractDiagramEdgeEditPart.ViewEdgeFigure)this.getEdgeEditPart().getFigure();
        }
        return null;
    }

    protected void hideSelection() {
        super.hideSelection();
        this.getEdgeEditPart().refreshForegroundColor();
        this.getEdgeEditPart().refreshLineStyle();
        this.getEdgeEditPart().refreshSourceDecoration();
        this.getEdgeEditPart().refreshTargetDecoration();
    }

    protected List<Handle> createNameSelectionHandles() {
        ArrayList list = Lists.newArrayList();
        for (AbstractDiagramNameEditPart abstractDiagramNameEditPart : this.getEdgeNameEditPart()) {
            if (abstractDiagramNameEditPart == null || abstractDiagramNameEditPart.getEditText() == null || "".equals(abstractDiagramNameEditPart.getEditText())) continue;
            NonResizableHandleKit.addMoveHandle((GraphicalEditPart)abstractDiagramNameEditPart, (List)list);
        }
        for (AbstractDEdgeNameEditPart abstractDEdgeNameEditPart : list) {
            if (!(abstractDEdgeNameEditPart instanceof IFigure)) continue;
            ((IFigure)abstractDEdgeNameEditPart).setForegroundColor(Display.getCurrent().getSystemColor(26));
        }
        return list;
    }

    protected abstract AbstractDiagramEdgeEditPart getEdgeEditPart();

    protected abstract List<AbstractDEdgeNameEditPart> getEdgeNameEditPart();
}

