/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.edit.parts;

import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gmf.runtime.diagram.core.util.ViewType;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.gmf.runtime.diagram.ui.tools.TextDirectEditManager;
import org.eclipse.gmf.runtime.gef.ui.internal.parts.WrapTextCellEditor;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.sirius.diagram.ui.graphical.edit.part.specific.BracketEdgeEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.BundledImageEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.CustomStyleEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DDiagramEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DEdgeBeginNameEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DEdgeEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DEdgeEndNameEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DEdgeNameEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DNode2EditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DNode3EditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DNode4EditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DNodeContainer2EditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DNodeContainerEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DNodeContainerName2EditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DNodeContainerNameEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DNodeContainerViewNodeContainerCompartment2EditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DNodeContainerViewNodeContainerCompartmentEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DNodeEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DNodeList2EditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DNodeListEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DNodeListElementEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DNodeListName2EditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DNodeListNameEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DNodeListViewNodeListCompartment2EditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DNodeListViewNodeListCompartmentEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DNodeNameEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DotEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.EllipseEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.GaugeCompositeEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.LozengeEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.NoteEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.SiriusNoteEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.SiriusTextEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.SquareEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.WorkspaceImageEditPart;
import org.eclipse.sirius.diagram.ui.part.SiriusVisualIDRegistry;
import org.eclipse.sirius.diagram.ui.tools.api.figure.SiriusWrapLabel;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Text;

public class SiriusEditPartFactory
implements EditPartFactory {
    public EditPart createEditPart(EditPart context, Object model) {
        if (model instanceof View) {
            View view = (View)model;
            switch (SiriusVisualIDRegistry.getVisualID(view)) {
                case 1000: {
                    return new DDiagramEditPart(view);
                }
                case 2001: {
                    return new DNodeEditPart(view);
                }
                case 5001: 
                case 5002: 
                case 5003: 
                case 5010: {
                    return new DNodeNameEditPart(view);
                }
                case 2002: {
                    return new DNodeContainerEditPart(view);
                }
                case 5006: {
                    return new DNodeContainerNameEditPart(view);
                }
                case 2003: {
                    return new DNodeListEditPart(view);
                }
                case 5007: {
                    return new DNodeListNameEditPart(view);
                }
                case 3001: {
                    return new DNode2EditPart(view);
                }
                case 3004: {
                    return new BundledImageEditPart(view);
                }
                case 3002: {
                    return new DotEditPart(view);
                }
                case 3006: {
                    return new GaugeCompositeEditPart(view);
                }
                case 3003: {
                    return new SquareEditPart(view);
                }
                case 3016: {
                    return new EllipseEditPart(view);
                }
                case 3017: {
                    return new LozengeEditPart(view);
                }
                case 3005: {
                    return new WorkspaceImageEditPart(view);
                }
                case 3013: {
                    return new NoteEditPart(view);
                }
                case 3014: {
                    return new CustomStyleEditPart(view);
                }
                case 3007: {
                    return new DNode3EditPart(view);
                }
                case 3008: {
                    return new DNodeContainer2EditPart(view);
                }
                case 5005: {
                    return new DNodeContainerName2EditPart(view);
                }
                case 3009: {
                    return new DNodeList2EditPart(view);
                }
                case 5004: {
                    return new DNodeListName2EditPart(view);
                }
                case 3010: {
                    return new DNodeListElementEditPart(view);
                }
                case 3012: {
                    return new DNode4EditPart(view);
                }
                case 7001: {
                    return new DNodeContainerViewNodeContainerCompartmentEditPart(view);
                }
                case 7002: {
                    return new DNodeContainerViewNodeContainerCompartment2EditPart(view);
                }
                case 7003: {
                    return new DNodeListViewNodeListCompartmentEditPart(view);
                }
                case 7004: {
                    return new DNodeListViewNodeListCompartment2EditPart(view);
                }
                case 4001: {
                    return new DEdgeEditPart(view);
                }
                case 6001: {
                    return new DEdgeNameEditPart(view);
                }
                case 6002: {
                    return new DEdgeBeginNameEditPart(view);
                }
                case 6003: {
                    return new DEdgeEndNameEditPart(view);
                }
                case 4002: {
                    return new BracketEdgeEditPart(view);
                }
                case -1: {
                    if (ViewType.NOTE.equals(view.getType())) {
                        return new SiriusNoteEditPart(view);
                    }
                    if (!ViewType.TEXT.equals(view.getType())) break;
                    return new SiriusTextEditPart(view);
                }
            }
        }
        return this.createUnrecognizedEditPart(context, model);
    }

    private EditPart createUnrecognizedEditPart(EditPart context, Object model) {
        return null;
    }

    public static CellEditorLocator getTextCellEditorLocator(ITextAwareEditPart source) {
        if (source.getFigure() instanceof SiriusWrapLabel) {
            return new TextCellEditorLocator((SiriusWrapLabel)source.getFigure());
        }
        return new LabelCellEditorLocator((Label)source.getFigure());
    }

    public static Class getTextCellEditorClass(GraphicalEditPart source) {
        if (source.getFigure() instanceof SiriusWrapLabel) {
            return WrapTextCellEditor.class;
        }
        return TextDirectEditManager.getTextCellEditorClass((GraphicalEditPart)source);
    }

    private static class LabelCellEditorLocator
    implements CellEditorLocator {
        private final Label label;

        public LabelCellEditorLocator(Label label) {
            this.label = label;
        }

        public Label getLabel() {
            return this.label;
        }

        public void relocate(CellEditor celleditor) {
            Text text = (Text)celleditor.getControl();
            Rectangle rect = new Rectangle(this.getLabel().getTextBounds());
            this.getLabel().translateToAbsolute((Translatable)rect);
            int avr = FigureUtilities.getFontMetrics((Font)text.getFont()).getAverageCharWidth();
            rect.setSize(new Dimension(text.computeSize(-1, -1)).expand(avr * 2, 0));
            if (!rect.equals((Object)new Rectangle(text.getBounds()))) {
                text.setBounds(rect.x, rect.y, rect.width, rect.height);
            }
        }
    }

    private static class TextCellEditorLocator
    implements CellEditorLocator {
        private final SiriusWrapLabel wrapLabel;

        public TextCellEditorLocator(SiriusWrapLabel wrapLabel) {
            this.wrapLabel = wrapLabel;
        }

        public SiriusWrapLabel getWrapLabel() {
            return this.wrapLabel;
        }

        public void relocate(CellEditor celleditor) {
            Text text = (Text)celleditor.getControl();
            Rectangle rect = new Rectangle(this.getWrapLabel().getTextBounds());
            this.getWrapLabel().translateToAbsolute((Translatable)rect);
            if (this.getWrapLabel().isTextWrapped() && this.getWrapLabel().getText().length() > 0) {
                rect.setSize(new Dimension(text.computeSize(rect.width, -1)));
            } else {
                int avr = FigureUtilities.getFontMetrics((Font)text.getFont()).getAverageCharWidth();
                rect.setSize(new Dimension(text.computeSize(-1, -1)).expand(avr * 2, 0));
            }
            if (!rect.equals((Object)new Rectangle(text.getBounds()))) {
                text.setBounds(rect.x, rect.y, rect.width + 1, rect.height);
            }
        }
    }
}

