/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.edit.parts.refresh;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramNameEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractNotSelectableShapeNodeEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IAbstractDiagramNodeEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramElementEditPart;
import org.eclipse.sirius.diagram.ui.edit.internal.part.DiagramElementEditPartOperation;
import org.eclipse.sirius.diagram.ui.tools.api.figure.SiriusWrapLabel;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.ecore.extender.business.api.permission.PermissionAuthorityRegistry;
import org.eclipse.sirius.viewpoint.ViewpointPackage;

public class LabelAndIconRefresher
implements NotificationListener {
    private IGraphicalEditPart graphicalEditPart;

    public LabelAndIconRefresher(IGraphicalEditPart graphicalEditPart) {
        this.graphicalEditPart = graphicalEditPart;
        DiagramEventBroker broker = DiagramEventBroker.getInstance((TransactionalEditingDomain)graphicalEditPart.getEditingDomain());
        DDiagramElement dDiagramElement = this.getDDiagramElement(graphicalEditPart);
        if (broker != null && dDiagramElement != null) {
            for (EObject semanticElement : dDiagramElement.getSemanticElements()) {
                broker.addNotificationListener(semanticElement, (NotificationListener)this);
            }
            broker.addNotificationListener((EObject)dDiagramElement, (EStructuralFeature)ViewpointPackage.Literals.DREPRESENTATION_ELEMENT__SEMANTIC_ELEMENTS, (NotificationListener)this);
        }
    }

    private DDiagramElement getDDiagramElement(IGraphicalEditPart graphicalEditPart) {
        DDiagramElement dDiagramElement = null;
        if (graphicalEditPart instanceof IDiagramElementEditPart) {
            dDiagramElement = ((IDiagramElementEditPart)graphicalEditPart).resolveDiagramElement();
        } else if (graphicalEditPart.getParent() instanceof IDiagramElementEditPart) {
            dDiagramElement = ((IDiagramElementEditPart)graphicalEditPart.getParent()).resolveDiagramElement();
        }
        return dDiagramElement;
    }

    public void notifyChanged(Notification notification) {
        if (this.graphicalEditPart != null && this.graphicalEditPart.isActive()) {
            DDiagramElement dDiagramElement = this.getDDiagramElement(this.graphicalEditPart);
            IPermissionAuthority auth = PermissionAuthorityRegistry.getDefault().getPermissionAuthority(this.graphicalEditPart.getEditingDomain().getResourceSet());
            if (dDiagramElement != null && dDiagramElement.getSemanticElements().contains(notification.getNotifier()) && auth.canEditInstance((EObject)dDiagramElement)) {
                this.refreshLabelAndIcon(dDiagramElement);
            } else if (ViewpointPackage.Literals.DREPRESENTATION_ELEMENT__SEMANTIC_ELEMENTS == notification.getFeature()) {
                DiagramEventBroker broker = DiagramEventBroker.getInstance((TransactionalEditingDomain)this.graphicalEditPart.getEditingDomain());
                if (notification.getEventType() == 3 || notification.getEventType() == 5) {
                    Object newValue = notification.getNewValue();
                    if (newValue instanceof Collection) {
                        for (Object newVal : (Collection)newValue) {
                            if (!(newVal instanceof EObject)) continue;
                            broker.addNotificationListener((EObject)newVal, (NotificationListener)this);
                        }
                    } else if (newValue instanceof EObject) {
                        broker.addNotificationListener((EObject)newValue, (NotificationListener)this);
                    }
                } else if (notification.getEventType() == 4 || notification.getEventType() == 6) {
                    Object oldValue = notification.getOldValue();
                    if (oldValue instanceof Collection) {
                        for (Object oldVal : (Collection)oldValue) {
                            if (!(oldVal instanceof EObject)) continue;
                            broker.removeNotificationListener((EObject)oldVal, (NotificationListener)this);
                        }
                    } else if (oldValue instanceof EObject) {
                        broker.removeNotificationListener((EObject)oldValue, (NotificationListener)this);
                    }
                }
            }
        }
    }

    private void refreshLabelAndIcon(DDiagramElement dDiagramElement) {
        EditPart parent;
        SiriusWrapLabel siriusWrapLabel = null;
        IDiagramElementEditPart diagramElementEditPart = null;
        if (this.graphicalEditPart instanceof AbstractDiagramNameEditPart) {
            if (this.graphicalEditPart.getFigure() instanceof SiriusWrapLabel) {
                siriusWrapLabel = (SiriusWrapLabel)this.graphicalEditPart.getFigure();
                diagramElementEditPart = (AbstractDiagramNameEditPart)this.graphicalEditPart;
            }
        } else if (this.graphicalEditPart instanceof AbstractNotSelectableShapeNodeEditPart && (parent = this.graphicalEditPart.getParent()) instanceof IAbstractDiagramNodeEditPart) {
            diagramElementEditPart = (IAbstractDiagramNodeEditPart)parent;
            siriusWrapLabel = ((IAbstractDiagramNodeEditPart)diagramElementEditPart).getNodeLabel();
        }
        if (diagramElementEditPart != null) {
            DiagramElementEditPartOperation.refreshLabelAndIcon(diagramElementEditPart, dDiagramElement, siriusWrapLabel);
        }
    }

    public void dispose() {
        DDiagramElement dDiagramElement;
        DiagramEventBroker broker = DiagramEventBroker.getInstance((TransactionalEditingDomain)this.graphicalEditPart.getEditingDomain());
        if (broker != null && (dDiagramElement = this.getDDiagramElement(this.graphicalEditPart)) != null) {
            broker.removeNotificationListener((EObject)dDiagramElement, (Object)ViewpointPackage.Literals.DREPRESENTATION_ELEMENT__SEMANTIC_ELEMENTS, (NotificationListener)this);
            for (EObject semanticElement : dDiagramElement.getSemanticElements()) {
                broker.removeNotificationListener(semanticElement, (NotificationListener)this);
            }
        }
        this.graphicalEditPart = null;
    }
}

