/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.refresh.listeners;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.RoutingStyle;
import org.eclipse.sirius.business.api.session.ModelChangeTrigger;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionEventBroker;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.EdgeStyle;
import org.eclipse.sirius.diagram.ui.business.api.view.SiriusGMFHelper;
import org.eclipse.sirius.diagram.ui.business.internal.operation.AbstractModelChangeOperation;
import org.eclipse.sirius.diagram.ui.internal.operation.CenterEdgeEndModelChangeOperation;
import org.eclipse.sirius.diagram.ui.internal.refresh.listeners.RefreshEdgeLayoutNotificationFilter;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;

public class EdgeLayoutUpdaterModelChangeTrigger
implements ModelChangeTrigger {
    public static final int PRIORITY = 6;
    private TransactionalEditingDomain domain;
    private SessionEventBroker eventBroker;
    private RefreshEdgeLayoutNotificationFilter refreshEdgeLayoutNotificationFilter;

    public EdgeLayoutUpdaterModelChangeTrigger(Session session, DDiagram dDiagram) {
        this.domain = session.getTransactionalEditingDomain();
        this.eventBroker = session.getEventBroker();
        this.refreshEdgeLayoutNotificationFilter = new RefreshEdgeLayoutNotificationFilter(dDiagram);
        this.eventBroker.addLocalTrigger((NotificationFilter)this.refreshEdgeLayoutNotificationFilter, (ModelChangeTrigger)this);
    }

    public Option<Command> localChangesAboutToCommit(Collection<Notification> notifications) {
        EdgeLayoutUpdaterCommand command = null;
        HashSet<Edge> edgesWithCreatedCommand = new HashSet<Edge>();
        ArrayList<AbstractModelChangeOperation<Void>> operations = new ArrayList<AbstractModelChangeOperation<Void>>();
        for (Notification notification : notifications) {
            Object notifier = notification.getNotifier();
            Edge gmfEdge = null;
            if (notifier instanceof DEdge) {
                gmfEdge = SiriusGMFHelper.getGmfEdge((DDiagramElement)((DEdge)notifier));
            } else if (notifier instanceof EdgeStyle) {
                EObject container = ((EdgeStyle)notifier).eContainer();
                if (container instanceof DEdge) {
                    gmfEdge = SiriusGMFHelper.getGmfEdge((DDiagramElement)((DEdge)container));
                }
            } else if (notifier instanceof RoutingStyle) {
                EObject container = ((RoutingStyle)notifier).eContainer();
                if (container instanceof Edge) {
                    gmfEdge = (Edge)container;
                }
            } else if (notifier instanceof Diagram && notification.getNewValue() instanceof Edge) {
                gmfEdge = (Edge)notification.getNewValue();
            }
            if (gmfEdge == null || !edgesWithCreatedCommand.add(gmfEdge)) continue;
            boolean useFigure = this.refreshEdgeLayoutNotificationFilter.otherNotificationsAreIndirectlyConcerned(notification, notifications);
            CenterEdgeEndModelChangeOperation operation = new CenterEdgeEndModelChangeOperation(gmfEdge, useFigure);
            operations.add(operation);
        }
        if (!operations.isEmpty()) {
            command = new EdgeLayoutUpdaterCommand(this.domain, operations);
        }
        return Options.newSome(command);
    }

    public int priority() {
        return 6;
    }

    public void dispose() {
        this.refreshEdgeLayoutNotificationFilter = null;
        this.eventBroker.removeLocalTrigger((ModelChangeTrigger)this);
        this.eventBroker = null;
        this.domain = null;
    }

    private static final class EdgeLayoutUpdaterCommand
    extends RecordingCommand {
        private Collection<AbstractModelChangeOperation<Void>> operations;

        public EdgeLayoutUpdaterCommand(TransactionalEditingDomain domain, Collection<AbstractModelChangeOperation<Void>> operations) {
            super(domain);
            this.operations = operations;
        }

        protected void doExecute() {
            for (AbstractModelChangeOperation<Void> operation : this.operations) {
                operation.execute();
            }
        }
    }
}

