/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.refresh.listeners;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.Size;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.WorkspaceImage;
import org.eclipse.sirius.diagram.description.style.NodeStyleDescription;
import org.eclipse.sirius.diagram.description.style.WorkspaceImageDescription;
import org.eclipse.sirius.diagram.ui.business.api.view.SiriusGMFHelper;
import org.eclipse.sirius.diagram.ui.business.internal.query.WorkspaceImageQuery;
import org.eclipse.sirius.diagram.ui.provider.Messages;

public class GMFBoundsUpdater
extends ResourceSetListenerImpl {
    private DDiagram dDiagram;

    public GMFBoundsUpdater(TransactionalEditingDomain domain, DDiagram dDiagram) {
        super(NotificationFilter.NOT_TOUCH.and(NotificationFilter.createFeatureFilter((EStructuralFeature)DiagramPackage.eINSTANCE.getDNode_OwnedStyle())).or(NotificationFilter.createFeatureFilter((EStructuralFeature)DiagramPackage.eINSTANCE.getDDiagramElementContainer_OwnedStyle())).or(NotificationFilter.createFeatureFilter((EStructuralFeature)DiagramPackage.eINSTANCE.getDNode_Height())).or(NotificationFilter.createFeatureFilter((EStructuralFeature)DiagramPackage.eINSTANCE.getDNode_Width())));
        this.dDiagram = dDiagram;
        domain.addResourceSetListener((ResourceSetListener)this);
    }

    public boolean isPrecommitOnly() {
        return true;
    }

    public boolean isAggregatePrecommitListener() {
        return true;
    }

    public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
        ResizeImageCommand cmd = null;
        HashSet<DDiagramElement> elementsToResize = new HashSet<DDiagramElement>();
        for (Notification notification : event.getNotifications()) {
            DDiagramElement dDiagramElement;
            DDiagram parentDDiagram;
            if (!(notification.getNotifier() instanceof DDiagramElement) || (parentDDiagram = (dDiagramElement = (DDiagramElement)notification.getNotifier()).getParentDiagram()) == null || !parentDDiagram.equals(this.dDiagram) || !this.isStyleResize(notification, dDiagramElement)) continue;
            elementsToResize.add(dDiagramElement);
        }
        if (!elementsToResize.isEmpty()) {
            cmd = new ResizeImageCommand(this.getTarget(), this.dDiagram, elementsToResize);
        }
        return cmd;
    }

    private boolean isStyleResize(Notification notification, DDiagramElement dDiagramElement) {
        boolean isStyleResize = false;
        if (notification.getNewValue() instanceof WorkspaceImage && notification.getOldValue() instanceof WorkspaceImage) {
            WorkspaceImage workspaceImageNewValue = (WorkspaceImage)notification.getNewValue();
            WorkspaceImage workspaceImageOldValue = (WorkspaceImage)notification.getOldValue();
            isStyleResize = this.isWorkspaceImageStyleResized(workspaceImageNewValue, workspaceImageOldValue, dDiagramElement);
        } else if (notification.getNewValue() instanceof Integer && notification.getOldValue() instanceof Integer) {
            isStyleResize = !notification.getNewValue().equals(notification.getOldValue());
        }
        return isStyleResize;
    }

    private boolean isWorkspaceImageStyleResized(WorkspaceImage workspaceImageNewValue, WorkspaceImage workspaceImageOldValue, DDiagramElement dDiagramElement) {
        boolean differentPath = true;
        if (workspaceImageNewValue != null && workspaceImageOldValue != null && workspaceImageNewValue.getWorkspacePath() != null && workspaceImageNewValue.getWorkspacePath().equals(workspaceImageOldValue.getWorkspacePath())) {
            differentPath = false;
        }
        boolean isWorkspaceImageStyleResized = dDiagramElement.getStyle().getDescription() instanceof WorkspaceImageDescription && ((WorkspaceImageDescription)dDiagramElement.getStyle().getDescription()).getSizeComputationExpression().equals("-1") && differentPath;
        return isWorkspaceImageStyleResized;
    }

    public void dispose() {
        if (this.getTarget() != null) {
            this.getTarget().removeResourceSetListener((ResourceSetListener)this);
        }
        this.dDiagram = null;
    }

    private static class ResizeImageCommand
    extends RecordingCommand {
        private DDiagram diagram;
        private Collection<DDiagramElement> elementsToResize;

        public ResizeImageCommand(TransactionalEditingDomain domain, DDiagram diagram, Collection<DDiagramElement> elementsToResize) {
            super(domain, Messages.ResizeImageCommand_label);
            this.diagram = diagram;
            this.elementsToResize = elementsToResize;
        }

        protected void doExecute() {
            Session session = SessionManager.INSTANCE.getSession(((DSemanticDiagram)this.diagram).getTarget());
            for (DDiagramElement element : this.elementsToResize) {
                Node node = SiriusGMFHelper.getGmfNode(element, session);
                Size size = (Size)node.getLayoutConstraint();
                if (element.getStyle().getDescription() instanceof WorkspaceImageDescription) {
                    Dimension defaultDimension = new WorkspaceImageQuery((WorkspaceImageDescription)element.getStyle().getDescription()).getDefaultDimension();
                    size.setHeight(defaultDimension.height);
                    size.setWidth(defaultDimension.width);
                    continue;
                }
                if (!(element.getStyle().getDescription() instanceof NodeStyleDescription)) continue;
                size.setHeight(((DNode)element).getHeight() * 10);
                size.setWidth(((DNode)element).getWidth() * 10);
            }
        }
    }
}

