/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.api.figure.locator;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gmf.runtime.diagram.ui.figures.BorderItemLocator;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;

public class DBorderItemLocator
extends BorderItemLocator {
    private static final int NB_SIDES = 4;
    private Dimension leftTopOffset;
    private Dimension rightBottomOffset;
    private boolean located;
    private boolean borderItemHasMoved;
    private List<IFigure> figuresToIgnoreDuringNextRelocate = Lists.newArrayList();

    public DBorderItemLocator(IFigure parentFigure) {
        super(parentFigure);
    }

    public DBorderItemLocator(IFigure borderItem, IFigure parentFigure, Rectangle constraint) {
        super(borderItem, parentFigure, constraint);
    }

    public DBorderItemLocator(IFigure parentFigure, int preferredSide) {
        super(parentFigure, preferredSide);
    }

    public void setRightBottomOffset(Dimension rightBottomOffset) {
        this.rightBottomOffset = rightBottomOffset;
    }

    public Dimension getRightBottomOffset() {
        if (this.rightBottomOffset != null) {
            return this.rightBottomOffset;
        }
        return this.getBorderItemOffset();
    }

    public void setLeftTopOffset(Dimension leftTopOffset) {
        this.leftTopOffset = leftTopOffset;
    }

    public Dimension getLeftTopOffset() {
        if (this.leftTopOffset != null) {
            return this.leftTopOffset;
        }
        return this.getBorderItemOffset();
    }

    protected Point getPreferredLocation(IFigure borderItem) {
        Point constraintLocation = this.getConstraint().getLocation();
        Point ptAbsoluteLocation = this.getAbsoluteToBorder(constraintLocation);
        return ptAbsoluteLocation;
    }

    public void relocate(IFigure borderItem) {
        Rectangle parentBounds = this.getParentFigure().getBounds().getCopy();
        if (parentBounds.x != 0 || parentBounds.y != 0 || parentBounds.width > 0 || parentBounds.height > 0) {
            Dimension size = this.getSize(borderItem);
            Rectangle rectSuggested = new Rectangle(this.getPreferredLocation(borderItem), size);
            if (this.borderItemHasMoved) {
                int closestSide = DBorderItemLocator.findClosestSideOfParent(rectSuggested, this.getParentBorder());
                this.setPreferredSideOfParent(closestSide);
                this.setCurrentSideOfParent(closestSide);
                this.borderItemHasMoved = false;
            } else {
                this.figuresToIgnoreDuringNextRelocate.clear();
            }
            Point ptNewLocation = this.locateOnBorder(rectSuggested, this.getCurrentSideOfParent(), 0, borderItem, this.figuresToIgnoreDuringNextRelocate, new ArrayList<IFigure>());
            borderItem.setLocation(ptNewLocation);
            this.figuresToIgnoreDuringNextRelocate.clear();
            borderItem.setSize(size);
            this.located = true;
        }
    }

    protected Point locateOnBorder(Point suggestedLocation, int suggestedSide, int circuitCount, IFigure borderItem) {
        ArrayList figuresToIgnore = Lists.newArrayList();
        figuresToIgnore.add(borderItem);
        return this.locateOnBorder(new Rectangle(suggestedLocation, this.getSize(borderItem)), suggestedSide, circuitCount, borderItem, figuresToIgnore, new ArrayList<IFigure>());
    }

    protected Point locateOnBorder(Rectangle suggestedLocation, int suggestedSide, int circuitCount, IFigure borderItem, Collection<IFigure> portsFiguresToIgnore, List<IFigure> additionalFiguresForConflictDetection) {
        Point recommendedLocation = this.locateOnParent(suggestedLocation, suggestedSide, borderItem);
        Rectangle newRecommendedLocationBounds = new Rectangle(recommendedLocation, suggestedLocation.getSize());
        if (circuitCount < 4 && this.conflicts(newRecommendedLocationBounds, borderItem, portsFiguresToIgnore, additionalFiguresForConflictDetection).some()) {
            recommendedLocation = suggestedSide == 8 ? this.locateOnWestBorder(newRecommendedLocationBounds, circuitCount, borderItem, portsFiguresToIgnore, additionalFiguresForConflictDetection) : (suggestedSide == 4 ? this.locateOnSouthBorder(newRecommendedLocationBounds, circuitCount, borderItem, portsFiguresToIgnore, additionalFiguresForConflictDetection) : (suggestedSide == 16 ? this.locateOnEastBorder(newRecommendedLocationBounds, circuitCount, borderItem, portsFiguresToIgnore, additionalFiguresForConflictDetection) : this.locateOnNorthBorder(newRecommendedLocationBounds, circuitCount, borderItem, portsFiguresToIgnore, additionalFiguresForConflictDetection)));
        }
        return recommendedLocation;
    }

    protected Point locateOnSouthBorder(Rectangle recommendedLocation, int circuitCount, IFigure borderItem, Collection<IFigure> portsFiguresToIgnore, List<IFigure> additionalFiguresForConflictDetection) {
        Dimension borderItemSize = recommendedLocation.getSize();
        Point resultLocation = null;
        Point rightTestPoint = recommendedLocation.getLocation();
        Point leftTestPoint = recommendedLocation.getLocation();
        boolean isStillFreeSpaceToTheRight = true;
        boolean isStillFreeSpaceToTheLeft = true;
        int rightVerticalGap = 0;
        int leftVerticalGap = 0;
        Point recommendedLocationForEast = recommendedLocation.getLocation();
        while (resultLocation == null && (isStillFreeSpaceToTheRight || isStillFreeSpaceToTheLeft)) {
            Option<Rectangle> optionalConflictingRectangle;
            if (isStillFreeSpaceToTheRight) {
                rightTestPoint.x += rightVerticalGap;
                optionalConflictingRectangle = this.conflicts(new Rectangle(rightTestPoint, borderItemSize), borderItem, portsFiguresToIgnore, additionalFiguresForConflictDetection);
                if (optionalConflictingRectangle.some()) {
                    rightVerticalGap = ((Rectangle)optionalConflictingRectangle.get()).x + ((Rectangle)optionalConflictingRectangle.get()).width + 1 - rightTestPoint.x;
                    if (rightTestPoint.x + rightVerticalGap + borderItemSize.width > this.getParentBorder().getBottomRight().x) {
                        isStillFreeSpaceToTheRight = false;
                        if (circuitCount == 3) {
                            resultLocation = ((Rectangle)optionalConflictingRectangle.get()).getTopLeft();
                        } else {
                            recommendedLocationForEast = new Point(rightTestPoint.x + rightVerticalGap, ((Rectangle)optionalConflictingRectangle.get()).y - borderItemSize.height - 1);
                        }
                    }
                } else {
                    resultLocation = rightTestPoint;
                }
            }
            if (!isStillFreeSpaceToTheLeft || resultLocation != null) continue;
            leftTestPoint.x -= leftVerticalGap;
            optionalConflictingRectangle = this.conflicts(new Rectangle(leftTestPoint, borderItemSize), borderItem, portsFiguresToIgnore, additionalFiguresForConflictDetection);
            if (optionalConflictingRectangle.some()) {
                leftVerticalGap = leftTestPoint.x - (((Rectangle)optionalConflictingRectangle.get()).x - borderItemSize.width - 1);
                if (leftTestPoint.x - leftVerticalGap >= this.getParentBorder().getTopLeft().x) continue;
                isStillFreeSpaceToTheLeft = false;
                continue;
            }
            resultLocation = leftTestPoint;
        }
        if (resultLocation == null) {
            resultLocation = this.locateOnBorder(new Rectangle(recommendedLocationForEast, borderItemSize), 16, circuitCount + 1, borderItem, portsFiguresToIgnore, additionalFiguresForConflictDetection);
        }
        return resultLocation;
    }

    protected Point locateOnNorthBorder(Rectangle recommendedLocation, int circuitCount, IFigure borderItem, Collection<IFigure> portsFiguresToIgnore, List<IFigure> additionalFiguresForConflictDetection) {
        Dimension borderItemSize = recommendedLocation.getSize();
        Point resultLocation = null;
        Point rightTestPoint = recommendedLocation.getLocation();
        Point leftTestPoint = recommendedLocation.getLocation();
        boolean isStillFreeSpaceToTheRight = true;
        boolean isStillFreeSpaceToTheLeft = true;
        int rightVerticalGap = 0;
        int leftVerticalGap = 0;
        Point recommendedLocationForWest = recommendedLocation.getLocation();
        while (resultLocation == null && (isStillFreeSpaceToTheRight || isStillFreeSpaceToTheLeft)) {
            Option<Rectangle> optionalConflictingRectangle;
            if (isStillFreeSpaceToTheRight) {
                rightTestPoint.x += rightVerticalGap;
                optionalConflictingRectangle = this.conflicts(new Rectangle(rightTestPoint, borderItemSize), borderItem, portsFiguresToIgnore, additionalFiguresForConflictDetection);
                if (optionalConflictingRectangle.some()) {
                    rightVerticalGap = ((Rectangle)optionalConflictingRectangle.get()).x + ((Rectangle)optionalConflictingRectangle.get()).width + 1 - rightTestPoint.x;
                    if (rightTestPoint.x + rightVerticalGap + borderItemSize.width > this.getParentBorder().getBottomRight().x) {
                        isStillFreeSpaceToTheRight = false;
                    }
                } else {
                    resultLocation = rightTestPoint;
                }
            }
            if (!isStillFreeSpaceToTheLeft || resultLocation != null) continue;
            leftTestPoint.x -= leftVerticalGap;
            optionalConflictingRectangle = this.conflicts(new Rectangle(leftTestPoint, borderItemSize), borderItem, portsFiguresToIgnore, additionalFiguresForConflictDetection);
            if (optionalConflictingRectangle.some()) {
                leftVerticalGap = leftTestPoint.x - (((Rectangle)optionalConflictingRectangle.get()).x - borderItemSize.width - 1);
                if (leftTestPoint.x - leftVerticalGap >= this.getParentBorder().getTopLeft().x) continue;
                isStillFreeSpaceToTheLeft = false;
                if (circuitCount == 3) {
                    resultLocation = ((Rectangle)optionalConflictingRectangle.get()).getTopLeft();
                    continue;
                }
                recommendedLocationForWest = new Point(leftTestPoint.x - leftVerticalGap, ((Rectangle)optionalConflictingRectangle.get()).y + ((Rectangle)optionalConflictingRectangle.get()).height + 1);
                continue;
            }
            resultLocation = leftTestPoint;
        }
        if (resultLocation == null) {
            resultLocation = this.locateOnBorder(new Rectangle(recommendedLocationForWest, borderItemSize), 8, circuitCount + 1, borderItem, portsFiguresToIgnore, additionalFiguresForConflictDetection);
        }
        return resultLocation;
    }

    protected Point locateOnWestBorder(Rectangle recommendedLocation, int circuitCount, IFigure borderItem, Collection<IFigure> portsFiguresToIgnore, List<IFigure> additionalFiguresForConflictDetection) {
        Dimension borderItemSize = recommendedLocation.getSize();
        Point resultLocation = null;
        Point belowTestPoint = recommendedLocation.getLocation();
        Point aboveTestPoint = recommendedLocation.getLocation();
        boolean isStillFreeSpaceAbove = true;
        boolean isStillFreeSpaceBelow = true;
        int belowVerticalGap = 0;
        int aboveVerticalGap = 0;
        Point recommendedLocationForSouth = recommendedLocation.getLocation();
        while (resultLocation == null && (isStillFreeSpaceAbove || isStillFreeSpaceBelow)) {
            Option<Rectangle> optionalConflictingRectangle;
            if (isStillFreeSpaceBelow) {
                belowTestPoint.y += belowVerticalGap;
                optionalConflictingRectangle = this.conflicts(new Rectangle(belowTestPoint, borderItemSize), borderItem, portsFiguresToIgnore, additionalFiguresForConflictDetection);
                if (optionalConflictingRectangle.some()) {
                    belowVerticalGap = ((Rectangle)optionalConflictingRectangle.get()).y + ((Rectangle)optionalConflictingRectangle.get()).height - belowTestPoint.y + 1;
                    if (belowTestPoint.y + belowVerticalGap + borderItemSize.height > this.getParentBorder().getBottomLeft().y) {
                        isStillFreeSpaceBelow = false;
                        if (circuitCount == 3) {
                            resultLocation = ((Rectangle)optionalConflictingRectangle.get()).getTopLeft();
                        } else {
                            recommendedLocationForSouth = new Point(belowTestPoint.x + ((Rectangle)optionalConflictingRectangle.get()).width + 1, belowTestPoint.y + belowVerticalGap);
                        }
                    }
                } else {
                    resultLocation = belowTestPoint;
                }
            }
            if (!isStillFreeSpaceAbove || resultLocation != null) continue;
            aboveTestPoint.y -= aboveVerticalGap;
            optionalConflictingRectangle = this.conflicts(new Rectangle(aboveTestPoint, borderItemSize), borderItem, portsFiguresToIgnore, additionalFiguresForConflictDetection);
            if (optionalConflictingRectangle.some()) {
                aboveVerticalGap = aboveTestPoint.y - (((Rectangle)optionalConflictingRectangle.get()).y - borderItemSize.height - 1);
                if (aboveTestPoint.y - aboveVerticalGap >= this.getParentBorder().getTopRight().y) continue;
                isStillFreeSpaceAbove = false;
                continue;
            }
            resultLocation = aboveTestPoint;
        }
        if (resultLocation == null) {
            resultLocation = this.locateOnBorder(new Rectangle(recommendedLocationForSouth, borderItemSize), 4, circuitCount + 1, borderItem, portsFiguresToIgnore, additionalFiguresForConflictDetection);
        }
        return resultLocation;
    }

    protected Point locateOnEastBorder(Rectangle recommendedLocation, int circuitCount, IFigure borderItem, Collection<IFigure> portsFiguresToIgnore, List<IFigure> additionalFiguresForConflictDetection) {
        Dimension borderItemSize = recommendedLocation.getSize();
        Point resultLocation = null;
        Point belowTestPoint = recommendedLocation.getLocation();
        Point aboveTestPoint = recommendedLocation.getLocation();
        boolean isStillFreeSpaceAbove = true;
        boolean isStillFreeSpaceBelow = true;
        int belowVerticalGap = 0;
        int aboveVerticalGap = 0;
        Point recommendedLocationForNorth = recommendedLocation.getLocation();
        while (resultLocation == null && (isStillFreeSpaceAbove || isStillFreeSpaceBelow)) {
            Option<Rectangle> optionalConflictingRectangle;
            if (isStillFreeSpaceBelow) {
                belowTestPoint.y += belowVerticalGap;
                optionalConflictingRectangle = this.conflicts(new Rectangle(belowTestPoint, borderItemSize), borderItem, portsFiguresToIgnore, additionalFiguresForConflictDetection);
                if (optionalConflictingRectangle.some()) {
                    belowVerticalGap = ((Rectangle)optionalConflictingRectangle.get()).y + ((Rectangle)optionalConflictingRectangle.get()).height - belowTestPoint.y + 1;
                    if (belowTestPoint.y + belowVerticalGap + borderItemSize.height > this.getParentBorder().getBottomLeft().y) {
                        isStillFreeSpaceBelow = false;
                    }
                } else {
                    resultLocation = belowTestPoint;
                }
            }
            if (!isStillFreeSpaceAbove || resultLocation != null) continue;
            aboveTestPoint.y -= aboveVerticalGap;
            optionalConflictingRectangle = this.conflicts(new Rectangle(aboveTestPoint, borderItemSize), borderItem, portsFiguresToIgnore, additionalFiguresForConflictDetection);
            if (optionalConflictingRectangle.some()) {
                aboveVerticalGap = aboveTestPoint.y - (((Rectangle)optionalConflictingRectangle.get()).y - borderItemSize.height - 1);
                if (aboveTestPoint.y - aboveVerticalGap >= this.getParentBorder().getTopRight().y) continue;
                isStillFreeSpaceAbove = false;
                if (circuitCount == 3) {
                    resultLocation = ((Rectangle)optionalConflictingRectangle.get()).getTopLeft();
                    continue;
                }
                recommendedLocationForNorth = new Point(((Rectangle)optionalConflictingRectangle.get()).x - borderItemSize.width - 1, aboveTestPoint.y - aboveVerticalGap);
                continue;
            }
            resultLocation = aboveTestPoint;
        }
        if (resultLocation == null) {
            resultLocation = this.locateOnBorder(new Rectangle(recommendedLocationForNorth, borderItemSize), 1, circuitCount + 1, borderItem, portsFiguresToIgnore, additionalFiguresForConflictDetection);
        }
        return resultLocation;
    }

    protected Point locateOnParent(Rectangle suggestedLocation, int suggestedSide, IFigure borderItem) {
        Rectangle bounds = this.getParentBorder();
        int parentFigureWidth = bounds.width;
        int parentFigureHeight = bounds.height;
        int parentFigureX = bounds.x;
        int parentFigureY = bounds.y;
        Dimension borderItemSize = suggestedLocation.getSize();
        int newX = suggestedLocation.x;
        int newY = suggestedLocation.y;
        int westX = parentFigureX - borderItemSize.width + this.getBorderItemOffset().width;
        int eastX = parentFigureX + parentFigureWidth - this.getBorderItemOffset().width;
        int southY = parentFigureY + parentFigureHeight - this.getBorderItemOffset().height;
        int northY = parentFigureY - borderItemSize.height + this.getBorderItemOffset().height;
        if (suggestedSide == 8) {
            if (suggestedLocation.x != westX) {
                newX = westX;
            }
            if (suggestedLocation.y < parentFigureY) {
                newY = parentFigureY;
            } else if (suggestedLocation.y > bounds.getBottomLeft().y - borderItemSize.height) {
                newY = bounds.getBottomLeft().y - borderItemSize.height;
            }
        } else if (suggestedSide == 16) {
            if (suggestedLocation.x != eastX) {
                newX = eastX;
            }
            if (suggestedLocation.y < parentFigureY) {
                newY = parentFigureY;
            } else if (suggestedLocation.y > bounds.getBottomLeft().y - borderItemSize.height) {
                newY = bounds.getBottomLeft().y - borderItemSize.height;
            }
        } else if (suggestedSide == 4) {
            if (suggestedLocation.y != southY) {
                newY = southY;
            }
            if (borderItemSize.width > bounds.width) {
                newX = parentFigureX - (borderItemSize.width - bounds.width) / 2;
            } else if (suggestedLocation.x < parentFigureX) {
                newX = parentFigureX;
            } else if (suggestedLocation.x > bounds.getBottomRight().x - borderItemSize.width) {
                newX = bounds.getBottomRight().x - borderItemSize.width;
            }
        } else {
            if (suggestedLocation.y != northY) {
                newY = northY;
            }
            if (borderItemSize.width > bounds.width) {
                newX = parentFigureX - (borderItemSize.width - bounds.width) / 2;
            } else if (suggestedLocation.x < parentFigureX) {
                newX = parentFigureX;
            } else if (suggestedLocation.x > bounds.getBottomRight().x - borderItemSize.width) {
                newX = bounds.getBottomRight().x - borderItemSize.width;
            }
        }
        return new Point(newX, newY);
    }

    protected Option<Rectangle> conflicts(Rectangle recommendedRect, final IFigure targetBorderItem, Collection<IFigure> portsFiguresToIgnore, List<IFigure> additionalFiguresForConflictDetection) {
        Option<Rectangle> conflictedRectangle = this.conflicts(recommendedRect, this.getBrotherFigures(targetBorderItem), portsFiguresToIgnore);
        if (!conflictedRectangle.some() && additionalFiguresForConflictDetection != null && additionalFiguresForConflictDetection.size() > 0) {
            Iterable feedbackFigures = Iterables.transform(additionalFiguresForConflictDetection, (Function)new Function<IFigure, IFigure>(){

                public IFigure apply(IFigure input) {
                    Rectangle newBounds = new Rectangle(input.getBounds());
                    input.translateToAbsolute((Translatable)newBounds);
                    targetBorderItem.translateToRelative((Translatable)newBounds);
                    input.setBounds(newBounds);
                    return input;
                }
            });
            conflictedRectangle = this.conflicts(recommendedRect, Lists.newArrayList((Iterable)feedbackFigures), portsFiguresToIgnore);
            for (IFigure figure : additionalFiguresForConflictDetection) {
                Rectangle newBounds = new Rectangle(figure.getBounds());
                targetBorderItem.translateToAbsolute((Translatable)newBounds);
                figure.translateToRelative((Translatable)newBounds);
                figure.setBounds(newBounds);
            }
        }
        return conflictedRectangle;
    }

    protected List<IFigure> getBrotherFigures(IFigure targetBorderItem) {
        Iterable brotherFigures = Iterables.filter((Iterable)targetBorderItem.getParent().getChildren(), (Predicate)Predicates.and((Predicate)Predicates.instanceOf(IFigure.class), (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)targetBorderItem))));
        return Lists.newArrayList((Iterable)brotherFigures);
    }

    protected Option<Rectangle> conflicts(Rectangle recommendedRect, List<IFigure> figuresToCheck, Collection<IFigure> portsFiguresToIgnore) {
        ListIterator<IFigure> iterator = figuresToCheck.listIterator();
        while (iterator.hasNext()) {
            IFigure borderItem = iterator.next();
            if (portsFiguresToIgnore.contains(borderItem)) continue;
            boolean takeIntoAccount = true;
            if (borderItem.getParent().getLayoutManager() == null) {
                if (!(borderItem.getParent() instanceof Layer)) {
                    takeIntoAccount = false;
                }
            } else if (borderItem.getParent().getLayoutManager().getConstraint(borderItem) instanceof DBorderItemLocator) {
                DBorderItemLocator airBorderItemLocator = (DBorderItemLocator)((Object)borderItem.getParent().getLayoutManager().getConstraint(borderItem));
                boolean bl = takeIntoAccount = airBorderItemLocator.located && !airBorderItemLocator.borderItemHasMoved;
            }
            if (!borderItem.isVisible() || !takeIntoAccount) continue;
            Rectangle rect = new Rectangle(borderItem.getBounds());
            if (portsFiguresToIgnore.contains(borderItem) || !rect.intersects(recommendedRect)) continue;
            return Options.newSome((Object)rect);
        }
        return Options.newNone();
    }

    public void setConstraint(Rectangle theConstraint) {
        if (!theConstraint.equals((Object)this.getConstraint())) {
            this.borderItemHasMoved = true;
        }
        super.setConstraint(theConstraint);
    }

    public Rectangle getCurrentConstraint() {
        return super.getConstraint().getCopy();
    }

    public static int findClosestSideOfParent(Rectangle proposedLocation, Rectangle parentBorder) {
        int position;
        Point parentCenter = parentBorder.getCenter();
        Point childCenter = proposedLocation.getCenter();
        if (childCenter.x < parentCenter.x) {
            if (childCenter.y < parentCenter.y) {
                Point parentTopLeft = parentBorder.getTopLeft();
                position = childCenter.y < parentTopLeft.y ? 1 : (childCenter.x - parentTopLeft.x <= childCenter.y - parentTopLeft.y ? 8 : 1);
            } else {
                Point parentBottomLeft = parentBorder.getBottomLeft();
                position = childCenter.y > parentBottomLeft.y ? 4 : (childCenter.x - parentBottomLeft.x <= parentBottomLeft.y - childCenter.y ? 8 : 4);
            }
        } else if (childCenter.y < parentCenter.y) {
            Point parentTopRight = parentBorder.getTopRight();
            position = childCenter.y < parentTopRight.y ? 1 : (parentTopRight.x - childCenter.x <= childCenter.y - parentTopRight.y ? 16 : 1);
        } else {
            Point parentBottomRight = parentBorder.getBottomRight();
            position = childCenter.y > parentBottomRight.y ? 4 : (parentBottomRight.x - childCenter.x <= parentBottomRight.y - childCenter.y ? 16 : 4);
        }
        return position;
    }

    public Rectangle getValidLocation(Rectangle proposedLocation, IFigure borderItem) {
        int side = DBorderItemLocator.findClosestSideOfParent(proposedLocation, this.getParentBorder());
        ArrayList figuresToIgnore = Lists.newArrayList();
        figuresToIgnore.add(borderItem);
        Point newTopLeft = this.locateOnBorder(proposedLocation, side, 0, borderItem, figuresToIgnore, new ArrayList<IFigure>());
        Rectangle realLocation = proposedLocation.getCopy();
        realLocation.setLocation(newTopLeft);
        return realLocation;
    }

    public void unfix() {
        this.located = false;
    }

    public Rectangle getValidLocation(Rectangle proposedLocation, IFigure borderItem, Collection<IFigure> figuresToIgnore, List<IFigure> additionalFiguresForConflictDetection) {
        Rectangle realLocation = new Rectangle(proposedLocation);
        int side = DBorderItemLocator.findClosestSideOfParent(proposedLocation, this.getParentBorder());
        Point newTopLeft = this.locateOnBorder(proposedLocation, side, 0, borderItem, figuresToIgnore, additionalFiguresForConflictDetection);
        realLocation.setLocation(newTopLeft);
        return realLocation;
    }

    public void setFiguresToIgnoresDuringNextRelocate(List<IFigure> figuresToIgnore) {
        this.figuresToIgnoreDuringNextRelocate = figuresToIgnore;
    }

    public void resetBorderItemMovedState() {
        this.borderItemHasMoved = false;
    }
}

