/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.filter;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.helper.SelectionDescriptionHelper;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.TreeItemWrapper;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.DiagramFactory;
import org.eclipse.sirius.diagram.FilterVariableValue;
import org.eclipse.sirius.diagram.description.filter.FilterVariable;
import org.eclipse.sirius.diagram.description.filter.VariableFilter;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.tools.api.command.ui.UICallBack;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.description.SelectionDescription;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;

public final class FilterTools {
    private FilterTools() {
    }

    public static Map<String, EObject> askForFilterValues(DSemanticDiagram diagram, VariableFilter filter) throws InterruptedException {
        EObject model = diagram.getTarget();
        UICallBack uiCallback = SiriusEditPlugin.getPlugin().getUiCallback();
        if (diagram.getFilterVariableHistory() != null) {
            Iterator it = diagram.getFilterVariableHistory().getOwnedValues().iterator();
            while (it.hasNext()) {
                FilterVariableValue value = (FilterVariableValue)it.next();
                if (value.getVariableDefinition() != null && value.getModelElement() != null && !filter.getOwnedVariables().contains((Object)value.getVariableDefinition())) continue;
                it.remove();
            }
        }
        for (FilterVariable var : filter.getOwnedVariables()) {
            TreeItemWrapper input = new TreeItemWrapper(null, null);
            FilterTools.computeInput(diagram, model, var, input);
            if (!var.isMultiple()) {
                EObject modelElement = uiCallback.askForEObject(var.getMessage(), input, DiagramUIPlugin.getPlugin().getItemProvidersAdapterFactory());
                FilterVariableValue newValue = DiagramFactory.eINSTANCE.createFilterVariableValue();
                newValue.setModelElement(modelElement);
                newValue.setVariableDefinition(var);
                if (diagram.getFilterVariableHistory() == null) continue;
                diagram.getFilterVariableHistory().getOwnedValues().add((Object)newValue);
                continue;
            }
            BasicEList values = new BasicEList();
            Collection modelElements = uiCallback.askForEObjects(var.getMessage(), input, DiagramUIPlugin.getPlugin().getItemProvidersAdapterFactory());
            values.addAll(modelElements);
            BasicEList variables = new BasicEList();
            for (EObject modelElement : values) {
                FilterVariableValue newValue = DiagramFactory.eINSTANCE.createFilterVariableValue();
                newValue.setModelElement(modelElement);
                newValue.setVariableDefinition(var);
                variables.add((Object)newValue);
            }
            if (diagram.getFilterVariableHistory() == null) continue;
            diagram.getFilterVariableHistory().getOwnedValues().addAll((Collection)variables);
        }
        HashMap<String, EObject> variables = new HashMap<String, EObject>();
        if (diagram.getFilterVariableHistory() != null) {
            for (FilterVariableValue value : diagram.getFilterVariableHistory().getOwnedValues()) {
                variables.put(value.getVariableDefinition().getName(), value.getModelElement());
            }
        }
        return variables;
    }

    private static void computeInput(DSemanticDiagram diagram, EObject model, FilterVariable var, TreeItemWrapper input) {
        IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(model);
        if (var.getCandidatesExpression() != null) {
            interpreter.setVariable("diagram", (Object)diagram);
            SelectionDescriptionHelper.computeInput((SelectionDescription)var, (EObject)model, (IInterpreter)interpreter, (TreeItemWrapper)input);
            interpreter.unSetVariable("diagram");
        }
    }
}

